/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public abstract class FileObserver {
    public static final int ACCESS = 1;
    public static final int MODIFY = 2;
    public static final int ATTRIB = 4;
    public static final int CLOSE_WRITE = 8;
    public static final int CLOSE_NOWRITE = 16;
    public static final int OPEN = 32;
    public static final int MOVED_FROM = 64;
    public static final int MOVED_TO = 128;
    public static final int CREATE = 256;
    public static final int DELETE = 512;
    public static final int DELETE_SELF = 1024;
    public static final int MOVE_SELF = 2048;
    public static final int ALL_EVENTS = 4095;
    private static final String LOG_TAG = "FileObserver";
    private static ObserverThread s_observerThread = new ObserverThread();
    private String m_path;
    private Integer m_descriptor;
    private int m_mask;

    public FileObserver(String path) {
        this(path, 4095);
    }

    public FileObserver(String path, int mask) {
        this.m_path = path;
        this.m_mask = mask;
        this.m_descriptor = -1;
    }

    protected void finalize() {
        this.stopWatching();
    }

    public void startWatching() {
        if (this.m_descriptor < 0) {
            this.m_descriptor = s_observerThread.startWatching(this.m_path, this.m_mask, this);
        }
    }

    public void stopWatching() {
        if (this.m_descriptor >= 0) {
            s_observerThread.stopWatching(this.m_descriptor);
            this.m_descriptor = -1;
        }
    }

    public abstract void onEvent(int var1, String var2);

    static {
        s_observerThread.start();
    }

    private static class ObserverThread
    extends Thread {
        private HashMap<Integer, WeakReference> m_observers = new HashMap();
        private int m_fd = this.init();

        public ObserverThread() {
            super(FileObserver.LOG_TAG);
        }

        @Override
        public void run() {
            this.observe(this.m_fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int startWatching(String path, int mask, FileObserver observer) {
            int wfd = this.startWatching(this.m_fd, path, mask);
            Integer i = new Integer(wfd);
            if (wfd >= 0) {
                HashMap<Integer, WeakReference> hashMap = this.m_observers;
                synchronized (hashMap) {
                    this.m_observers.put(i, new WeakReference<FileObserver>(observer));
                }
            }
            return i;
        }

        public void stopWatching(int descriptor) {
            this.stopWatching(this.m_fd, descriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(int wfd, int mask, String path) {
            FileObserver observer = null;
            HashMap<Integer, WeakReference> hashMap = this.m_observers;
            synchronized (hashMap) {
                WeakReference weak = this.m_observers.get(wfd);
                if (weak != null && (observer = (FileObserver)weak.get()) == null) {
                    this.m_observers.remove(wfd);
                }
            }
            if (observer != null) {
                try {
                    observer.onEvent(mask, path);
                }
                catch (Throwable throwable) {
                    Log.wtf(FileObserver.LOG_TAG, "Unhandled exception in FileObserver " + observer, throwable);
                }
            }
        }

        private int init() {
            return OverrideMethod.invokeI("android.os.FileObserver$ObserverThread#init()I", true, this);
        }

        private void observe(int n) {
            OverrideMethod.invokeV("android.os.FileObserver$ObserverThread#observe(I)V", true, this);
        }

        private int startWatching(int n, String string2, int n2) {
            return OverrideMethod.invokeI("android.os.FileObserver$ObserverThread#startWatching(ILjava/lang/String;I)I", true, this);
        }

        private void stopWatching(int n, int n2) {
            OverrideMethod.invokeV("android.os.FileObserver$ObserverThread#stopWatching(II)V", true, this);
        }
    }
}

