/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.opengl.EGL14;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;

public class GraphicsEnvironment {
    private static final GraphicsEnvironment sInstance = new GraphicsEnvironment();
    private static final boolean DEBUG = false;
    private static final String TAG = "GraphicsEnvironment";
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private ClassLoader mClassLoader;
    private String mLayerPath;
    private String mDebugLayerPath;

    public static GraphicsEnvironment getInstance() {
        return sInstance;
    }

    public void setup(Context context) {
        this.setupGpuLayers(context);
        GraphicsEnvironment.chooseDriver(context);
    }

    private static boolean isDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) > 0;
    }

    public void setLayerPaths(ClassLoader classLoader, String layerPath, String debugLayerPath) {
        this.mClassLoader = classLoader;
        this.mLayerPath = layerPath;
        this.mDebugLayerPath = debugLayerPath;
    }

    private void setupGpuLayers(Context context) {
        int enable;
        String layerPaths = "";
        if (GraphicsEnvironment.isDebuggable(context) && (enable = Settings.Global.getInt(context.getContentResolver(), "enable_gpu_debug_layers", 0)) != 0) {
            String gpuDebugApp = Settings.Global.getString(context.getContentResolver(), "gpu_debug_app");
            String packageName = context.getPackageName();
            if (gpuDebugApp != null && packageName != null && !gpuDebugApp.isEmpty() && !packageName.isEmpty() && gpuDebugApp.equals(packageName)) {
                Log.i(TAG, "GPU debug layers enabled for " + packageName);
                layerPaths = this.mDebugLayerPath + ":";
                String layers = Settings.Global.getString(context.getContentResolver(), "gpu_debug_layers");
                Log.i(TAG, "Debug layer list: " + layers);
                if (layers != null && !layers.isEmpty()) {
                    GraphicsEnvironment.setDebugLayers(layers);
                }
            }
        }
        layerPaths = layerPaths + this.mLayerPath;
        GraphicsEnvironment.setLayerPaths(this.mClassLoader, layerPaths);
    }

    private static void chooseDriver(Context context) {
        ApplicationInfo driverInfo;
        String driverPackageName = SystemProperties.get(PROPERTY_GFX_DRIVER);
        if (driverPackageName == null || driverPackageName.isEmpty()) {
            return;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return;
        }
        try {
            driverInfo = context.getPackageManager().getApplicationInfo(driverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "driver package '" + driverPackageName + "' not installed");
            return;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverInfo);
        if (abi == null) {
            return;
        }
        if (driverInfo.targetSdkVersion < 26) {
            Log.w(TAG, "updated driver package is not known to be compatible with O");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        GraphicsEnvironment.setDriverPath(paths);
    }

    public static void earlyInitEGL() {
        Thread eglInitThread = new Thread(() -> EGL14.eglGetDisplay(0), "EGL Init");
        eglInitThread.start();
    }

    private static String chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static void setLayerPaths(ClassLoader classLoader, String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setLayerPaths(Ljava/lang/ClassLoader;Ljava/lang/String;)V", true, null);
    }

    private static void setDebugLayers(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDebugLayers(Ljava/lang/String;)V", true, null);
    }

    private static void setDriverPath(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDriverPath(Ljava/lang/String;)V", true, null);
    }
}

