/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;

public class ScheduleCalendar {
    public static final String TAG = "ScheduleCalendar";
    public static final boolean DEBUG = Log.isLoggable("ConditionProviders", 3);
    private final ArraySet<Integer> mDays = new ArraySet();
    private final Calendar mCalendar = Calendar.getInstance();
    private ZenModeConfig.ScheduleInfo mSchedule;

    public String toString() {
        return "ScheduleCalendar[mDays=" + this.mDays + ", mSchedule=" + this.mSchedule + "]";
    }

    public boolean exitAtAlarm() {
        return this.mSchedule.exitAtAlarm;
    }

    public void setSchedule(ZenModeConfig.ScheduleInfo schedule) {
        if (Objects.equals(this.mSchedule, schedule)) {
            return;
        }
        this.mSchedule = schedule;
        this.updateDays();
    }

    public void maybeSetNextAlarm(long now, long nextAlarm) {
        if (this.mSchedule != null && this.mSchedule.exitAtAlarm) {
            if (nextAlarm == 0L) {
                this.mSchedule.nextAlarm = 0L;
            }
            if (nextAlarm > now) {
                this.mSchedule.nextAlarm = this.mSchedule.nextAlarm == 0L ? nextAlarm : Math.min(this.mSchedule.nextAlarm, nextAlarm);
            } else if (this.mSchedule.nextAlarm < now) {
                if (DEBUG) {
                    Log.d(TAG, "All alarms are in the past " + this.mSchedule.nextAlarm);
                }
                this.mSchedule.nextAlarm = 0L;
            }
        }
    }

    public void setTimeZone(TimeZone tz) {
        this.mCalendar.setTimeZone(tz);
    }

    public long getNextChangeTime(long now) {
        if (this.mSchedule == null) {
            return 0L;
        }
        long nextStart = this.getNextTime(now, this.mSchedule.startHour, this.mSchedule.startMinute);
        long nextEnd = this.getNextTime(now, this.mSchedule.endHour, this.mSchedule.endMinute);
        long nextScheduleTime = Math.min(nextStart, nextEnd);
        return nextScheduleTime;
    }

    private long getNextTime(long now, int hr, int min) {
        long time = this.getTime(now, hr, min);
        return time <= now ? this.addDays(time, 1) : time;
    }

    private long getTime(long millis, int hour, int min) {
        this.mCalendar.setTimeInMillis(millis);
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, min);
        this.mCalendar.set(13, 0);
        this.mCalendar.set(14, 0);
        return this.mCalendar.getTimeInMillis();
    }

    public boolean isInSchedule(long time) {
        if (this.mSchedule == null || this.mDays.size() == 0) {
            return false;
        }
        long start = this.getTime(time, this.mSchedule.startHour, this.mSchedule.startMinute);
        long end = this.getTime(time, this.mSchedule.endHour, this.mSchedule.endMinute);
        if (end <= start) {
            end = this.addDays(end, 1);
        }
        return this.isInSchedule(-1, time, start, end) || this.isInSchedule(0, time, start, end);
    }

    public boolean isAlarmInSchedule(long alarm, long now) {
        if (this.mSchedule == null || this.mDays.size() == 0) {
            return false;
        }
        long start = this.getTime(alarm, this.mSchedule.startHour, this.mSchedule.startMinute);
        long end = this.getTime(alarm, this.mSchedule.endHour, this.mSchedule.endMinute);
        if (end <= start) {
            end = this.addDays(end, 1);
        }
        return this.isInSchedule(-1, alarm, start, end) && this.isInSchedule(-1, now, start, end) || this.isInSchedule(0, alarm, start, end) && this.isInSchedule(0, now, start, end);
    }

    public boolean shouldExitForAlarm(long time) {
        if (this.mSchedule == null) {
            return false;
        }
        return this.mSchedule.exitAtAlarm && this.mSchedule.nextAlarm != 0L && time >= this.mSchedule.nextAlarm && this.isAlarmInSchedule(this.mSchedule.nextAlarm, time);
    }

    private boolean isInSchedule(int daysOffset, long time, long start, long end) {
        int n = 7;
        int day = (this.getDayOfWeek(time) - 1 + daysOffset % 7 + 7) % 7 + 1;
        start = this.addDays(start, daysOffset);
        end = this.addDays(end, daysOffset);
        return this.mDays.contains(day) && time >= start && time < end;
    }

    private int getDayOfWeek(long time) {
        this.mCalendar.setTimeInMillis(time);
        return this.mCalendar.get(7);
    }

    private void updateDays() {
        this.mDays.clear();
        if (this.mSchedule != null && this.mSchedule.days != null) {
            for (int i = 0; i < this.mSchedule.days.length; ++i) {
                this.mDays.add(this.mSchedule.days[i]);
            }
        }
    }

    private long addDays(long time, int days) {
        this.mCalendar.setTimeInMillis(time);
        this.mCalendar.add(5, days);
        return this.mCalendar.getTimeInMillis();
    }
}

