/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PhysicalChannelConfig
implements Parcelable {
    public static final int CONNECTION_PRIMARY_SERVING = 1;
    public static final int CONNECTION_SECONDARY_SERVING = 2;
    public static final int CONNECTION_UNKNOWN = Integer.MAX_VALUE;
    private int mCellConnectionStatus;
    private int mCellBandwidthDownlinkKhz;
    public static final Parcelable.Creator<PhysicalChannelConfig> CREATOR = new Parcelable.Creator<PhysicalChannelConfig>(){

        @Override
        public PhysicalChannelConfig createFromParcel(Parcel in) {
            return new PhysicalChannelConfig(in);
        }

        public PhysicalChannelConfig[] newArray(int size) {
            return new PhysicalChannelConfig[size];
        }
    };

    public PhysicalChannelConfig(int status, int bandwidth) {
        this.mCellConnectionStatus = status;
        this.mCellBandwidthDownlinkKhz = bandwidth;
    }

    public PhysicalChannelConfig(Parcel in) {
        this.mCellConnectionStatus = in.readInt();
        this.mCellBandwidthDownlinkKhz = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCellConnectionStatus);
        dest.writeInt(this.mCellBandwidthDownlinkKhz);
    }

    public int getCellBandwidthDownlink() {
        return this.mCellBandwidthDownlinkKhz;
    }

    public int getConnectionStatus() {
        return this.mCellConnectionStatus;
    }

    private String getConnectionStatusString() {
        switch (this.mCellConnectionStatus) {
            case 1: {
                return "PrimaryServing";
            }
            case 2: {
                return "SecondaryServing";
            }
            case 0x7FFFFFFF: {
                return "Unknown";
            }
        }
        return "Invalid(" + this.mCellConnectionStatus + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhysicalChannelConfig)) {
            return false;
        }
        PhysicalChannelConfig config = (PhysicalChannelConfig)o;
        return this.mCellConnectionStatus == config.mCellConnectionStatus && this.mCellBandwidthDownlinkKhz == config.mCellBandwidthDownlinkKhz;
    }

    public int hashCode() {
        return this.mCellBandwidthDownlinkKhz * 29 + this.mCellConnectionStatus * 31;
    }

    public String toString() {
        return "{mConnectionStatus=" + this.getConnectionStatusString() + ",mCellBandwidthDownlinkKhz=" + this.mCellBandwidthDownlinkKhz + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionStatus {
    }
}

