/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.net.LinkProperties;
import android.os.Parcel;
import android.os.Parcelable;

public class PreciseDataConnectionState
implements Parcelable {
    private int mState = -1;
    private int mNetworkType = 0;
    private String mAPNType = "";
    private String mAPN = "";
    private String mReason = "";
    private LinkProperties mLinkProperties = null;
    private String mFailCause = "";
    public static final Parcelable.Creator<PreciseDataConnectionState> CREATOR = new Parcelable.Creator<PreciseDataConnectionState>(){

        @Override
        public PreciseDataConnectionState createFromParcel(Parcel in) {
            return new PreciseDataConnectionState(in);
        }

        public PreciseDataConnectionState[] newArray(int size) {
            return new PreciseDataConnectionState[size];
        }
    };

    public PreciseDataConnectionState(int state, int networkType, String apnType, String apn, String reason, LinkProperties linkProperties, String failCause) {
        this.mState = state;
        this.mNetworkType = networkType;
        this.mAPNType = apnType;
        this.mAPN = apn;
        this.mReason = reason;
        this.mLinkProperties = linkProperties;
        this.mFailCause = failCause;
    }

    public PreciseDataConnectionState() {
    }

    private PreciseDataConnectionState(Parcel in) {
        this.mState = in.readInt();
        this.mNetworkType = in.readInt();
        this.mAPNType = in.readString();
        this.mAPN = in.readString();
        this.mReason = in.readString();
        this.mLinkProperties = (LinkProperties)in.readParcelable(null);
        this.mFailCause = in.readString();
    }

    public int getDataConnectionState() {
        return this.mState;
    }

    public int getDataConnectionNetworkType() {
        return this.mNetworkType;
    }

    public String getDataConnectionAPNType() {
        return this.mAPNType;
    }

    public String getDataConnectionAPN() {
        return this.mAPN;
    }

    public String getDataConnectionChangeReason() {
        return this.mReason;
    }

    public LinkProperties getDataConnectionLinkProperties() {
        return this.mLinkProperties;
    }

    public String getDataConnectionFailCause() {
        return this.mFailCause;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mState);
        out.writeInt(this.mNetworkType);
        out.writeString(this.mAPNType);
        out.writeString(this.mAPN);
        out.writeString(this.mReason);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeString(this.mFailCause);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mState;
        result = 31 * result + this.mNetworkType;
        result = 31 * result + (this.mAPNType == null ? 0 : this.mAPNType.hashCode());
        result = 31 * result + (this.mAPN == null ? 0 : this.mAPN.hashCode());
        result = 31 * result + (this.mReason == null ? 0 : this.mReason.hashCode());
        result = 31 * result + (this.mLinkProperties == null ? 0 : this.mLinkProperties.hashCode());
        result = 31 * result + (this.mFailCause == null ? 0 : this.mFailCause.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreciseDataConnectionState other = (PreciseDataConnectionState)obj;
        if (this.mAPN == null ? other.mAPN != null : !this.mAPN.equals(other.mAPN)) {
            return false;
        }
        if (this.mAPNType == null ? other.mAPNType != null : !this.mAPNType.equals(other.mAPNType)) {
            return false;
        }
        if (this.mFailCause == null ? other.mFailCause != null : !this.mFailCause.equals(other.mFailCause)) {
            return false;
        }
        if (this.mLinkProperties == null ? other.mLinkProperties != null : !this.mLinkProperties.equals(other.mLinkProperties)) {
            return false;
        }
        if (this.mNetworkType != other.mNetworkType) {
            return false;
        }
        if (this.mReason == null ? other.mReason != null : !this.mReason.equals(other.mReason)) {
            return false;
        }
        return this.mState == other.mState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data Connection state: " + this.mState);
        sb.append(", Network type: " + this.mNetworkType);
        sb.append(", APN type: " + this.mAPNType);
        sb.append(", APN: " + this.mAPN);
        sb.append(", Change reason: " + this.mReason);
        sb.append(", Link properties: " + this.mLinkProperties);
        sb.append(", Fail cause: " + this.mFailCause);
        return sb.toString();
    }
}

