/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class SignalStrength
implements Parcelable {
    private static final String LOG_TAG = "SignalStrength";
    private static final boolean DBG = false;
    public static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int SIGNAL_STRENGTH_POOR = 1;
    public static final int SIGNAL_STRENGTH_MODERATE = 2;
    public static final int SIGNAL_STRENGTH_GOOD = 3;
    public static final int SIGNAL_STRENGTH_GREAT = 4;
    public static final int NUM_SIGNAL_STRENGTH_BINS = 5;
    public static final String[] SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
    public static final int INVALID = Integer.MAX_VALUE;
    private static final int LTE_RSRP_THRESHOLDS_NUM = 4;
    private static final int MAX_LTE_RSRP = -44;
    private static final int MIN_LTE_RSRP = -140;
    private static final int WCDMA_RSCP_THRESHOLDS_NUM = 4;
    private static final int MAX_WCDMA_RSCP = -24;
    private static final int MIN_WCDMA_RSCP = -120;
    private static final String MEASUMENT_TYPE_RSCP = "rscp";
    private int mGsmSignalStrength;
    private int mGsmBitErrorRate;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    private int mLteSignalStrength;
    private int mLteRsrp;
    private int mLteRsrq;
    private int mLteRssnr;
    private int mLteCqi;
    private int mTdScdmaRscp;
    private int mWcdmaSignalStrength;
    private int mWcdmaRscpAsu;
    private int mWcdmaRscp;
    private int mLteRsrpBoost;
    private boolean mIsGsm;
    private boolean mUseOnlyRsrpForLteLevel;
    private int[] mLteRsrpThresholds = new int[4];
    private String mWcdmaDefaultSignalMeasurement;
    private int[] mWcdmaRscpThresholds = new int[4];
    public static final Parcelable.Creator<SignalStrength> CREATOR = new Parcelable.Creator(){

        public SignalStrength createFromParcel(Parcel in) {
            return new SignalStrength(in);
        }

        public SignalStrength[] newArray(int size) {
            return new SignalStrength[size];
        }
    };

    public static SignalStrength newFromBundle(Bundle m) {
        SignalStrength ret = new SignalStrength();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    public SignalStrength() {
        this(true);
    }

    public SignalStrength(boolean gsmFlag) {
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaSignalStrength = 99;
        this.mWcdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaRscpAsu = 255;
        this.mLteRsrpBoost = 0;
        this.mIsGsm = gsmFlag;
        this.mUseOnlyRsrpForLteLevel = false;
        this.mWcdmaDefaultSignalMeasurement = "";
        this.setLteRsrpThresholds(this.getDefaultLteRsrpThresholds());
        this.setWcdmaRscpThresholds(this.getDefaultWcdmaRscpThresholds());
    }

    public SignalStrength(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp, int wcdmaSignalStrength, int wcdmaRscpAsu, int lteRsrpBoost, boolean gsmFlag, boolean lteLevelBaseOnRsrp, String wcdmaDefaultMeasurement) {
        this.mGsmSignalStrength = gsmSignalStrength;
        this.mGsmBitErrorRate = gsmBitErrorRate;
        this.mCdmaDbm = cdmaDbm;
        this.mCdmaEcio = cdmaEcio;
        this.mEvdoDbm = evdoDbm;
        this.mEvdoEcio = evdoEcio;
        this.mEvdoSnr = evdoSnr;
        this.mLteSignalStrength = lteSignalStrength;
        this.mLteRsrp = lteRsrp;
        this.mLteRsrq = lteRsrq;
        this.mLteRssnr = lteRssnr;
        this.mLteCqi = lteCqi;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaSignalStrength = wcdmaSignalStrength;
        this.mWcdmaRscpAsu = wcdmaRscpAsu;
        this.mWcdmaRscp = wcdmaRscpAsu - 120;
        this.mLteRsrpBoost = lteRsrpBoost;
        this.mIsGsm = gsmFlag;
        this.mUseOnlyRsrpForLteLevel = lteLevelBaseOnRsrp;
        this.mWcdmaDefaultSignalMeasurement = wcdmaDefaultMeasurement;
        this.setLteRsrpThresholds(this.getDefaultLteRsrpThresholds());
        this.setWcdmaRscpThresholds(this.getDefaultWcdmaRscpThresholds());
    }

    public SignalStrength(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp) {
        this(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi, tdScdmaRscp, 99, Integer.MAX_VALUE, 0, true, false, "");
    }

    public SignalStrength(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp, int wcdmaSignalStrength, int wcdmaRscp) {
        this(gsmSignalStrength, gsmBitErrorRate, cdmaDbm, cdmaEcio, evdoDbm, evdoEcio, evdoSnr, lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi, tdScdmaRscp, wcdmaSignalStrength, wcdmaRscp, 0, true, false, "");
    }

    public SignalStrength(SignalStrength s) {
        this.copyFrom(s);
    }

    protected void copyFrom(SignalStrength s) {
        this.mGsmSignalStrength = s.mGsmSignalStrength;
        this.mGsmBitErrorRate = s.mGsmBitErrorRate;
        this.mCdmaDbm = s.mCdmaDbm;
        this.mCdmaEcio = s.mCdmaEcio;
        this.mEvdoDbm = s.mEvdoDbm;
        this.mEvdoEcio = s.mEvdoEcio;
        this.mEvdoSnr = s.mEvdoSnr;
        this.mLteSignalStrength = s.mLteSignalStrength;
        this.mLteRsrp = s.mLteRsrp;
        this.mLteRsrq = s.mLteRsrq;
        this.mLteRssnr = s.mLteRssnr;
        this.mLteCqi = s.mLteCqi;
        this.mTdScdmaRscp = s.mTdScdmaRscp;
        this.mWcdmaSignalStrength = s.mWcdmaSignalStrength;
        this.mWcdmaRscpAsu = s.mWcdmaRscpAsu;
        this.mWcdmaRscp = s.mWcdmaRscp;
        this.mLteRsrpBoost = s.mLteRsrpBoost;
        this.mIsGsm = s.mIsGsm;
        this.mUseOnlyRsrpForLteLevel = s.mUseOnlyRsrpForLteLevel;
        this.mWcdmaDefaultSignalMeasurement = s.mWcdmaDefaultSignalMeasurement;
        this.setLteRsrpThresholds(s.mLteRsrpThresholds);
        this.setWcdmaRscpThresholds(s.mWcdmaRscpThresholds);
    }

    public SignalStrength(Parcel in) {
        this.mGsmSignalStrength = in.readInt();
        this.mGsmBitErrorRate = in.readInt();
        this.mCdmaDbm = in.readInt();
        this.mCdmaEcio = in.readInt();
        this.mEvdoDbm = in.readInt();
        this.mEvdoEcio = in.readInt();
        this.mEvdoSnr = in.readInt();
        this.mLteSignalStrength = in.readInt();
        this.mLteRsrp = in.readInt();
        this.mLteRsrq = in.readInt();
        this.mLteRssnr = in.readInt();
        this.mLteCqi = in.readInt();
        this.mTdScdmaRscp = in.readInt();
        this.mWcdmaSignalStrength = in.readInt();
        this.mWcdmaRscpAsu = in.readInt();
        this.mWcdmaRscp = in.readInt();
        this.mLteRsrpBoost = in.readInt();
        this.mIsGsm = in.readBoolean();
        this.mUseOnlyRsrpForLteLevel = in.readBoolean();
        this.mWcdmaDefaultSignalMeasurement = in.readString();
        in.readIntArray(this.mLteRsrpThresholds);
        in.readIntArray(this.mWcdmaRscpThresholds);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mGsmSignalStrength);
        out.writeInt(this.mGsmBitErrorRate);
        out.writeInt(this.mCdmaDbm);
        out.writeInt(this.mCdmaEcio);
        out.writeInt(this.mEvdoDbm);
        out.writeInt(this.mEvdoEcio);
        out.writeInt(this.mEvdoSnr);
        out.writeInt(this.mLteSignalStrength);
        out.writeInt(this.mLteRsrp);
        out.writeInt(this.mLteRsrq);
        out.writeInt(this.mLteRssnr);
        out.writeInt(this.mLteCqi);
        out.writeInt(this.mTdScdmaRscp);
        out.writeInt(this.mWcdmaSignalStrength);
        out.writeInt(this.mWcdmaRscpAsu);
        out.writeInt(this.mWcdmaRscp);
        out.writeInt(this.mLteRsrpBoost);
        out.writeBoolean(this.mIsGsm);
        out.writeBoolean(this.mUseOnlyRsrpForLteLevel);
        out.writeString(this.mWcdmaDefaultSignalMeasurement);
        out.writeIntArray(this.mLteRsrpThresholds);
        out.writeIntArray(this.mWcdmaRscpThresholds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void validateInput() {
        this.mGsmSignalStrength = this.mGsmSignalStrength >= 0 ? this.mGsmSignalStrength : 99;
        this.mWcdmaSignalStrength = this.mWcdmaSignalStrength >= 0 ? this.mWcdmaSignalStrength : 99;
        this.mLteSignalStrength = this.mLteSignalStrength >= 0 ? this.mLteSignalStrength : 99;
        this.mWcdmaRscpAsu = this.mWcdmaRscpAsu - 120 >= -120 && this.mWcdmaRscpAsu - 120 <= -24 ? this.mWcdmaRscpAsu : 255;
        this.mWcdmaRscp = this.mWcdmaRscp >= -120 && this.mWcdmaRscp <= -24 ? this.mWcdmaRscp : Integer.MAX_VALUE;
        this.mCdmaDbm = this.mCdmaDbm > 0 ? -this.mCdmaDbm : -120;
        this.mCdmaEcio = this.mCdmaEcio >= 0 ? -this.mCdmaEcio : -160;
        this.mEvdoDbm = this.mEvdoDbm > 0 ? -this.mEvdoDbm : -120;
        this.mEvdoEcio = this.mEvdoEcio >= 0 ? -this.mEvdoEcio : -160;
        this.mEvdoSnr = this.mEvdoSnr >= 0 && this.mEvdoSnr <= 8 ? this.mEvdoSnr : -1;
        this.mLteRsrp = -this.mLteRsrp >= -140 && -this.mLteRsrp <= -44 ? -this.mLteRsrp : Integer.MAX_VALUE;
        this.mLteRsrq = this.mLteRsrq >= 3 && this.mLteRsrq <= 20 ? -this.mLteRsrq : Integer.MAX_VALUE;
        this.mLteRssnr = this.mLteRssnr >= -200 && this.mLteRssnr <= 300 ? this.mLteRssnr : Integer.MAX_VALUE;
        this.mTdScdmaRscp = this.mTdScdmaRscp >= 0 && this.mTdScdmaRscp <= 96 ? this.mTdScdmaRscp - 120 : Integer.MAX_VALUE;
    }

    public void fixType() {
        this.mIsGsm = this.getCdmaRelatedSignalStrength() == 0;
    }

    public void setGsm(boolean gsmFlag) {
        this.mIsGsm = gsmFlag;
    }

    public void setUseOnlyRsrpForLteLevel(boolean useOnlyRsrpForLteLevel) {
        this.mUseOnlyRsrpForLteLevel = useOnlyRsrpForLteLevel;
    }

    public void setWcdmaDefaultSignalMeasurement(String defaultMeasurement) {
        this.mWcdmaDefaultSignalMeasurement = defaultMeasurement;
    }

    public void setLteRsrpBoost(int lteRsrpBoost) {
        this.mLteRsrpBoost = lteRsrpBoost;
    }

    public void setLteRsrpThresholds(int[] lteRsrpThresholds) {
        if (lteRsrpThresholds == null || lteRsrpThresholds.length != 4) {
            Log.wtf(LOG_TAG, "setLteRsrpThresholds - lteRsrpThresholds is invalid.");
            return;
        }
        System.arraycopy(lteRsrpThresholds, 0, this.mLteRsrpThresholds, 0, 4);
    }

    public int getGsmSignalStrength() {
        return this.mGsmSignalStrength;
    }

    public int getGsmBitErrorRate() {
        return this.mGsmBitErrorRate;
    }

    public void setWcdmaRscpThresholds(int[] wcdmaRscpThresholds) {
        if (wcdmaRscpThresholds == null || wcdmaRscpThresholds.length != 4) {
            Log.wtf(LOG_TAG, "setWcdmaRscpThresholds - wcdmaRscpThresholds is invalid.");
            return;
        }
        System.arraycopy(wcdmaRscpThresholds, 0, this.mWcdmaRscpThresholds, 0, 4);
    }

    public int getCdmaDbm() {
        return this.mCdmaDbm;
    }

    public int getCdmaEcio() {
        return this.mCdmaEcio;
    }

    public int getEvdoDbm() {
        return this.mEvdoDbm;
    }

    public int getEvdoEcio() {
        return this.mEvdoEcio;
    }

    public int getEvdoSnr() {
        return this.mEvdoSnr;
    }

    public int getLteSignalStrength() {
        return this.mLteSignalStrength;
    }

    public int getLteRsrp() {
        return this.mLteRsrp;
    }

    public int getLteRsrq() {
        return this.mLteRsrq;
    }

    public int getLteRssnr() {
        return this.mLteRssnr;
    }

    public int getLteCqi() {
        return this.mLteCqi;
    }

    public int getLteRsrpBoost() {
        return this.mLteRsrpBoost;
    }

    public int getLevel() {
        int level = this.mIsGsm ? this.getGsmRelatedSignalStrength() : this.getCdmaRelatedSignalStrength();
        return level;
    }

    public int getAsuLevel() {
        int asuLevel = 0;
        if (this.mIsGsm) {
            asuLevel = this.mLteRsrp != Integer.MAX_VALUE ? this.getLteAsuLevel() : (this.mTdScdmaRscp != Integer.MAX_VALUE ? this.getTdScdmaAsuLevel() : (this.mWcdmaRscp != Integer.MAX_VALUE ? this.getWcdmaAsuLevel() : this.getGsmAsuLevel()));
        } else {
            int cdmaAsuLevel = this.getCdmaAsuLevel();
            int evdoAsuLevel = this.getEvdoAsuLevel();
            asuLevel = evdoAsuLevel == 0 ? cdmaAsuLevel : (cdmaAsuLevel == 0 ? evdoAsuLevel : (cdmaAsuLevel < evdoAsuLevel ? cdmaAsuLevel : evdoAsuLevel));
        }
        return asuLevel;
    }

    public int getDbm() {
        int dBm = Integer.MAX_VALUE;
        if (this.isGsm()) {
            dBm = this.getLteDbm();
            if (dBm == Integer.MAX_VALUE) {
                dBm = this.getTdScdmaLevel() == 0 ? (this.getWcdmaDbm() == Integer.MAX_VALUE ? this.getGsmDbm() : this.getWcdmaDbm()) : this.getTdScdmaDbm();
            }
        } else {
            int cdmaDbm = this.getCdmaDbm();
            int evdoDbm = this.getEvdoDbm();
            return evdoDbm == -120 ? cdmaDbm : (cdmaDbm == -120 ? evdoDbm : (cdmaDbm < evdoDbm ? cdmaDbm : evdoDbm));
        }
        return dBm;
    }

    public int getGsmDbm() {
        int gsmSignalStrength = this.getGsmSignalStrength();
        int asu = gsmSignalStrength == 99 ? -1 : gsmSignalStrength;
        int dBm = asu != -1 ? -113 + 2 * asu : -1;
        return dBm;
    }

    public int getGsmLevel() {
        int asu = this.getGsmSignalStrength();
        int level = asu <= 2 || asu == 99 ? 0 : (asu >= 12 ? 4 : (asu >= 8 ? 3 : (asu >= 5 ? 2 : 1)));
        return level;
    }

    public int getGsmAsuLevel() {
        int level = this.getGsmSignalStrength();
        return level;
    }

    public int getCdmaLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int levelDbm = cdmaDbm >= -75 ? 4 : (cdmaDbm >= -85 ? 3 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 0)));
        int levelEcio = cdmaEcio >= -90 ? 4 : (cdmaEcio >= -110 ? 3 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 0)));
        int level = levelDbm < levelEcio ? levelDbm : levelEcio;
        return level;
    }

    public int getCdmaAsuLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int cdmaAsuLevel = cdmaDbm >= -75 ? 16 : (cdmaDbm >= -82 ? 8 : (cdmaDbm >= -90 ? 4 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 99))));
        int ecioAsuLevel = cdmaEcio >= -90 ? 16 : (cdmaEcio >= -100 ? 8 : (cdmaEcio >= -115 ? 4 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 99))));
        int level = cdmaAsuLevel < ecioAsuLevel ? cdmaAsuLevel : ecioAsuLevel;
        return level;
    }

    public int getEvdoLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0)));
        int levelEvdoSnr = evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0)));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    public int getEvdoAsuLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 16 : (evdoDbm >= -75 ? 8 : (evdoDbm >= -85 ? 4 : (evdoDbm >= -95 ? 2 : (evdoDbm >= -105 ? 1 : 99))));
        int levelEvdoSnr = evdoSnr >= 7 ? 16 : (evdoSnr >= 6 ? 8 : (evdoSnr >= 5 ? 4 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 99))));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    public int getLteDbm() {
        return this.mLteRsrp;
    }

    public int getLteLevel() {
        int rssiIconLevel = 0;
        int rsrpIconLevel = -1;
        int snrIconLevel = -1;
        if (this.mLteRsrp > -44 || this.mLteRsrp < -140) {
            if (this.mLteRsrp != Integer.MAX_VALUE) {
                Log.wtf(LOG_TAG, "getLteLevel - invalid lte rsrp: mLteRsrp=" + this.mLteRsrp);
            }
        } else {
            rsrpIconLevel = this.mLteRsrp >= this.mLteRsrpThresholds[3] - this.mLteRsrpBoost ? 4 : (this.mLteRsrp >= this.mLteRsrpThresholds[2] - this.mLteRsrpBoost ? 3 : (this.mLteRsrp >= this.mLteRsrpThresholds[1] - this.mLteRsrpBoost ? 2 : (this.mLteRsrp >= this.mLteRsrpThresholds[0] - this.mLteRsrpBoost ? 1 : 0)));
        }
        if (this.useOnlyRsrpForLteLevel()) {
            SignalStrength.log("getLTELevel - rsrp = " + rsrpIconLevel);
            if (rsrpIconLevel != -1) {
                return rsrpIconLevel;
            }
        }
        if (this.mLteRssnr > 300) {
            snrIconLevel = -1;
        } else if (this.mLteRssnr >= 130) {
            snrIconLevel = 4;
        } else if (this.mLteRssnr >= 45) {
            snrIconLevel = 3;
        } else if (this.mLteRssnr >= 10) {
            snrIconLevel = 2;
        } else if (this.mLteRssnr >= -30) {
            snrIconLevel = 1;
        } else if (this.mLteRssnr >= -200) {
            snrIconLevel = 0;
        }
        if (snrIconLevel != -1 && rsrpIconLevel != -1) {
            return rsrpIconLevel < snrIconLevel ? rsrpIconLevel : snrIconLevel;
        }
        if (snrIconLevel != -1) {
            return snrIconLevel;
        }
        if (rsrpIconLevel != -1) {
            return rsrpIconLevel;
        }
        if (this.mLteSignalStrength > 63) {
            rssiIconLevel = 0;
        } else if (this.mLteSignalStrength >= 12) {
            rssiIconLevel = 4;
        } else if (this.mLteSignalStrength >= 8) {
            rssiIconLevel = 3;
        } else if (this.mLteSignalStrength >= 5) {
            rssiIconLevel = 2;
        } else if (this.mLteSignalStrength >= 0) {
            rssiIconLevel = 1;
        }
        return rssiIconLevel;
    }

    public int getLteAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.getLteDbm();
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 255 : lteDbm + 140;
        return lteAsuLevel;
    }

    public boolean isGsm() {
        return this.mIsGsm;
    }

    public boolean useOnlyRsrpForLteLevel() {
        return this.mUseOnlyRsrpForLteLevel;
    }

    public int getTdScdmaDbm() {
        return this.mTdScdmaRscp;
    }

    public int getTdScdmaLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int level = tdScdmaDbm > -25 || tdScdmaDbm == Integer.MAX_VALUE ? 0 : (tdScdmaDbm >= -49 ? 4 : (tdScdmaDbm >= -73 ? 3 : (tdScdmaDbm >= -97 ? 2 : (tdScdmaDbm >= -110 ? 1 : 0))));
        return level;
    }

    public int getTdScdmaAsuLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int tdScdmaAsuLevel = tdScdmaDbm == Integer.MAX_VALUE ? 255 : tdScdmaDbm + 120;
        return tdScdmaAsuLevel;
    }

    public int getWcdmaRscp() {
        return this.mWcdmaRscp;
    }

    public int getWcdmaAsuLevel() {
        int wcdmaDbm = this.getWcdmaDbm();
        int wcdmaAsuLevel = 255;
        wcdmaAsuLevel = wcdmaDbm == Integer.MAX_VALUE ? 255 : wcdmaDbm + 120;
        return wcdmaAsuLevel;
    }

    public int getWcdmaDbm() {
        return this.mWcdmaRscp;
    }

    public int getWcdmaLevel() {
        int level = 0;
        if (this.mWcdmaDefaultSignalMeasurement == null) {
            Log.wtf(LOG_TAG, "getWcdmaLevel - WCDMA default signal measurement is invalid.");
            return level;
        }
        switch (this.mWcdmaDefaultSignalMeasurement) {
            case "rscp": {
                if (this.mWcdmaRscp < -120 || this.mWcdmaRscp > -24) {
                    if (this.mWcdmaRscp == Integer.MAX_VALUE) break;
                    Log.wtf(LOG_TAG, "getWcdmaLevel - invalid WCDMA RSCP: mWcdmaRscp=" + this.mWcdmaRscp);
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[3]) {
                    level = 4;
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[2]) {
                    level = 3;
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[1]) {
                    level = 2;
                    break;
                }
                if (this.mWcdmaRscp < this.mWcdmaRscpThresholds[0]) break;
                level = 1;
                break;
            }
            default: {
                if (this.mWcdmaSignalStrength < 0 || this.mWcdmaSignalStrength > 31) {
                    if (this.mWcdmaSignalStrength == 99) break;
                    Log.wtf(LOG_TAG, "getWcdmaLevel - invalid WCDMA RSSI: mWcdmaSignalStrength=" + this.mWcdmaSignalStrength);
                    break;
                }
                if (this.mWcdmaSignalStrength >= 18) {
                    level = 4;
                    break;
                }
                if (this.mWcdmaSignalStrength >= 13) {
                    level = 3;
                    break;
                }
                if (this.mWcdmaSignalStrength >= 8) {
                    level = 2;
                    break;
                }
                if (this.mWcdmaSignalStrength < 3) break;
                level = 1;
            }
        }
        return level;
    }

    public int hashCode() {
        int primeNum = 31;
        return this.mGsmSignalStrength * primeNum + this.mGsmBitErrorRate * primeNum + this.mCdmaDbm * primeNum + this.mCdmaEcio * primeNum + this.mEvdoDbm * primeNum + this.mEvdoEcio * primeNum + this.mEvdoSnr * primeNum + this.mLteSignalStrength * primeNum + this.mLteRsrp * primeNum + this.mLteRsrq * primeNum + this.mLteRssnr * primeNum + this.mLteCqi * primeNum + this.mLteRsrpBoost * primeNum + this.mTdScdmaRscp * primeNum + this.mWcdmaSignalStrength * primeNum + this.mWcdmaRscpAsu * primeNum + this.mWcdmaRscp * primeNum + (this.mIsGsm ? 1 : 0) + (this.mUseOnlyRsrpForLteLevel ? 1 : 0) + Objects.hashCode(this.mWcdmaDefaultSignalMeasurement) + Arrays.hashCode(this.mLteRsrpThresholds) + Arrays.hashCode(this.mWcdmaRscpThresholds);
    }

    public boolean equals(Object o) {
        SignalStrength s;
        try {
            s = (SignalStrength)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mGsmSignalStrength == s.mGsmSignalStrength && this.mGsmBitErrorRate == s.mGsmBitErrorRate && this.mCdmaDbm == s.mCdmaDbm && this.mCdmaEcio == s.mCdmaEcio && this.mEvdoDbm == s.mEvdoDbm && this.mEvdoEcio == s.mEvdoEcio && this.mEvdoSnr == s.mEvdoSnr && this.mLteSignalStrength == s.mLteSignalStrength && this.mLteRsrp == s.mLteRsrp && this.mLteRsrq == s.mLteRsrq && this.mLteRssnr == s.mLteRssnr && this.mLteCqi == s.mLteCqi && this.mLteRsrpBoost == s.mLteRsrpBoost && this.mTdScdmaRscp == s.mTdScdmaRscp && this.mWcdmaSignalStrength == s.mWcdmaSignalStrength && this.mWcdmaRscpAsu == s.mWcdmaRscpAsu && this.mWcdmaRscp == s.mWcdmaRscp && this.mIsGsm == s.mIsGsm && this.mUseOnlyRsrpForLteLevel == s.mUseOnlyRsrpForLteLevel && Objects.equals(this.mWcdmaDefaultSignalMeasurement, s.mWcdmaDefaultSignalMeasurement) && Arrays.equals(this.mLteRsrpThresholds, s.mLteRsrpThresholds) && Arrays.equals(this.mWcdmaRscpThresholds, s.mWcdmaRscpThresholds);
    }

    public String toString() {
        return "SignalStrength: " + this.mGsmSignalStrength + " " + this.mGsmBitErrorRate + " " + this.mCdmaDbm + " " + this.mCdmaEcio + " " + this.mEvdoDbm + " " + this.mEvdoEcio + " " + this.mEvdoSnr + " " + this.mLteSignalStrength + " " + this.mLteRsrp + " " + this.mLteRsrq + " " + this.mLteRssnr + " " + this.mLteCqi + " " + this.mLteRsrpBoost + " " + this.mTdScdmaRscp + " " + this.mWcdmaSignalStrength + " " + this.mWcdmaRscpAsu + " " + this.mWcdmaRscp + " " + (this.mIsGsm ? "gsm|lte" : "cdma") + " " + (this.mUseOnlyRsrpForLteLevel ? "use_only_rsrp_for_lte_level" : "use_rsrp_and_rssnr_for_lte_level") + " " + this.mWcdmaDefaultSignalMeasurement + " " + Arrays.toString(this.mLteRsrpThresholds) + " " + Arrays.toString(this.mWcdmaRscpThresholds);
    }

    private int getGsmRelatedSignalStrength() {
        int level = this.getLteLevel();
        if (level == 0 && (level = this.getTdScdmaLevel()) == 0 && (level = this.getWcdmaLevel()) == 0) {
            level = this.getGsmLevel();
        }
        return level;
    }

    private int getCdmaRelatedSignalStrength() {
        int cdmaLevel = this.getCdmaLevel();
        int evdoLevel = this.getEvdoLevel();
        int level = evdoLevel == 0 ? cdmaLevel : (cdmaLevel == 0 ? evdoLevel : (cdmaLevel < evdoLevel ? cdmaLevel : evdoLevel));
        return level;
    }

    private void setFromNotifierBundle(Bundle m) {
        this.mGsmSignalStrength = m.getInt("GsmSignalStrength");
        this.mGsmBitErrorRate = m.getInt("GsmBitErrorRate");
        this.mCdmaDbm = m.getInt("CdmaDbm");
        this.mCdmaEcio = m.getInt("CdmaEcio");
        this.mEvdoDbm = m.getInt("EvdoDbm");
        this.mEvdoEcio = m.getInt("EvdoEcio");
        this.mEvdoSnr = m.getInt("EvdoSnr");
        this.mLteSignalStrength = m.getInt("LteSignalStrength");
        this.mLteRsrp = m.getInt("LteRsrp");
        this.mLteRsrq = m.getInt("LteRsrq");
        this.mLteRssnr = m.getInt("LteRssnr");
        this.mLteCqi = m.getInt("LteCqi");
        this.mLteRsrpBoost = m.getInt("LteRsrpBoost");
        this.mTdScdmaRscp = m.getInt("TdScdma");
        this.mWcdmaSignalStrength = m.getInt("WcdmaSignalStrength");
        this.mWcdmaRscpAsu = m.getInt("WcdmaRscpAsu");
        this.mWcdmaRscp = m.getInt("WcdmaRscp");
        this.mIsGsm = m.getBoolean("IsGsm");
        this.mUseOnlyRsrpForLteLevel = m.getBoolean("UseOnlyRsrpForLteLevel");
        this.mWcdmaDefaultSignalMeasurement = m.getString("WcdmaDefaultSignalMeasurement");
        ArrayList<Integer> lteRsrpThresholds = m.getIntegerArrayList("lteRsrpThresholds");
        for (int i = 0; i < lteRsrpThresholds.size(); ++i) {
            this.mLteRsrpThresholds[i] = lteRsrpThresholds.get(i);
        }
        ArrayList<Integer> wcdmaRscpThresholds = m.getIntegerArrayList("wcdmaRscpThresholds");
        for (int i = 0; i < wcdmaRscpThresholds.size(); ++i) {
            this.mWcdmaRscpThresholds[i] = wcdmaRscpThresholds.get(i);
        }
    }

    public void fillInNotifierBundle(Bundle m) {
        m.putInt("GsmSignalStrength", this.mGsmSignalStrength);
        m.putInt("GsmBitErrorRate", this.mGsmBitErrorRate);
        m.putInt("CdmaDbm", this.mCdmaDbm);
        m.putInt("CdmaEcio", this.mCdmaEcio);
        m.putInt("EvdoDbm", this.mEvdoDbm);
        m.putInt("EvdoEcio", this.mEvdoEcio);
        m.putInt("EvdoSnr", this.mEvdoSnr);
        m.putInt("LteSignalStrength", this.mLteSignalStrength);
        m.putInt("LteRsrp", this.mLteRsrp);
        m.putInt("LteRsrq", this.mLteRsrq);
        m.putInt("LteRssnr", this.mLteRssnr);
        m.putInt("LteCqi", this.mLteCqi);
        m.putInt("LteRsrpBoost", this.mLteRsrpBoost);
        m.putInt("TdScdma", this.mTdScdmaRscp);
        m.putInt("WcdmaSignalStrength", this.mWcdmaSignalStrength);
        m.putInt("WcdmaRscpAsu", this.mWcdmaRscpAsu);
        m.putInt("WcdmaRscp", this.mWcdmaRscp);
        m.putBoolean("IsGsm", this.mIsGsm);
        m.putBoolean("UseOnlyRsrpForLteLevel", this.mUseOnlyRsrpForLteLevel);
        m.putString("WcdmaDefaultSignalMeasurement", this.mWcdmaDefaultSignalMeasurement);
        ArrayList<Integer> lteRsrpThresholds = new ArrayList<Integer>();
        for (int value : this.mLteRsrpThresholds) {
            lteRsrpThresholds.add(value);
        }
        m.putIntegerArrayList("lteRsrpThresholds", lteRsrpThresholds);
        ArrayList<Integer> wcdmaRscpThresholds = new ArrayList<Integer>();
        for (int value : this.mWcdmaRscpThresholds) {
            wcdmaRscpThresholds.add(value);
        }
        m.putIntegerArrayList("wcdmaRscpThresholds", wcdmaRscpThresholds);
    }

    private int[] getDefaultLteRsrpThresholds() {
        return CarrierConfigManager.getDefaultConfig().getIntArray("lte_rsrp_thresholds_int_array");
    }

    private int[] getDefaultWcdmaRscpThresholds() {
        return CarrierConfigManager.getDefaultConfig().getIntArray("wcdma_rscp_thresholds_int_array");
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

