/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Rect;
import android.text.MeasuredParagraph;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Objects;

public class PrecomputedText
implements Spannable {
    private static final char LINE_FEED = '\n';
    private final SpannableString mText;
    private final int mStart;
    private final int mEnd;
    private final Params mParams;
    private final ParagraphInfo[] mParagraphInfo;

    public static PrecomputedText create(CharSequence text, Params params) {
        ParagraphInfo[] paraInfo = PrecomputedText.createMeasuredParagraphs(text, params, 0, text.length(), true);
        return new PrecomputedText(text, 0, text.length(), params, paraInfo);
    }

    public static ParagraphInfo[] createMeasuredParagraphs(CharSequence text, Params params, int start, int end, boolean computeLayout) {
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(params);
        boolean needHyphenation = params.getBreakStrategy() != 0 && params.getHyphenationFrequency() != 0;
        int paraEnd = 0;
        int paraStart = start;
        while (paraStart < end) {
            paraEnd = TextUtils.indexOf(text, '\n', paraStart, end);
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), text, paraStart, paraEnd, params.getTextDirection(), needHyphenation, computeLayout, null)));
            paraStart = paraEnd;
        }
        return result.toArray(new ParagraphInfo[result.size()]);
    }

    private PrecomputedText(CharSequence text, int start, int end, Params params, ParagraphInfo[] paraInfo) {
        this.mText = new SpannableString(text, true);
        this.mStart = start;
        this.mEnd = end;
        this.mParams = params;
        this.mParagraphInfo = paraInfo;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public Params getParams() {
        return this.mParams;
    }

    public int getParagraphCount() {
        return this.mParagraphInfo.length;
    }

    public int getParagraphStart(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return paraIndex == 0 ? this.mStart : this.getParagraphEnd(paraIndex - 1);
    }

    public int getParagraphEnd(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return this.mParagraphInfo[paraIndex].paragraphEnd;
    }

    public MeasuredParagraph getMeasuredParagraph(int paraIndex) {
        return this.mParagraphInfo[paraIndex].measured;
    }

    public ParagraphInfo[] getParagraphInfo() {
        return this.mParagraphInfo;
    }

    public boolean canUseMeasuredResult(int start, int end, TextDirectionHeuristic textDir, TextPaint paint, int strategy, int frequency) {
        TextPaint mtPaint = this.mParams.getTextPaint();
        return this.mStart == start && this.mEnd == end && this.mParams.isSameTextMetricsInternal(paint, textDir, strategy, frequency);
    }

    public int findParaIndex(int pos) {
        for (int i = 0; i < this.mParagraphInfo.length; ++i) {
            if (pos >= this.mParagraphInfo[i].paragraphEnd) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("pos must be less than " + this.mParagraphInfo[this.mParagraphInfo.length - 1].paragraphEnd + ", gave " + pos);
    }

    public float getWidth(int start, int end) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        if (start == end) {
            return 0.0f;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        return this.getMeasuredParagraph(paraIndex).getWidth(start - paraStart, end - paraStart);
    }

    public void getBounds(int start, int end, Rect bounds) {
        Preconditions.checkArgument(0 <= start && start <= this.mText.length(), "invalid start offset");
        Preconditions.checkArgument(0 <= end && end <= this.mText.length(), "invalid end offset");
        Preconditions.checkArgument(start <= end, "start offset can not be larger than end offset");
        Preconditions.checkNotNull(bounds);
        if (start == end) {
            bounds.set(0, 0, 0, 0);
            return;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        this.getMeasuredParagraph(paraIndex).getBounds(start - paraStart, end - paraStart, bounds);
    }

    public int getMemoryUsage() {
        int r = 0;
        for (int i = 0; i < this.getParagraphCount(); ++i) {
            r += this.getMeasuredParagraph(i).getMemoryUsage();
        }
        return r;
    }

    @Override
    public void setSpan(Object what, int start, int end, int flags) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be set to PrecomputedText.");
        }
        this.mText.setSpan(what, start, end, flags);
    }

    @Override
    public void removeSpan(Object what) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be removed from PrecomputedText.");
        }
        this.mText.removeSpan(what);
    }

    @Override
    public <T> T[] getSpans(int start, int end, Class<T> type) {
        return this.mText.getSpans(start, end, (Class)type);
    }

    @Override
    public int getSpanStart(Object tag) {
        return this.mText.getSpanStart(tag);
    }

    @Override
    public int getSpanEnd(Object tag) {
        return this.mText.getSpanEnd(tag);
    }

    @Override
    public int getSpanFlags(Object tag) {
        return this.mText.getSpanFlags(tag);
    }

    @Override
    public int nextSpanTransition(int start, int limit, Class type) {
        return this.mText.nextSpanTransition(start, limit, type);
    }

    @Override
    public int length() {
        return this.mText.length();
    }

    @Override
    public char charAt(int index) {
        return this.mText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return PrecomputedText.create(this.mText.subSequence(start, end), this.mParams);
    }

    @Override
    public String toString() {
        return this.mText.toString();
    }

    public static class ParagraphInfo {
        public final int paragraphEnd;
        public final MeasuredParagraph measured;

        public ParagraphInfo(int paraEnd, MeasuredParagraph measured) {
            this.paragraphEnd = paraEnd;
            this.measured = measured;
        }
    }

    public static class Params {
        private final TextPaint mPaint;
        private final TextDirectionHeuristic mTextDir;
        private final int mBreakStrategy;
        private final int mHyphenationFrequency;

        public Params(TextPaint paint, TextDirectionHeuristic textDir, int strategy, int frequency) {
            this.mPaint = paint;
            this.mTextDir = textDir;
            this.mBreakStrategy = strategy;
            this.mHyphenationFrequency = frequency;
        }

        public TextPaint getTextPaint() {
            return this.mPaint;
        }

        public TextDirectionHeuristic getTextDirection() {
            return this.mTextDir;
        }

        public int getBreakStrategy() {
            return this.mBreakStrategy;
        }

        public int getHyphenationFrequency() {
            return this.mHyphenationFrequency;
        }

        public boolean isSameTextMetricsInternal(TextPaint paint, TextDirectionHeuristic textDir, int strategy, int frequency) {
            return this.mTextDir == textDir && this.mBreakStrategy == strategy && this.mHyphenationFrequency == frequency && this.mPaint.equalsForTextMeasurement(paint);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Params)) {
                return false;
            }
            Params param = (Params)o;
            return this.isSameTextMetricsInternal(param.mPaint, param.mTextDir, param.mBreakStrategy, param.mHyphenationFrequency);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mPaint.getTextSize()), Float.valueOf(this.mPaint.getTextScaleX()), Float.valueOf(this.mPaint.getTextSkewX()), Float.valueOf(this.mPaint.getLetterSpacing()), Float.valueOf(this.mPaint.getWordSpacing()), this.mPaint.getFlags(), this.mPaint.getTextLocales(), this.mPaint.getTypeface(), this.mPaint.getFontVariationSettings(), this.mPaint.isElegantTextHeight(), this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency);
        }

        public String toString() {
            return "{textSize=" + this.mPaint.getTextSize() + ", textScaleX=" + this.mPaint.getTextScaleX() + ", textSkewX=" + this.mPaint.getTextSkewX() + ", letterSpacing=" + this.mPaint.getLetterSpacing() + ", textLocale=" + this.mPaint.getTextLocales() + ", typeface=" + this.mPaint.getTypeface() + ", variationSettings=" + this.mPaint.getFontVariationSettings() + ", elegantTextHeight=" + this.mPaint.isElegantTextHeight() + ", textDir=" + this.mTextDir + ", breakStrategy=" + this.mBreakStrategy + ", hyphenationFrequency=" + this.mHyphenationFrequency + "}";
        }

        public static class Builder {
            private final TextPaint mPaint;
            private TextDirectionHeuristic mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            private int mBreakStrategy = 1;
            private int mHyphenationFrequency = 1;

            public Builder(TextPaint paint) {
                this.mPaint = paint;
            }

            public Builder setBreakStrategy(int strategy) {
                this.mBreakStrategy = strategy;
                return this;
            }

            public Builder setHyphenationFrequency(int frequency) {
                this.mHyphenationFrequency = frequency;
                return this;
            }

            public Builder setTextDirection(TextDirectionHeuristic textDir) {
                this.mTextDir = textDir;
                return this;
            }

            public Params build() {
                return new Params(this.mPaint, this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency);
            }
        }
    }
}

