/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.icu.text.SimpleDateFormat;
import android.provider.Settings;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.format.DateFormat_Delegate;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class DateFormat {
    @Deprecated
    public static final char QUOTE = '\'';
    @Deprecated
    public static final char AM_PM = 'a';
    @Deprecated
    public static final char CAPITAL_AM_PM = 'A';
    @Deprecated
    public static final char DATE = 'd';
    @Deprecated
    public static final char DAY = 'E';
    @Deprecated
    public static final char HOUR = 'h';
    @Deprecated
    public static final char HOUR_OF_DAY = 'k';
    @Deprecated
    public static final char MINUTE = 'm';
    @Deprecated
    public static final char MONTH = 'M';
    @Deprecated
    public static final char STANDALONE_MONTH = 'L';
    @Deprecated
    public static final char SECONDS = 's';
    @Deprecated
    public static final char TIME_ZONE = 'z';
    @Deprecated
    public static final char YEAR = 'y';
    private static final Object sLocaleLock = new Object();
    private static Locale sIs24HourLocale;
    private static boolean sIs24Hour;

    public static boolean is24HourFormat_Original(Context context) {
        return DateFormat.is24HourFormat(context, context.getUserId());
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context) {
        return DateFormat_Delegate.is24HourFormat(context);
    }

    public static boolean is24HourFormat_Original(Context context, int userHandle) {
        String value = Settings.System.getStringForUser(context.getContentResolver(), "time_12_24", userHandle);
        if (value != null) {
            return value.equals("24");
        }
        return DateFormat.is24HourLocale(context.getResources().getConfiguration().locale);
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context, int n) {
        return DateFormat_Delegate.is24HourFormat(context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean is24HourLocale(Locale locale) {
        boolean is24Hour;
        Object object = sLocaleLock;
        synchronized (object) {
            if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                return sIs24Hour;
            }
        }
        android.icu.text.DateFormat natural = android.icu.text.DateFormat.getTimeInstance(1, locale);
        if (natural instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)natural;
            String pattern = sdf.toPattern();
            is24Hour = DateFormat.hasDesignator(pattern, 'H');
        } else {
            is24Hour = false;
        }
        Object object2 = sLocaleLock;
        synchronized (object2) {
            sIs24HourLocale = locale;
            sIs24Hour = is24Hour;
        }
        return is24Hour;
    }

    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        return ICU.getBestDateTimePattern(skeleton, locale);
    }

    public static android.icu.text.DateFormat getTimeFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return new SimpleDateFormat(DateFormat.getTimeFormatString(context), locale);
    }

    public static String getTimeFormatString(Context context) {
        return DateFormat.getTimeFormatString(context, context.getUserId());
    }

    public static String getTimeFormatString(Context context, int userHandle) {
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        return DateFormat.is24HourFormat(context, userHandle) ? d.timeFormat_Hm : d.timeFormat_hm;
    }

    public static android.icu.text.DateFormat getDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return android.icu.text.DateFormat.getDateInstance(3, locale);
    }

    public static android.icu.text.DateFormat getLongDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return android.icu.text.DateFormat.getDateInstance(1, locale);
    }

    public static android.icu.text.DateFormat getMediumDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return android.icu.text.DateFormat.getDateInstance(2, locale);
    }

    public static char[] getDateFormatOrder(Context context) {
        return ICU.getDateFormatOrder(DateFormat.getDateFormatString(context));
    }

    private static String getDateFormatString(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        android.icu.text.DateFormat df = android.icu.text.DateFormat.getDateInstance(3, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        throw new AssertionError((Object)"!(df instanceof SimpleDateFormat)");
    }

    public static CharSequence format(CharSequence inFormat, long inTimeInMillis) {
        return DateFormat.format(inFormat, new Date(inTimeInMillis));
    }

    public static CharSequence format(CharSequence inFormat, Date inDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(inDate);
        return DateFormat.format(inFormat, c);
    }

    public static boolean hasSeconds(CharSequence inFormat) {
        return DateFormat.hasDesignator(inFormat, 's');
    }

    public static boolean hasDesignator(CharSequence inFormat, char designator) {
        if (inFormat == null) {
            return false;
        }
        int length = inFormat.length();
        boolean insideQuote = false;
        for (int i = 0; i < length; ++i) {
            char c = inFormat.charAt(i);
            if (c == '\'') {
                insideQuote = !insideQuote;
                continue;
            }
            if (insideQuote || c != designator) continue;
            return true;
        }
        return false;
    }

    public static CharSequence format(CharSequence inFormat, Calendar inDate) {
        int count;
        SpannableStringBuilder s = new SpannableStringBuilder(inFormat);
        LocaleData localeData = LocaleData.get(AndroidLocale.getDefault());
        int len = inFormat.length();
        for (int i = 0; i < len; i += count) {
            String replacement;
            count = 1;
            char c = s.charAt(i);
            if (c == '\'') {
                count = DateFormat.appendQuotedText(s, i);
                len = s.length();
                continue;
            }
            while (i + count < len && s.charAt(i + count) == c) {
                ++count;
            }
            switch (c) {
                case 'A': 
                case 'a': {
                    replacement = localeData.amPm[inDate.get(9) - 0];
                    break;
                }
                case 'd': {
                    replacement = DateFormat.zeroPad(inDate.get(5), count);
                    break;
                }
                case 'E': 
                case 'c': {
                    replacement = DateFormat.getDayOfWeekString(localeData, inDate.get(7), count, c);
                    break;
                }
                case 'K': 
                case 'h': {
                    int hour = inDate.get(10);
                    if (c == 'h' && hour == 0) {
                        hour = 12;
                    }
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'H': 
                case 'k': {
                    int hour = inDate.get(11);
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'L': 
                case 'M': {
                    replacement = DateFormat.getMonthString(localeData, inDate.get(2), count, c);
                    break;
                }
                case 'm': {
                    replacement = DateFormat.zeroPad(inDate.get(12), count);
                    break;
                }
                case 's': {
                    replacement = DateFormat.zeroPad(inDate.get(13), count);
                    break;
                }
                case 'y': {
                    replacement = DateFormat.getYearString(inDate.get(1), count);
                    break;
                }
                case 'z': {
                    replacement = DateFormat.getTimeZoneString(inDate, count);
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement == null) continue;
            s.replace(i, i + count, replacement);
            count = replacement.length();
            len = s.length();
        }
        if (inFormat instanceof Spanned) {
            return new SpannedString(s);
        }
        return s.toString();
    }

    private static String getDayOfWeekString(LocaleData ld, int day, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 99;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneWeekdayNames[day] : ld.tinyWeekdayNames[day];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneWeekdayNames[day] : ld.longWeekdayNames[day];
        }
        return standalone ? ld.shortStandAloneWeekdayNames[day] : ld.shortWeekdayNames[day];
    }

    private static String getMonthString(LocaleData ld, int month, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 76;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneMonthNames[month] : ld.tinyMonthNames[month];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneMonthNames[month] : ld.longMonthNames[month];
        }
        if (count == 3) {
            return standalone ? ld.shortStandAloneMonthNames[month] : ld.shortMonthNames[month];
        }
        return DateFormat.zeroPad(month + 1, count);
    }

    private static String getTimeZoneString(Calendar inDate, int count) {
        TimeZone tz = inDate.getTimeZone();
        if (count < 2) {
            return DateFormat.formatZoneOffset(inDate.get(16) + inDate.get(15), count);
        }
        boolean dst = inDate.get(16) != 0;
        return tz.getDisplayName(dst, 0);
    }

    private static String formatZoneOffset(int offset, int count) {
        StringBuilder tb = new StringBuilder();
        if ((offset /= 1000) < 0) {
            tb.insert(0, "-");
            offset = -offset;
        } else {
            tb.insert(0, "+");
        }
        int hours = offset / 3600;
        int minutes = offset % 3600 / 60;
        tb.append(DateFormat.zeroPad(hours, 2));
        tb.append(DateFormat.zeroPad(minutes, 2));
        return tb.toString();
    }

    private static String getYearString(int year, int count) {
        return count <= 2 ? DateFormat.zeroPad(year % 100, 2) : String.format(AndroidLocale.getDefault(), "%d", year);
    }

    public static int appendQuotedText(SpannableStringBuilder formatString, int index) {
        int length = formatString.length();
        if (index + 1 < length && formatString.charAt(index + 1) == '\'') {
            formatString.delete(index, index + 1);
            return 1;
        }
        int count = 0;
        formatString.delete(index, index + 1);
        --length;
        while (index < length) {
            char c = formatString.charAt(index);
            if (c == '\'') {
                if (index + 1 < length && formatString.charAt(index + 1) == '\'') {
                    formatString.delete(index, index + 1);
                    --length;
                    ++count;
                    ++index;
                    continue;
                }
                formatString.delete(index, index + 1);
                break;
            }
            ++index;
            ++count;
        }
        return count;
    }

    private static String zeroPad(int inValue, int inMinDigits) {
        return String.format(AndroidLocale.getDefault(), "%0" + inMinDigits + "d", inValue);
    }
}

