/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.content.Context;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.LinkSpec;
import android.util.Patterns;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextLinksParams;
import android.webkit.WebView;
import android.widget.TextView;
import com.android.i18n.phonenumbers.PhoneNumberMatch;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.internal.util.Preconditions;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.util.EmptyArray;

public class Linkify {
    public static final int WEB_URLS = 1;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int PHONE_NUMBERS = 4;
    @Deprecated
    public static final int MAP_ADDRESSES = 8;
    public static final int ALL = 15;
    private static final int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    public static final MatchFilter sUrlMatchFilter = new MatchFilter(){

        @Override
        public boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) != '@';
        }
    };
    public static final MatchFilter sPhoneNumberMatchFilter = new MatchFilter(){

        @Override
        public boolean acceptMatch(CharSequence s, int start, int end) {
            int digitCount = 0;
            for (int i = start; i < end; ++i) {
                if (!Character.isDigit(s.charAt(i)) || ++digitCount < 5) continue;
                return true;
            }
            return false;
        }
    };
    public static final TransformFilter sPhoneNumberTransformFilter = new TransformFilter(){

        @Override
        public String transformUrl(Matcher match, String url) {
            return Patterns.digitsAndPlusOnly(match);
        }
    };

    public static boolean addLinks(Spannable text, int mask) {
        return Linkify.addLinks(text, mask, null);
    }

    private static boolean addLinks(Spannable text, int mask, Context context) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan(old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            Linkify.gatherLinks(links, text, Patterns.AUTOLINK_WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            Linkify.gatherLinks(links, text, Patterns.AUTOLINK_EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 4) != 0) {
            Linkify.gatherTelLinks(links, text, context);
        }
        if ((mask & 8) != 0) {
            Linkify.gatherMapLinks(links, text);
        }
        Linkify.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            Linkify.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    public static boolean addLinks(TextView text, int mask) {
        if (mask == 0) {
            return false;
        }
        Context context = text.getContext();
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (Linkify.addLinks((Spannable)t, mask, context)) {
                Linkify.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf(t);
        if (Linkify.addLinks((Spannable)s, mask, context)) {
            Linkify.addLinkMovementMethod(text);
            text.setText(s);
            return true;
        }
        return false;
    }

    private static void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static void addLinks(TextView text, Pattern pattern, String scheme) {
        Linkify.addLinks(text, pattern, scheme, null, null, null);
    }

    public static void addLinks(TextView text, Pattern pattern, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        Linkify.addLinks(text, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static void addLinks(TextView text, Pattern pattern, String defaultScheme, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString spannable = SpannableString.valueOf(text.getText());
        boolean linksAdded = Linkify.addLinks(spannable, pattern, defaultScheme, schemes, matchFilter, transformFilter);
        if (linksAdded) {
            text.setText(spannable);
            Linkify.addLinkMovementMethod(text);
        }
    }

    public static boolean addLinks(Spannable text, Pattern pattern, String scheme) {
        return Linkify.addLinks(text, pattern, scheme, null, null, null);
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        return Linkify.addLinks(spannable, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String defaultScheme, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        if (defaultScheme == null) {
            defaultScheme = "";
        }
        if (schemes == null || schemes.length < 1) {
            schemes = EmptyArray.STRING;
        }
        String[] schemesCopy = new String[schemes.length + 1];
        schemesCopy[0] = defaultScheme.toLowerCase(Locale.ROOT);
        for (int index = 0; index < schemes.length; ++index) {
            String scheme = schemes[index];
            schemesCopy[index + 1] = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        }
        boolean hasMatches = false;
        Matcher m = pattern.matcher(spannable);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch(spannable, start, end);
            }
            if (!allowed) continue;
            String url = Linkify.makeUrl(m.group(0), schemesCopy, m, transformFilter);
            Linkify.applyLink(url, start, end, spannable);
            hasMatches = true;
        }
        return hasMatches;
    }

    public static Future<Void> addLinksAsync(TextView textView, TextLinksParams params) {
        return Linkify.addLinksAsync(textView, params, null, null);
    }

    public static Future<Void> addLinksAsync(TextView textView, int mask) {
        return Linkify.addLinksAsync(textView, TextLinksParams.fromLinkMask(mask), null, null);
    }

    public static Future<Void> addLinksAsync(TextView textView, TextLinksParams params, Executor executor, Consumer<Integer> callback) {
        Preconditions.checkNotNull(textView);
        CharSequence text = textView.getText();
        Spannable spannable = text instanceof Spannable ? (Spannable)text : SpannableString.valueOf(text);
        Runnable modifyTextView = () -> {
            Linkify.addLinkMovementMethod(textView);
            if (spannable != text) {
                textView.setText(spannable);
            }
        };
        return Linkify.addLinksAsync(spannable, textView.getTextClassifier(), params, executor, callback, modifyTextView);
    }

    public static Future<Void> addLinksAsync(Spannable text, TextClassifier classifier, TextLinksParams params) {
        return Linkify.addLinksAsync(text, classifier, params, null, null);
    }

    public static Future<Void> addLinksAsync(Spannable text, TextClassifier classifier, int mask) {
        return Linkify.addLinksAsync(text, classifier, TextLinksParams.fromLinkMask(mask), null, null);
    }

    public static Future<Void> addLinksAsync(Spannable text, TextClassifier classifier, TextLinksParams params, Executor executor, Consumer<Integer> callback) {
        return Linkify.addLinksAsync(text, classifier, params, executor, callback, null);
    }

    private static Future<Void> addLinksAsync(Spannable text, TextClassifier classifier, TextLinksParams params, Executor executor, Consumer<Integer> callback, Runnable modifyTextView) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(classifier);
        CharSequence truncatedText = text.subSequence(0, Math.min(text.length(), classifier.getMaxGenerateLinksTextLength()));
        TextClassifier.EntityConfig entityConfig = params == null ? null : params.getEntityConfig();
        TextLinks.Request request = new TextLinks.Request.Builder(truncatedText).setLegacyFallback(true).setEntityConfig(entityConfig).build();
        Supplier<TextLinks> supplier = () -> classifier.generateLinks(request);
        Consumer<TextLinks> consumer = links -> {
            if (links.getLinks().isEmpty()) {
                if (callback != null) {
                    callback.accept(1);
                }
                return;
            }
            TextLinks.TextLinkSpan[] old = text.getSpans(0, truncatedText.length(), TextLinks.TextLinkSpan.class);
            for (int i = old.length - 1; i >= 0; --i) {
                text.removeSpan(old[i]);
            }
            int result = params.apply(text, (TextLinks)links);
            if (result == 0 && modifyTextView != null) {
                modifyTextView.run();
            }
            if (callback != null) {
                callback.accept(result);
            }
        };
        if (executor == null) {
            return CompletableFuture.supplyAsync(supplier).thenAccept((Consumer)consumer);
        }
        return CompletableFuture.supplyAsync(supplier, executor).thenAccept((Consumer)consumer);
    }

    private static void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan(span, start, end, 33);
    }

    private static String makeUrl(String url, String[] prefixes, Matcher matcher, TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(matcher, url);
        }
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix && prefixes.length > 0) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch(s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = url = Linkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static void gatherTelLinks(ArrayList<LinkSpec> links, Spannable s, Context context) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        TelephonyManager tm = context == null ? TelephonyManager.getDefault() : TelephonyManager.from(context);
        Iterable<PhoneNumberMatch> matches = phoneUtil.findNumbers(s.toString(), tm.getSimCountryIso().toUpperCase(Locale.US), PhoneNumberUtil.Leniency.POSSIBLE, Long.MAX_VALUE);
        for (PhoneNumberMatch match : matches) {
            LinkSpec spec = new LinkSpec();
            spec.url = "tel:" + PhoneNumberUtils.normalizeNumber(match.rawString());
            spec.start = match.start();
            spec.end = match.end();
            links.add(spec);
        }
    }

    private static void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string2 = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = WebView.findAddress(string2)) != null && (start = string2.indexOf(address)) >= 0) {
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string2 = string2.substring(end);
                base += end;
                String encodedAddress = null;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException e) {
            return;
        }
    }

    private static void pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LinkifyMask {
    }
}

