/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;

public class Fade
extends Visibility {
    static final String PROPNAME_TRANSITION_ALPHA = "android:fade:transitionAlpha";
    private static boolean DBG = false;
    private static final String LOG_TAG = "Fade";
    public static final int IN = 1;
    public static final int OUT = 2;

    public Fade() {
    }

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    public Fade(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Fade);
        int fadingMode = a.getInt(0, this.getMode());
        this.setMode(fadingMode);
        a.recycle();
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        transitionValues.values.put(PROPNAME_TRANSITION_ALPHA, Float.valueOf(transitionValues.view.getTransitionAlpha()));
    }

    private Animator createAnimation(final View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        view.setTransitionAlpha(startAlpha);
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)view, "transitionAlpha", endAlpha);
        if (DBG) {
            Log.d(LOG_TAG, "Created animator " + anim2);
        }
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim2.addListener(listener);
        this.addListener(new TransitionListenerAdapter(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                view.setTransitionAlpha(1.0f);
                transition2.removeListener(this);
            }
        });
        return anim2;
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        float startAlpha;
        if (DBG) {
            View startView = startValues != null ? startValues.view : null;
            Log.d(LOG_TAG, "Fade.onAppear: startView, startVis, endView, endVis = " + startView + ", " + view);
        }
        if ((startAlpha = Fade.getStartAlpha(startValues, 0.0f)) == 1.0f) {
            startAlpha = 0.0f;
        }
        return this.createAnimation(view, startAlpha, 1.0f);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        float startAlpha = Fade.getStartAlpha(startValues, 1.0f);
        return this.createAnimation(view, startAlpha, 0.0f);
    }

    private static float getStartAlpha(TransitionValues startValues, float fallbackValue) {
        Float startAlphaFloat;
        float startAlpha = fallbackValue;
        if (startValues != null && (startAlphaFloat = (Float)startValues.values.get(PROPNAME_TRANSITION_ALPHA)) != null) {
            startAlpha = startAlphaFloat.floatValue();
        }
        return startAlpha;
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter {
        private final View mView;
        private boolean mLayerTypeChanged = false;

        public FadeAnimatorListener(View view) {
            this.mView = view;
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            if (this.mView.hasOverlappingRendering() && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            this.mView.setTransitionAlpha(1.0f);
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
        }
    }
}

