/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.TimeoutException;

public abstract class TimedRemoteCaller<T> {
    public static final long DEFAULT_CALL_TIMEOUT_MILLIS = 5000L;
    private final Object mLock = new Object();
    private final long mCallTimeoutMillis;
    @GuardedBy(value="mLock")
    private final SparseIntArray mAwaitedCalls = new SparseIntArray(1);
    @GuardedBy(value="mLock")
    private final SparseArray<T> mReceivedCalls = new SparseArray(1);
    @GuardedBy(value="mLock")
    private int mSequenceCounter;

    public TimedRemoteCaller(long callTimeoutMillis) {
        this.mCallTimeoutMillis = callTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int onBeforeRemoteCall() {
        Object object = this.mLock;
        synchronized (object) {
            int sequenceId;
            do {
                ++this.mSequenceCounter;
            } while (this.mAwaitedCalls.get(sequenceId) != 0);
            this.mAwaitedCalls.put(sequenceId, 1);
            return sequenceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRemoteMethodResult(T result, int sequence) {
        Object object = this.mLock;
        synchronized (object) {
            boolean containedSequenceId;
            boolean bl = containedSequenceId = this.mAwaitedCalls.get(sequence) != 0;
            if (containedSequenceId) {
                this.mAwaitedCalls.delete(sequence);
                this.mReceivedCalls.put(sequence, result);
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getResultTimed(int sequence) throws TimeoutException {
        long startMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mReceivedCalls.indexOfKey(sequence) >= 0) {
                            return this.mReceivedCalls.removeReturnOld(sequence);
                        }
                        long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                        long waitMillis = this.mCallTimeoutMillis - elapsedMillis;
                        if (waitMillis <= 0L) {
                            this.mAwaitedCalls.delete(sequence);
                            throw new TimeoutException("No response for sequence: " + sequence);
                        }
                        this.mLock.wait(waitMillis);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

