/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public abstract class DisplayEventReceiver {
    public static final int VSYNC_SOURCE_APP = 0;
    public static final int VSYNC_SOURCE_SURFACE_FLINGER = 1;
    private static final String TAG = "DisplayEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mReceiverPtr;
    private MessageQueue mMessageQueue;

    private static long nativeInit(WeakReference<DisplayEventReceiver> weakReference, MessageQueue messageQueue, int n) {
        return OverrideMethod.invokeL("android.view.DisplayEventReceiver#nativeInit(Ljava/lang/ref/WeakReference;Landroid/os/MessageQueue;I)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeDispose(J)V", true, null);
    }

    @FastNative
    private static void nativeScheduleVsync(long l) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeScheduleVsync(J)V", true, null);
    }

    public DisplayEventReceiver(Looper looper) {
        this(looper, 0);
    }

    public DisplayEventReceiver(Looper looper, int vsyncSource) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(new WeakReference<DisplayEventReceiver>(this), this.mMessageQueue, vsyncSource);
        this.mCloseGuard.open("dispose");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            DisplayEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mMessageQueue = null;
    }

    public void onVsync(long timestampNanos, int builtInDisplayId, int frame) {
    }

    public void onHotplug(long timestampNanos, int builtInDisplayId, boolean connected) {
    }

    public void scheduleVsync() {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
        } else {
            DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
        }
    }

    private void dispatchVsync(long timestampNanos, int builtInDisplayId, int frame) {
        this.onVsync(timestampNanos, builtInDisplayId, frame);
    }

    private void dispatchHotplug(long timestampNanos, int builtInDisplayId, boolean connected) {
        this.onHotplug(timestampNanos, builtInDisplayId, connected);
    }
}

