/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewOverlay;
import android.view.ViewParent;
import android.widget.FrameLayout;
import java.util.ArrayList;

public class GhostView
extends View {
    private final View mView;
    private int mReferences;
    private boolean mBeingMoved;

    private GhostView(View view) {
        super(view.getContext());
        this.mView = view;
        this.mView.mGhostView = this;
        ViewGroup parent = (ViewGroup)this.mView.getParent();
        this.mView.setTransitionVisibility(4);
        parent.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (canvas instanceof DisplayListCanvas) {
            DisplayListCanvas dlCanvas = (DisplayListCanvas)canvas;
            this.mView.mRecreateDisplayList = true;
            RenderNode renderNode = this.mView.updateDisplayListIfDirty();
            if (renderNode.isValid()) {
                dlCanvas.insertReorderBarrier();
                dlCanvas.drawRenderNode(renderNode);
                dlCanvas.insertInorderBarrier();
            }
        }
    }

    public void setMatrix(Matrix matrix) {
        this.mRenderNode.setAnimationMatrix(matrix);
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mView.mGhostView == this) {
            int inverseVisibility = visibility == 0 ? 4 : 0;
            this.mView.setTransitionVisibility(inverseVisibility);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mBeingMoved) {
            this.mView.setTransitionVisibility(0);
            this.mView.mGhostView = null;
            ViewGroup parent = (ViewGroup)this.mView.getParent();
            if (parent != null) {
                parent.invalidate();
            }
        }
    }

    public static void calculateMatrix(View view, ViewGroup host, Matrix matrix) {
        ViewGroup parent = (ViewGroup)view.getParent();
        matrix.reset();
        parent.transformMatrixToGlobal(matrix);
        matrix.preTranslate(-parent.getScrollX(), -parent.getScrollY());
        host.transformMatrixToLocal(matrix);
    }

    public static GhostView addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        View oldParent;
        ViewGroup oldGrandParent;
        if (!(view.getParent() instanceof ViewGroup)) {
            throw new IllegalArgumentException("Ghosted views must be parented by a ViewGroup");
        }
        ViewGroupOverlay overlay = viewGroup.getOverlay();
        ViewOverlay.OverlayViewGroup overlayViewGroup = overlay.mOverlayViewGroup;
        GhostView ghostView = view.mGhostView;
        int previousRefCount = 0;
        if (ghostView != null && (oldGrandParent = (ViewGroup)(oldParent = (View)((Object)ghostView.getParent())).getParent()) != overlayViewGroup) {
            previousRefCount = ghostView.mReferences;
            oldGrandParent.removeView(oldParent);
            ghostView = null;
        }
        if (ghostView == null) {
            if (matrix == null) {
                matrix = new Matrix();
                GhostView.calculateMatrix(view, viewGroup, matrix);
            }
            ghostView = new GhostView(view);
            ghostView.setMatrix(matrix);
            FrameLayout parent = new FrameLayout(view.getContext());
            parent.setClipChildren(false);
            GhostView.copySize(viewGroup, parent);
            GhostView.copySize(viewGroup, ghostView);
            parent.addView(ghostView);
            ArrayList<View> tempViews = new ArrayList<View>();
            int firstGhost = GhostView.moveGhostViewsToTop(overlay.mOverlayViewGroup, tempViews);
            GhostView.insertIntoOverlay(overlay.mOverlayViewGroup, parent, ghostView, tempViews, firstGhost);
            ghostView.mReferences = previousRefCount;
        } else if (matrix != null) {
            ghostView.setMatrix(matrix);
        }
        ++ghostView.mReferences;
        return ghostView;
    }

    public static GhostView addGhost(View view, ViewGroup viewGroup) {
        return GhostView.addGhost(view, viewGroup, null);
    }

    public static void removeGhost(View view) {
        GhostView ghostView = view.mGhostView;
        if (ghostView != null) {
            --ghostView.mReferences;
            if (ghostView.mReferences == 0) {
                ViewGroup parent = (ViewGroup)ghostView.getParent();
                ViewGroup grandParent = (ViewGroup)parent.getParent();
                grandParent.removeView(parent);
            }
        }
    }

    public static GhostView getGhost(View view) {
        return view.mGhostView;
    }

    private static void copySize(View from, View to) {
        to.setLeft(0);
        to.setTop(0);
        to.setRight(from.getWidth());
        to.setBottom(from.getHeight());
    }

    private static int moveGhostViewsToTop(ViewGroup viewGroup, ArrayList<View> tempViews) {
        int firstGhost;
        int numChildren = viewGroup.getChildCount();
        if (numChildren == 0) {
            return -1;
        }
        if (GhostView.isGhostWrapper(viewGroup.getChildAt(numChildren - 1))) {
            int firstGhost2 = numChildren - 1;
            int i = numChildren - 2;
            while (i >= 0 && GhostView.isGhostWrapper(viewGroup.getChildAt(i))) {
                firstGhost2 = i--;
            }
            return firstGhost2;
        }
        for (int i = numChildren - 2; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (!GhostView.isGhostWrapper(child)) continue;
            tempViews.add(child);
            GhostView ghostView = (GhostView)((ViewGroup)child).getChildAt(0);
            ghostView.mBeingMoved = true;
            viewGroup.removeViewAt(i);
            ghostView.mBeingMoved = false;
        }
        if (tempViews.isEmpty()) {
            firstGhost = -1;
        } else {
            firstGhost = viewGroup.getChildCount();
            for (int i = tempViews.size() - 1; i >= 0; --i) {
                viewGroup.addView(tempViews.get(i));
            }
            tempViews.clear();
        }
        return firstGhost;
    }

    private static void insertIntoOverlay(ViewGroup viewGroup, ViewGroup wrapper, GhostView ghostView, ArrayList<View> tempParents, int firstGhost) {
        if (firstGhost == -1) {
            viewGroup.addView(wrapper);
        } else {
            ArrayList<View> viewParents = new ArrayList<View>();
            GhostView.getParents(ghostView.mView, viewParents);
            int index = GhostView.getInsertIndex(viewGroup, viewParents, tempParents, firstGhost);
            if (index < 0 || index >= viewGroup.getChildCount()) {
                viewGroup.addView(wrapper);
            } else {
                viewGroup.addView((View)wrapper, index);
            }
        }
    }

    private static int getInsertIndex(ViewGroup overlayViewGroup, ArrayList<View> viewParents, ArrayList<View> tempParents, int firstGhost) {
        int low = firstGhost;
        int high = overlayViewGroup.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            ViewGroup wrapper = (ViewGroup)overlayViewGroup.getChildAt(mid);
            GhostView midView = (GhostView)wrapper.getChildAt(0);
            GhostView.getParents(midView.mView, tempParents);
            if (GhostView.isOnTop(viewParents, tempParents)) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
            tempParents.clear();
        }
        return low;
    }

    private static boolean isGhostWrapper(View view) {
        FrameLayout frameLayout;
        if (view instanceof FrameLayout && (frameLayout = (FrameLayout)view).getChildCount() == 1) {
            View child = frameLayout.getChildAt(0);
            return child instanceof GhostView;
        }
        return false;
    }

    private static boolean isOnTop(ArrayList<View> viewParents, ArrayList<View> comparedWith) {
        if (viewParents.isEmpty() || comparedWith.isEmpty() || viewParents.get(0) != comparedWith.get(0)) {
            return true;
        }
        int depth = Math.min(viewParents.size(), comparedWith.size());
        for (int i = 1; i < depth; ++i) {
            View comparedWithParent;
            View viewParent = viewParents.get(i);
            if (viewParent == (comparedWithParent = comparedWith.get(i))) continue;
            return GhostView.isOnTop(viewParent, comparedWithParent);
        }
        boolean isComparedWithTheParent = comparedWith.size() == depth;
        return isComparedWithTheParent;
    }

    private static void getParents(View view, ArrayList<View> parents) {
        ViewParent parent = view.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            GhostView.getParents((View)((Object)parent), parents);
        }
        parents.add(view);
    }

    private static boolean isOnTop(View view, View comparedWith) {
        ViewGroup parent = (ViewGroup)view.getParent();
        int childrenCount = parent.getChildCount();
        ArrayList<View> preorderedList = parent.buildOrderedChildList();
        boolean customOrder = preorderedList == null && parent.isChildrenDrawingOrderEnabled();
        boolean isOnTop = true;
        for (int i = 0; i < childrenCount; ++i) {
            View child;
            int childIndex = customOrder ? parent.getChildDrawingOrder(childrenCount, i) : i;
            View view2 = child = preorderedList == null ? parent.getChildAt(childIndex) : preorderedList.get(childIndex);
            if (child == view) {
                isOnTop = false;
                break;
            }
            if (child != comparedWith) continue;
            isOnTop = true;
            break;
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
        return isOnTop;
    }
}

