/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ShadowPainter {
    public static final int SHADOW_SIZE = 20;
    public static final int SMALL_SHADOW_SIZE = 10;
    private static final Image ShadowBottom = ShadowPainter.loadIcon("/icons/shadow-b.png");
    private static final Image ShadowBottomLeft = ShadowPainter.loadIcon("/icons/shadow-bl.png");
    private static final Image ShadowBottomRight = ShadowPainter.loadIcon("/icons/shadow-br.png");
    private static final Image ShadowRight = ShadowPainter.loadIcon("/icons/shadow-r.png");
    private static final Image ShadowTopRight = ShadowPainter.loadIcon("/icons/shadow-tr.png");
    private static final Image ShadowTopLeft = ShadowPainter.loadIcon("/icons/shadow-tl.png");
    private static final Image ShadowLeft = ShadowPainter.loadIcon("/icons/shadow-l.png");
    private static final Image Shadow2Bottom = ShadowPainter.loadIcon("/icons/shadow2-b.png");
    private static final Image Shadow2BottomLeft = ShadowPainter.loadIcon("/icons/shadow2-bl.png");
    private static final Image Shadow2BottomRight = ShadowPainter.loadIcon("/icons/shadow2-br.png");
    private static final Image Shadow2Right = ShadowPainter.loadIcon("/icons/shadow2-r.png");
    private static final Image Shadow2TopRight = ShadowPainter.loadIcon("/icons/shadow2-tr.png");
    private static final Image Shadow2TopLeft = ShadowPainter.loadIcon("/icons/shadow2-tl.png");
    private static final Image Shadow2Left = ShadowPainter.loadIcon("/icons/shadow2-l.png");

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize, float alpha) {
        return ShadowPainter.createDropShadow(source, shadowSize /= 2, 0.7f * alpha, 0);
    }

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize, float shadowOpacity, int shadowRgb) {
        int a;
        int historyIdx;
        int aSum;
        if (shadowSize <= 0) {
            return source;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = new BufferedImage(width + 20, height + 20, 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage((Image)image, shadowSize, shadowSize, null);
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        shadowRgb &= 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = shadowOpacity / (float)shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        g2.drawImage(source, null, 0, 0);
        g2.dispose();
        return image;
    }

    public static BufferedImage createRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = new BufferedImage(width + 20, height + 20, type);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        ShadowPainter.drawRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createSmallRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = new BufferedImage(width + 10, height + 10, type);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        ShadowPainter.drawSmallRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics2D gc = image.createGraphics();
        try {
            ShadowPainter.drawRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSmallRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics2D gc = image.createGraphics();
        try {
            ShadowPainter.drawSmallRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    public static void drawRectangleShadow(Graphics2D gc, int x, int y, int width, int height) {
        assert (ShadowBottomLeft != null);
        assert (ShadowBottomRight.getWidth(null) == 20);
        assert (ShadowBottomRight.getHeight(null) == 20);
        int blWidth = ShadowBottomLeft.getWidth(null);
        int trHeight = ShadowTopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        gc.drawImage(ShadowBottomLeft, x - ShadowBottomLeft.getWidth(null), y + height, null);
        gc.drawImage(ShadowBottomRight, x + width, y + height, null);
        gc.drawImage(ShadowTopRight, x + width, y, null);
        gc.drawImage(ShadowTopLeft, x - ShadowTopLeft.getWidth(null), y, null);
        gc.drawImage(ShadowBottom, x, y + height, x + width, y + height + ShadowBottom.getHeight(null), 0, 0, ShadowBottom.getWidth(null), ShadowBottom.getHeight(null), null);
        gc.drawImage(ShadowRight, x + width, y + ShadowTopRight.getHeight(null), x + width + ShadowRight.getWidth(null), y + height, 0, 0, ShadowRight.getWidth(null), ShadowRight.getHeight(null), null);
        gc.drawImage(ShadowLeft, x - ShadowLeft.getWidth(null), y + ShadowTopLeft.getHeight(null), x, y + height, 0, 0, ShadowLeft.getWidth(null), ShadowLeft.getHeight(null), null);
    }

    public static void drawSmallRectangleShadow(Graphics2D gc, int x, int y, int width, int height) {
        assert (Shadow2BottomLeft != null);
        assert (Shadow2TopRight != null);
        assert (Shadow2BottomRight.getWidth(null) == 10);
        assert (Shadow2BottomRight.getHeight(null) == 10);
        int blWidth = Shadow2BottomLeft.getWidth(null);
        int trHeight = Shadow2TopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        gc.drawImage(Shadow2BottomLeft, x - Shadow2BottomLeft.getWidth(null), y + height, null);
        gc.drawImage(Shadow2BottomRight, x + width, y + height, null);
        gc.drawImage(Shadow2TopRight, x + width, y, null);
        gc.drawImage(Shadow2TopLeft, x - Shadow2TopLeft.getWidth(null), y, null);
        gc.drawImage(Shadow2Bottom, x, y + height, x + width, y + height + Shadow2Bottom.getHeight(null), 0, 0, Shadow2Bottom.getWidth(null), Shadow2Bottom.getHeight(null), null);
        gc.drawImage(Shadow2Right, x + width, y + Shadow2TopRight.getHeight(null), x + width + Shadow2Right.getWidth(null), y + height, 0, 0, Shadow2Right.getWidth(null), Shadow2Right.getHeight(null), null);
        gc.drawImage(Shadow2Left, x - Shadow2Left.getWidth(null), y + Shadow2TopLeft.getHeight(null), x, y + height, 0, 0, Shadow2Left.getWidth(null), Shadow2Left.getHeight(null), null);
    }

    private static Image loadIcon(String name) {
        InputStream inputStream = ShadowPainter.class.getResourceAsStream(name);
        if (inputStream == null) {
            throw new RuntimeException("Unable to load image for shadow: " + name);
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load image for shadow:" + name, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

