/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Canvas;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.SurfaceControl;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Surface
implements Parcelable {
    private static final String TAG = "Surface";
    public static final Parcelable.Creator<Surface> CREATOR = new Parcelable.Creator<Surface>(){

        @Override
        public Surface createFromParcel(Parcel source) {
            try {
                Surface s = new Surface();
                s.readFromParcel(source);
                return s;
            }
            catch (Exception e) {
                Log.e(Surface.TAG, "Exception creating surface from parcel", e);
                return null;
            }
        }

        public Surface[] newArray(int size) {
            return new Surface[size];
        }
    };
    private final CloseGuard mCloseGuard = CloseGuard.get();
    final Object mLock = new Object();
    private String mName;
    long mNativeObject;
    private long mLockedObject;
    private int mGenerationId;
    private final Canvas mCanvas = new CompatibleCanvas();
    private Matrix mCompatibleMatrix;
    private HwuiContext mHwuiContext;
    private boolean mIsSingleBuffered;
    private boolean mIsSharedBufferModeEnabled;
    private boolean mIsAutoRefreshEnabled;
    public static final int SCALING_MODE_FREEZE = 0;
    public static final int SCALING_MODE_SCALE_TO_WINDOW = 1;
    public static final int SCALING_MODE_SCALE_CROP = 2;
    public static final int SCALING_MODE_NO_SCALE_CROP = 3;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;

    private static long nativeCreateFromSurfaceTexture(SurfaceTexture surfaceTexture) throws OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.Surface#nativeCreateFromSurfaceTexture(Landroid/graphics/SurfaceTexture;)J", true, null);
    }

    private static long nativeCreateFromSurfaceControl(long l) {
        return OverrideMethod.invokeL("android.view.Surface#nativeCreateFromSurfaceControl(J)J", true, null);
    }

    private static long nativeGetFromSurfaceControl(long l) {
        return OverrideMethod.invokeL("android.view.Surface#nativeGetFromSurfaceControl(J)J", true, null);
    }

    private static long nativeLockCanvas(long l, Canvas canvas, Rect rect) throws OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.Surface#nativeLockCanvas(JLandroid/graphics/Canvas;Landroid/graphics/Rect;)J", true, null);
    }

    private static void nativeUnlockCanvasAndPost(long l, Canvas canvas) {
        OverrideMethod.invokeV("android.view.Surface#nativeUnlockCanvasAndPost(JLandroid/graphics/Canvas;)V", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.Surface#nativeRelease(J)V", true, null);
    }

    private static boolean nativeIsValid(long l) {
        return OverrideMethod.invokeI("android.view.Surface#nativeIsValid(J)Z", true, null) != 0;
    }

    private static boolean nativeIsConsumerRunningBehind(long l) {
        return OverrideMethod.invokeI("android.view.Surface#nativeIsConsumerRunningBehind(J)Z", true, null) != 0;
    }

    private static long nativeReadFromParcel(long l, Parcel parcel) {
        return OverrideMethod.invokeL("android.view.Surface#nativeReadFromParcel(JLandroid/os/Parcel;)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.Surface#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeAllocateBuffers(long l) {
        OverrideMethod.invokeV("android.view.Surface#nativeAllocateBuffers(J)V", true, null);
    }

    private static int nativeGetWidth(long l) {
        return OverrideMethod.invokeI("android.view.Surface#nativeGetWidth(J)I", true, null);
    }

    private static int nativeGetHeight(long l) {
        return OverrideMethod.invokeI("android.view.Surface#nativeGetHeight(J)I", true, null);
    }

    private static long nativeGetNextFrameNumber(long l) {
        return OverrideMethod.invokeL("android.view.Surface#nativeGetNextFrameNumber(J)J", true, null);
    }

    private static int nativeSetScalingMode(long l, int n) {
        return OverrideMethod.invokeI("android.view.Surface#nativeSetScalingMode(JI)I", true, null);
    }

    private static int nativeForceScopedDisconnect(long l) {
        return OverrideMethod.invokeI("android.view.Surface#nativeForceScopedDisconnect(J)I", true, null);
    }

    private static int nativeAttachAndQueueBuffer(long l, GraphicBuffer graphicBuffer) {
        return OverrideMethod.invokeI("android.view.Surface#nativeAttachAndQueueBuffer(JLandroid/graphics/GraphicBuffer;)I", true, null);
    }

    private static int nativeSetSharedBufferModeEnabled(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.Surface#nativeSetSharedBufferModeEnabled(JZ)I", true, null);
    }

    private static int nativeSetAutoRefreshEnabled(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.Surface#nativeSetAutoRefreshEnabled(JZ)I", true, null);
    }

    public Surface() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new IllegalArgumentException("surfaceTexture must not be null");
        }
        this.mIsSingleBuffered = surfaceTexture.isSingleBuffered();
        Object object = this.mLock;
        synchronized (object) {
            this.mName = surfaceTexture.toString();
            this.setNativeObjectLocked(Surface.nativeCreateFromSurfaceTexture(surfaceTexture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface(long nativeObject) {
        Object object = this.mLock;
        synchronized (object) {
            this.setNativeObjectLocked(nativeObject);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
                this.setNativeObjectLocked(0L);
            }
            if (this.mHwuiContext != null) {
                this.mHwuiContext.destroy();
                this.mHwuiContext = null;
            }
        }
    }

    public void destroy() {
        this.release();
    }

    public void hwuiDestroy() {
        if (this.mHwuiContext != null) {
            this.mHwuiContext.destroy();
            this.mHwuiContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject == 0L) {
                return false;
            }
            return Surface.nativeIsValid(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGenerationId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGenerationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextFrameNumber() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeGetNextFrameNumber(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerRunningBehind() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeIsConsumerRunningBehind(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockCanvas(Rect inOutDirty) throws OutOfResourcesException, IllegalArgumentException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mLockedObject != 0L) {
                throw new IllegalArgumentException("Surface was already locked");
            }
            this.mLockedObject = Surface.nativeLockCanvas(this.mNativeObject, this.mCanvas, inOutDirty);
            return this.mCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext != null) {
                this.mHwuiContext.unlockAndPost(canvas);
            } else {
                this.unlockSwCanvasAndPost(canvas);
            }
        }
    }

    private void unlockSwCanvasAndPost(Canvas canvas) {
        if (canvas != this.mCanvas) {
            throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
        }
        if (this.mNativeObject != this.mLockedObject) {
            Log.w(TAG, "WARNING: Surface's mNativeObject (0x" + Long.toHexString(this.mNativeObject) + ") != mLockedObject (0x" + Long.toHexString(this.mLockedObject) + ")");
        }
        if (this.mLockedObject == 0L) {
            throw new IllegalStateException("Surface was not locked");
        }
        try {
            Surface.nativeUnlockCanvasAndPost(this.mLockedObject, canvas);
        }
        finally {
            Surface.nativeRelease(this.mLockedObject);
            this.mLockedObject = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockHardwareCanvas() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext == null) {
                this.mHwuiContext = new HwuiContext(false);
            }
            return this.mHwuiContext.lockCanvas(Surface.nativeGetWidth(this.mNativeObject), Surface.nativeGetHeight(this.mNativeObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockHardwareWideColorGamutCanvas() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext != null && !this.mHwuiContext.isWideColorGamut()) {
                this.mHwuiContext.destroy();
                this.mHwuiContext = null;
            }
            if (this.mHwuiContext == null) {
                this.mHwuiContext = new HwuiContext(true);
            }
            return this.mHwuiContext.lockCanvas(Surface.nativeGetWidth(this.mNativeObject), Surface.nativeGetHeight(this.mNativeObject));
        }
    }

    @Deprecated
    public void unlockCanvas(Canvas canvas) {
        throw new UnsupportedOperationException();
    }

    void setCompatibilityTranslator(CompatibilityInfo.Translator translator) {
        if (translator != null) {
            float appScale = translator.applicationScale;
            this.mCompatibleMatrix = new Matrix();
            this.mCompatibleMatrix.setScale(appScale, appScale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(SurfaceControl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        long surfaceControlPtr = other.mNativeObject;
        if (surfaceControlPtr == 0L) {
            throw new NullPointerException("null SurfaceControl native object. Are you using a released SurfaceControl?");
        }
        long newNativeObject = Surface.nativeGetFromSurfaceControl(surfaceControlPtr);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(newNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFrom(SurfaceControl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        long surfaceControlPtr = other.mNativeObject;
        if (surfaceControlPtr == 0L) {
            throw new NullPointerException("null SurfaceControl native object. Are you using a released SurfaceControl?");
        }
        long newNativeObject = Surface.nativeCreateFromSurfaceControl(surfaceControlPtr);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(newNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void transferFrom(Surface other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (other != this) {
            long newPtr;
            Object object = other.mLock;
            synchronized (object) {
                newPtr = other.mNativeObject;
                other.setNativeObjectLocked(0L);
            }
            object = this.mLock;
            synchronized (object) {
                if (this.mNativeObject != 0L) {
                    Surface.nativeRelease(this.mNativeObject);
                }
                this.setNativeObjectLocked(newPtr);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromParcel(Parcel source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = source.readString();
            this.mIsSingleBuffered = source.readInt() != 0;
            this.setNativeObjectLocked(Surface.nativeReadFromParcel(this.mNativeObject, source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            dest.writeString(this.mName);
            dest.writeInt(this.mIsSingleBuffered ? 1 : 0);
            Surface.nativeWriteToParcel(this.mNativeObject, dest);
        }
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
        }
    }

    private void setNativeObjectLocked(long ptr) {
        if (this.mNativeObject != ptr) {
            if (this.mNativeObject == 0L && ptr != 0L) {
                this.mCloseGuard.open("release");
            } else if (this.mNativeObject != 0L && ptr == 0L) {
                this.mCloseGuard.close();
            }
            this.mNativeObject = ptr;
            ++this.mGenerationId;
            if (this.mHwuiContext != null) {
                this.mHwuiContext.updateSurface();
            }
        }
    }

    private void checkNotReleasedLocked() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Surface has already been released.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateBuffers() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            Surface.nativeAllocateBuffers(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScalingMode(int scalingMode) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int err = Surface.nativeSetScalingMode(this.mNativeObject, scalingMode);
            if (err != 0) {
                throw new IllegalArgumentException("Invalid scaling mode: " + scalingMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceScopedDisconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int err = Surface.nativeForceScopedDisconnect(this.mNativeObject);
            if (err != 0) {
                throw new RuntimeException("Failed to disconnect Surface instance (bad object?)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAndQueueBuffer(GraphicBuffer buffer) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int err = Surface.nativeAttachAndQueueBuffer(this.mNativeObject, buffer);
            if (err != 0) {
                throw new RuntimeException("Failed to attach and queue buffer to Surface (bad object?)");
            }
        }
    }

    public boolean isSingleBuffered() {
        return this.mIsSingleBuffered;
    }

    public void setSharedBufferModeEnabled(boolean enabled) {
        if (this.mIsSharedBufferModeEnabled != enabled) {
            int error = Surface.nativeSetSharedBufferModeEnabled(this.mNativeObject, enabled);
            if (error != 0) {
                throw new RuntimeException("Failed to set shared buffer mode on Surface (bad object?)");
            }
            this.mIsSharedBufferModeEnabled = enabled;
        }
    }

    public boolean isSharedBufferModeEnabled() {
        return this.mIsSharedBufferModeEnabled;
    }

    public void setAutoRefreshEnabled(boolean enabled) {
        if (this.mIsAutoRefreshEnabled != enabled) {
            int error = Surface.nativeSetAutoRefreshEnabled(this.mNativeObject, enabled);
            if (error != 0) {
                throw new RuntimeException("Failed to set auto refresh on Surface (bad object?)");
            }
            this.mIsAutoRefreshEnabled = enabled;
        }
    }

    public boolean isAutoRefreshEnabled() {
        return this.mIsAutoRefreshEnabled;
    }

    public static String rotationToString(int rotation) {
        switch (rotation) {
            case 0: {
                return "ROTATION_0";
            }
            case 1: {
                return "ROTATION_90";
            }
            case 2: {
                return "ROTATION_180";
            }
            case 3: {
                return "ROTATION_270";
            }
        }
        return Integer.toString(rotation);
    }

    private static long nHwuiCreate(long l, long l2, boolean bl) {
        return OverrideMethod.invokeL("android.view.Surface#nHwuiCreate(JJZ)J", true, null);
    }

    private static void nHwuiSetSurface(long l, long l2) {
        OverrideMethod.invokeV("android.view.Surface#nHwuiSetSurface(JJ)V", true, null);
    }

    private static void nHwuiDraw(long l) {
        OverrideMethod.invokeV("android.view.Surface#nHwuiDraw(J)V", true, null);
    }

    private static void nHwuiDestroy(long l) {
        OverrideMethod.invokeV("android.view.Surface#nHwuiDestroy(J)V", true, null);
    }

    private class HwuiContext {
        private final RenderNode mRenderNode = RenderNode.create("HwuiCanvas", null);
        private long mHwuiRenderer;
        private DisplayListCanvas mCanvas;
        private final boolean mIsWideColorGamut;

        HwuiContext(boolean isWideColorGamut) {
            this.mRenderNode.setClipToBounds(false);
            this.mIsWideColorGamut = isWideColorGamut;
            this.mHwuiRenderer = Surface.nHwuiCreate(this.mRenderNode.mNativeRenderNode, Surface.this.mNativeObject, isWideColorGamut);
        }

        Canvas lockCanvas(int width, int height) {
            if (this.mCanvas != null) {
                throw new IllegalStateException("Surface was already locked!");
            }
            this.mCanvas = this.mRenderNode.start(width, height);
            return this.mCanvas;
        }

        void unlockAndPost(Canvas canvas) {
            if (canvas != this.mCanvas) {
                throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
            }
            this.mRenderNode.end(this.mCanvas);
            this.mCanvas = null;
            Surface.nHwuiDraw(this.mHwuiRenderer);
        }

        void updateSurface() {
            Surface.nHwuiSetSurface(this.mHwuiRenderer, Surface.this.mNativeObject);
        }

        void destroy() {
            if (this.mHwuiRenderer != 0L) {
                Surface.nHwuiDestroy(this.mHwuiRenderer);
                this.mHwuiRenderer = 0L;
            }
        }

        boolean isWideColorGamut() {
            return this.mIsWideColorGamut;
        }
    }

    private class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        @Override
        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
            } else {
                Matrix m = new Matrix(Surface.this.mCompatibleMatrix);
                m.preConcat(matrix);
                super.setMatrix(m);
            }
        }

        @Override
        public void getMatrix(Matrix m) {
            super.getMatrix(m);
            if (this.mOrigMatrix == null) {
                this.mOrigMatrix = new Matrix();
            }
            this.mOrigMatrix.set(m);
        }
    }

    public static class OutOfResourcesException
    extends RuntimeException {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Rotation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScalingMode {
    }
}

