/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SystemApi;
import android.content.pm.ActivityInfo;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.Gravity;
import android.view.KeyboardShortcutGroup;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewManager;
import android.view.accessibility.AccessibilityNodeInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

public interface WindowManager
extends ViewManager {
    public static final int DOCKED_INVALID = -1;
    public static final int DOCKED_LEFT = 1;
    public static final int DOCKED_TOP = 2;
    public static final int DOCKED_RIGHT = 3;
    public static final int DOCKED_BOTTOM = 4;
    public static final String INPUT_CONSUMER_PIP = "pip_input_consumer";
    public static final String INPUT_CONSUMER_NAVIGATION = "nav_input_consumer";
    public static final String INPUT_CONSUMER_WALLPAPER = "wallpaper_input_consumer";
    public static final String INPUT_CONSUMER_RECENTS_ANIMATION = "recents_animation_input_consumer";
    public static final int TRANSIT_UNSET = -1;
    public static final int TRANSIT_NONE = 0;
    public static final int TRANSIT_ACTIVITY_OPEN = 6;
    public static final int TRANSIT_ACTIVITY_CLOSE = 7;
    public static final int TRANSIT_TASK_OPEN = 8;
    public static final int TRANSIT_TASK_CLOSE = 9;
    public static final int TRANSIT_TASK_TO_FRONT = 10;
    public static final int TRANSIT_TASK_TO_BACK = 11;
    public static final int TRANSIT_WALLPAPER_CLOSE = 12;
    public static final int TRANSIT_WALLPAPER_OPEN = 13;
    public static final int TRANSIT_WALLPAPER_INTRA_OPEN = 14;
    public static final int TRANSIT_WALLPAPER_INTRA_CLOSE = 15;
    public static final int TRANSIT_TASK_OPEN_BEHIND = 16;
    public static final int TRANSIT_TASK_IN_PLACE = 17;
    public static final int TRANSIT_ACTIVITY_RELAUNCH = 18;
    public static final int TRANSIT_DOCK_TASK_FROM_RECENTS = 19;
    public static final int TRANSIT_KEYGUARD_GOING_AWAY = 20;
    public static final int TRANSIT_KEYGUARD_GOING_AWAY_ON_WALLPAPER = 21;
    public static final int TRANSIT_KEYGUARD_OCCLUDE = 22;
    public static final int TRANSIT_KEYGUARD_UNOCCLUDE = 23;
    public static final int TRANSIT_TRANSLUCENT_ACTIVITY_OPEN = 24;
    public static final int TRANSIT_TRANSLUCENT_ACTIVITY_CLOSE = 25;
    public static final int TRANSIT_CRASHING_ACTIVITY_CLOSE = 26;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_TO_SHADE = 1;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_NO_ANIMATION = 2;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_WITH_WALLPAPER = 4;
    public static final int TAKE_SCREENSHOT_FULLSCREEN = 1;
    public static final int TAKE_SCREENSHOT_SELECTED_REGION = 2;
    public static final String PARCEL_KEY_SHORTCUTS_ARRAY = "shortcuts_array";

    public Display getDefaultDisplay();

    public void removeViewImmediate(View var1);

    public void requestAppKeyboardShortcuts(KeyboardShortcutsReceiver var1, int var2);

    @SystemApi
    public Region getCurrentImeTouchRegion();

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements Parcelable {
        @ViewDebug.ExportedProperty
        public int x;
        @ViewDebug.ExportedProperty
        public int y;
        @ViewDebug.ExportedProperty
        public float horizontalWeight;
        @ViewDebug.ExportedProperty
        public float verticalWeight;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=1, to="BASE_APPLICATION"), @ViewDebug.IntToString(from=2, to="APPLICATION"), @ViewDebug.IntToString(from=3, to="APPLICATION_STARTING"), @ViewDebug.IntToString(from=4, to="DRAWN_APPLICATION"), @ViewDebug.IntToString(from=1000, to="APPLICATION_PANEL"), @ViewDebug.IntToString(from=1001, to="APPLICATION_MEDIA"), @ViewDebug.IntToString(from=1002, to="APPLICATION_SUB_PANEL"), @ViewDebug.IntToString(from=1005, to="APPLICATION_ABOVE_SUB_PANEL"), @ViewDebug.IntToString(from=1003, to="APPLICATION_ATTACHED_DIALOG"), @ViewDebug.IntToString(from=1004, to="APPLICATION_MEDIA_OVERLAY"), @ViewDebug.IntToString(from=2000, to="STATUS_BAR"), @ViewDebug.IntToString(from=2001, to="SEARCH_BAR"), @ViewDebug.IntToString(from=2002, to="PHONE"), @ViewDebug.IntToString(from=2003, to="SYSTEM_ALERT"), @ViewDebug.IntToString(from=2005, to="TOAST"), @ViewDebug.IntToString(from=2006, to="SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2007, to="PRIORITY_PHONE"), @ViewDebug.IntToString(from=2008, to="SYSTEM_DIALOG"), @ViewDebug.IntToString(from=2009, to="KEYGUARD_DIALOG"), @ViewDebug.IntToString(from=2010, to="SYSTEM_ERROR"), @ViewDebug.IntToString(from=2011, to="INPUT_METHOD"), @ViewDebug.IntToString(from=2012, to="INPUT_METHOD_DIALOG"), @ViewDebug.IntToString(from=2013, to="WALLPAPER"), @ViewDebug.IntToString(from=2014, to="STATUS_BAR_PANEL"), @ViewDebug.IntToString(from=2015, to="SECURE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2016, to="DRAG"), @ViewDebug.IntToString(from=2017, to="STATUS_BAR_SUB_PANEL"), @ViewDebug.IntToString(from=2018, to="POINTER"), @ViewDebug.IntToString(from=2019, to="NAVIGATION_BAR"), @ViewDebug.IntToString(from=2020, to="VOLUME_OVERLAY"), @ViewDebug.IntToString(from=2021, to="BOOT_PROGRESS"), @ViewDebug.IntToString(from=2022, to="INPUT_CONSUMER"), @ViewDebug.IntToString(from=2023, to="DREAM"), @ViewDebug.IntToString(from=2024, to="NAVIGATION_BAR_PANEL"), @ViewDebug.IntToString(from=2026, to="DISPLAY_OVERLAY"), @ViewDebug.IntToString(from=2027, to="MAGNIFICATION_OVERLAY"), @ViewDebug.IntToString(from=2037, to="PRESENTATION"), @ViewDebug.IntToString(from=2030, to="PRIVATE_PRESENTATION"), @ViewDebug.IntToString(from=2031, to="VOICE_INTERACTION"), @ViewDebug.IntToString(from=2033, to="VOICE_INTERACTION_STARTING"), @ViewDebug.IntToString(from=2034, to="DOCK_DIVIDER"), @ViewDebug.IntToString(from=2035, to="QS_DIALOG"), @ViewDebug.IntToString(from=2036, to="SCREENSHOT"), @ViewDebug.IntToString(from=2038, to="APPLICATION_OVERLAY")})
        public int type;
        public static final int FIRST_APPLICATION_WINDOW = 1;
        public static final int TYPE_BASE_APPLICATION = 1;
        public static final int TYPE_APPLICATION = 2;
        public static final int TYPE_APPLICATION_STARTING = 3;
        public static final int TYPE_DRAWN_APPLICATION = 4;
        public static final int LAST_APPLICATION_WINDOW = 99;
        public static final int FIRST_SUB_WINDOW = 1000;
        public static final int TYPE_APPLICATION_PANEL = 1000;
        public static final int TYPE_APPLICATION_MEDIA = 1001;
        public static final int TYPE_APPLICATION_SUB_PANEL = 1002;
        public static final int TYPE_APPLICATION_ATTACHED_DIALOG = 1003;
        public static final int TYPE_APPLICATION_MEDIA_OVERLAY = 1004;
        public static final int TYPE_APPLICATION_ABOVE_SUB_PANEL = 1005;
        public static final int LAST_SUB_WINDOW = 1999;
        public static final int FIRST_SYSTEM_WINDOW = 2000;
        public static final int TYPE_STATUS_BAR = 2000;
        public static final int TYPE_SEARCH_BAR = 2001;
        @Deprecated
        public static final int TYPE_PHONE = 2002;
        @Deprecated
        public static final int TYPE_SYSTEM_ALERT = 2003;
        public static final int TYPE_KEYGUARD = 2004;
        @Deprecated
        public static final int TYPE_TOAST = 2005;
        @Deprecated
        public static final int TYPE_SYSTEM_OVERLAY = 2006;
        @Deprecated
        public static final int TYPE_PRIORITY_PHONE = 2007;
        public static final int TYPE_SYSTEM_DIALOG = 2008;
        public static final int TYPE_KEYGUARD_DIALOG = 2009;
        @Deprecated
        public static final int TYPE_SYSTEM_ERROR = 2010;
        public static final int TYPE_INPUT_METHOD = 2011;
        public static final int TYPE_INPUT_METHOD_DIALOG = 2012;
        public static final int TYPE_WALLPAPER = 2013;
        public static final int TYPE_STATUS_BAR_PANEL = 2014;
        public static final int TYPE_SECURE_SYSTEM_OVERLAY = 2015;
        public static final int TYPE_DRAG = 2016;
        public static final int TYPE_STATUS_BAR_SUB_PANEL = 2017;
        public static final int TYPE_POINTER = 2018;
        public static final int TYPE_NAVIGATION_BAR = 2019;
        public static final int TYPE_VOLUME_OVERLAY = 2020;
        public static final int TYPE_BOOT_PROGRESS = 2021;
        public static final int TYPE_INPUT_CONSUMER = 2022;
        public static final int TYPE_DREAM = 2023;
        public static final int TYPE_NAVIGATION_BAR_PANEL = 2024;
        public static final int TYPE_DISPLAY_OVERLAY = 2026;
        public static final int TYPE_MAGNIFICATION_OVERLAY = 2027;
        public static final int TYPE_PRIVATE_PRESENTATION = 2030;
        public static final int TYPE_VOICE_INTERACTION = 2031;
        public static final int TYPE_ACCESSIBILITY_OVERLAY = 2032;
        public static final int TYPE_VOICE_INTERACTION_STARTING = 2033;
        public static final int TYPE_DOCK_DIVIDER = 2034;
        public static final int TYPE_QS_DIALOG = 2035;
        public static final int TYPE_SCREENSHOT = 2036;
        public static final int TYPE_PRESENTATION = 2037;
        public static final int TYPE_APPLICATION_OVERLAY = 2038;
        public static final int LAST_SYSTEM_WINDOW = 2999;
        public static final int INVALID_WINDOW_TYPE = -1;
        @Deprecated
        public static final int MEMORY_TYPE_NORMAL = 0;
        @Deprecated
        public static final int MEMORY_TYPE_HARDWARE = 1;
        @Deprecated
        public static final int MEMORY_TYPE_GPU = 2;
        @Deprecated
        public static final int MEMORY_TYPE_PUSH_BUFFERS = 3;
        @Deprecated
        public int memoryType;
        public static final int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1;
        public static final int FLAG_DIM_BEHIND = 2;
        @Deprecated
        public static final int FLAG_BLUR_BEHIND = 4;
        public static final int FLAG_NOT_FOCUSABLE = 8;
        public static final int FLAG_NOT_TOUCHABLE = 16;
        public static final int FLAG_NOT_TOUCH_MODAL = 32;
        @Deprecated
        public static final int FLAG_TOUCHABLE_WHEN_WAKING = 64;
        public static final int FLAG_KEEP_SCREEN_ON = 128;
        public static final int FLAG_LAYOUT_IN_SCREEN = 256;
        public static final int FLAG_LAYOUT_NO_LIMITS = 512;
        public static final int FLAG_FULLSCREEN = 1024;
        public static final int FLAG_FORCE_NOT_FULLSCREEN = 2048;
        @Deprecated
        public static final int FLAG_DITHER = 4096;
        public static final int FLAG_SECURE = 8192;
        public static final int FLAG_SCALED = 16384;
        public static final int FLAG_IGNORE_CHEEK_PRESSES = 32768;
        public static final int FLAG_LAYOUT_INSET_DECOR = 65536;
        public static final int FLAG_ALT_FOCUSABLE_IM = 131072;
        public static final int FLAG_WATCH_OUTSIDE_TOUCH = 262144;
        @Deprecated
        public static final int FLAG_SHOW_WHEN_LOCKED = 524288;
        public static final int FLAG_SHOW_WALLPAPER = 0x100000;
        @Deprecated
        public static final int FLAG_TURN_SCREEN_ON = 0x200000;
        @Deprecated
        public static final int FLAG_DISMISS_KEYGUARD = 0x400000;
        public static final int FLAG_SPLIT_TOUCH = 0x800000;
        public static final int FLAG_HARDWARE_ACCELERATED = 0x1000000;
        public static final int FLAG_LAYOUT_IN_OVERSCAN = 0x2000000;
        public static final int FLAG_TRANSLUCENT_STATUS = 0x4000000;
        public static final int FLAG_TRANSLUCENT_NAVIGATION = 0x8000000;
        public static final int FLAG_LOCAL_FOCUS_MODE = 0x10000000;
        public static final int FLAG_SLIPPERY = 0x20000000;
        public static final int FLAG_LAYOUT_ATTACHED_IN_DECOR = 0x40000000;
        public static final int FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="ALLOW_LOCK_WHILE_SCREEN_ON"), @ViewDebug.FlagToString(mask=2, equals=2, name="DIM_BEHIND"), @ViewDebug.FlagToString(mask=4, equals=4, name="BLUR_BEHIND"), @ViewDebug.FlagToString(mask=8, equals=8, name="NOT_FOCUSABLE"), @ViewDebug.FlagToString(mask=16, equals=16, name="NOT_TOUCHABLE"), @ViewDebug.FlagToString(mask=32, equals=32, name="NOT_TOUCH_MODAL"), @ViewDebug.FlagToString(mask=64, equals=64, name="TOUCHABLE_WHEN_WAKING"), @ViewDebug.FlagToString(mask=128, equals=128, name="KEEP_SCREEN_ON"), @ViewDebug.FlagToString(mask=256, equals=256, name="LAYOUT_IN_SCREEN"), @ViewDebug.FlagToString(mask=512, equals=512, name="LAYOUT_NO_LIMITS"), @ViewDebug.FlagToString(mask=1024, equals=1024, name="FULLSCREEN"), @ViewDebug.FlagToString(mask=2048, equals=2048, name="FORCE_NOT_FULLSCREEN"), @ViewDebug.FlagToString(mask=4096, equals=4096, name="DITHER"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="SECURE"), @ViewDebug.FlagToString(mask=16384, equals=16384, name="SCALED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="IGNORE_CHEEK_PRESSES"), @ViewDebug.FlagToString(mask=65536, equals=65536, name="LAYOUT_INSET_DECOR"), @ViewDebug.FlagToString(mask=131072, equals=131072, name="ALT_FOCUSABLE_IM"), @ViewDebug.FlagToString(mask=262144, equals=262144, name="WATCH_OUTSIDE_TOUCH"), @ViewDebug.FlagToString(mask=524288, equals=524288, name="SHOW_WHEN_LOCKED"), @ViewDebug.FlagToString(mask=0x100000, equals=0x100000, name="SHOW_WALLPAPER"), @ViewDebug.FlagToString(mask=0x200000, equals=0x200000, name="TURN_SCREEN_ON"), @ViewDebug.FlagToString(mask=0x400000, equals=0x400000, name="DISMISS_KEYGUARD"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="SPLIT_TOUCH"), @ViewDebug.FlagToString(mask=0x1000000, equals=0x1000000, name="HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=0x2000000, equals=0x2000000, name="LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(mask=0x4000000, equals=0x4000000, name="TRANSLUCENT_STATUS"), @ViewDebug.FlagToString(mask=0x8000000, equals=0x8000000, name="TRANSLUCENT_NAVIGATION"), @ViewDebug.FlagToString(mask=0x10000000, equals=0x10000000, name="LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(mask=0x20000000, equals=0x20000000, name="FLAG_SLIPPERY"), @ViewDebug.FlagToString(mask=0x40000000, equals=0x40000000, name="FLAG_LAYOUT_ATTACHED_IN_DECOR"), @ViewDebug.FlagToString(mask=-2147483648, equals=-2147483648, name="DRAWS_SYSTEM_BAR_BACKGROUNDS")}, formatToHexString=true)
        public int flags;
        public static final int PRIVATE_FLAG_FAKE_HARDWARE_ACCELERATED = 1;
        public static final int PRIVATE_FLAG_FORCE_HARDWARE_ACCELERATED = 2;
        public static final int PRIVATE_FLAG_WANTS_OFFSET_NOTIFICATIONS = 4;
        public static final int PRIVATE_FLAG_SHOW_FOR_ALL_USERS = 16;
        public static final int PRIVATE_FLAG_NO_MOVE_ANIMATION = 64;
        public static final int PRIVATE_FLAG_COMPATIBLE_WINDOW = 128;
        public static final int PRIVATE_FLAG_SYSTEM_ERROR = 256;
        public static final int PRIVATE_FLAG_INHERIT_TRANSLUCENT_DECOR = 512;
        public static final int PRIVATE_FLAG_KEYGUARD = 1024;
        public static final int PRIVATE_FLAG_DISABLE_WALLPAPER_TOUCH_EVENTS = 2048;
        public static final int PRIVATE_FLAG_FORCE_STATUS_BAR_VISIBLE_TRANSPARENT = 4096;
        public static final int PRIVATE_FLAG_PRESERVE_GEOMETRY = 8192;
        public static final int PRIVATE_FLAG_FORCE_DECOR_VIEW_VISIBILITY = 16384;
        public static final int PRIVATE_FLAG_WILL_NOT_REPLACE_ON_RELAUNCH = 32768;
        public static final int PRIVATE_FLAG_LAYOUT_CHILD_WINDOW_IN_PARENT_FRAME = 65536;
        public static final int PRIVATE_FLAG_FORCE_DRAW_STATUS_BAR_BACKGROUND = 131072;
        public static final int PRIVATE_FLAG_SUSTAINED_PERFORMANCE_MODE = 262144;
        public static final int PRIVATE_FLAG_HIDE_NON_SYSTEM_OVERLAY_WINDOWS = 524288;
        public static final int PRIVATE_FLAG_IS_ROUNDED_CORNERS_OVERLAY = 0x100000;
        public static final int PRIVATE_FLAG_ACQUIRES_SLEEP_TOKEN = 0x200000;
        public static final int PRIVATE_FLAG_IS_SCREEN_DECOR = 0x400000;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="FAKE_HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=2, equals=2, name="FORCE_HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=4, equals=4, name="WANTS_OFFSET_NOTIFICATIONS"), @ViewDebug.FlagToString(mask=16, equals=16, name="SHOW_FOR_ALL_USERS"), @ViewDebug.FlagToString(mask=64, equals=64, name="NO_MOVE_ANIMATION"), @ViewDebug.FlagToString(mask=128, equals=128, name="COMPATIBLE_WINDOW"), @ViewDebug.FlagToString(mask=256, equals=256, name="SYSTEM_ERROR"), @ViewDebug.FlagToString(mask=512, equals=512, name="INHERIT_TRANSLUCENT_DECOR"), @ViewDebug.FlagToString(mask=1024, equals=1024, name="KEYGUARD"), @ViewDebug.FlagToString(mask=2048, equals=2048, name="DISABLE_WALLPAPER_TOUCH_EVENTS"), @ViewDebug.FlagToString(mask=4096, equals=4096, name="FORCE_STATUS_BAR_VISIBLE_TRANSPARENT"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="PRESERVE_GEOMETRY"), @ViewDebug.FlagToString(mask=16384, equals=16384, name="FORCE_DECOR_VIEW_VISIBILITY"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="WILL_NOT_REPLACE_ON_RELAUNCH"), @ViewDebug.FlagToString(mask=65536, equals=65536, name="LAYOUT_CHILD_WINDOW_IN_PARENT_FRAME"), @ViewDebug.FlagToString(mask=131072, equals=131072, name="FORCE_DRAW_STATUS_BAR_BACKGROUND"), @ViewDebug.FlagToString(mask=262144, equals=262144, name="SUSTAINED_PERFORMANCE_MODE"), @ViewDebug.FlagToString(mask=524288, equals=524288, name="HIDE_NON_SYSTEM_OVERLAY_WINDOWS"), @ViewDebug.FlagToString(mask=0x100000, equals=0x100000, name="IS_ROUNDED_CORNERS_OVERLAY"), @ViewDebug.FlagToString(mask=0x200000, equals=0x200000, name="ACQUIRES_SLEEP_TOKEN"), @ViewDebug.FlagToString(mask=0x400000, equals=0x400000, name="IS_SCREEN_DECOR")})
        public int privateFlags;
        public static final int NEEDS_MENU_UNSET = 0;
        public static final int NEEDS_MENU_SET_TRUE = 1;
        public static final int NEEDS_MENU_SET_FALSE = 2;
        public int needsMenuKey = 0;
        public static final int SOFT_INPUT_MASK_STATE = 15;
        public static final int SOFT_INPUT_STATE_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_STATE_UNCHANGED = 1;
        public static final int SOFT_INPUT_STATE_HIDDEN = 2;
        public static final int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3;
        public static final int SOFT_INPUT_STATE_VISIBLE = 4;
        public static final int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5;
        public static final int SOFT_INPUT_MASK_ADJUST = 240;
        public static final int SOFT_INPUT_ADJUST_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_ADJUST_RESIZE = 16;
        public static final int SOFT_INPUT_ADJUST_PAN = 32;
        public static final int SOFT_INPUT_ADJUST_NOTHING = 48;
        public static final int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256;
        public int softInputMode;
        public int gravity;
        public float horizontalMargin;
        public float verticalMargin;
        public final Rect surfaceInsets = new Rect();
        public boolean hasManualSurfaceInsets;
        public boolean preservePreviousSurfaceInsets = true;
        public int format;
        public int windowAnimations;
        public float alpha = 1.0f;
        public float dimAmount = 1.0f;
        public static final float BRIGHTNESS_OVERRIDE_NONE = -1.0f;
        public static final float BRIGHTNESS_OVERRIDE_OFF = 0.0f;
        public static final float BRIGHTNESS_OVERRIDE_FULL = 1.0f;
        public float screenBrightness = -1.0f;
        public float buttonBrightness = -1.0f;
        public static final int ROTATION_ANIMATION_UNSPECIFIED = -1;
        public static final int ROTATION_ANIMATION_ROTATE = 0;
        public static final int ROTATION_ANIMATION_CROSSFADE = 1;
        public static final int ROTATION_ANIMATION_JUMPCUT = 2;
        public static final int ROTATION_ANIMATION_SEAMLESS = 3;
        public int rotationAnimation = 0;
        public IBinder token = null;
        public String packageName = null;
        public int screenOrientation = -1;
        @Deprecated
        public float preferredRefreshRate;
        public int preferredDisplayModeId;
        public int systemUiVisibility;
        public int subtreeSystemUiVisibility;
        public boolean hasSystemUiListeners;
        public int layoutInDisplayCutoutMode = 0;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_DEFAULT = 0;
        @Deprecated
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS = 1;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES = 1;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_NEVER = 2;
        public static final int INPUT_FEATURE_DISABLE_POINTER_GESTURES = 1;
        public static final int INPUT_FEATURE_NO_INPUT_CHANNEL = 2;
        public static final int INPUT_FEATURE_DISABLE_USER_ACTIVITY = 4;
        public int inputFeatures;
        public long userActivityTimeout = -1L;
        public long accessibilityIdOfAnchor = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        public CharSequence accessibilityTitle;
        public long hideTimeoutMilliseconds = -1L;
        private int mColorMode = 0;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            @Override
            public LayoutParams createFromParcel(Parcel in) {
                return new LayoutParams(in);
            }

            public LayoutParams[] newArray(int size) {
                return new LayoutParams[size];
            }
        };
        public static final int LAYOUT_CHANGED = 1;
        public static final int TYPE_CHANGED = 2;
        public static final int FLAGS_CHANGED = 4;
        public static final int FORMAT_CHANGED = 8;
        public static final int ANIMATION_CHANGED = 16;
        public static final int DIM_AMOUNT_CHANGED = 32;
        public static final int TITLE_CHANGED = 64;
        public static final int ALPHA_CHANGED = 128;
        public static final int MEMORY_TYPE_CHANGED = 256;
        public static final int SOFT_INPUT_MODE_CHANGED = 512;
        public static final int SCREEN_ORIENTATION_CHANGED = 1024;
        public static final int SCREEN_BRIGHTNESS_CHANGED = 2048;
        public static final int ROTATION_ANIMATION_CHANGED = 4096;
        public static final int BUTTON_BRIGHTNESS_CHANGED = 8192;
        public static final int SYSTEM_UI_VISIBILITY_CHANGED = 16384;
        public static final int SYSTEM_UI_LISTENER_CHANGED = 32768;
        public static final int INPUT_FEATURES_CHANGED = 65536;
        public static final int PRIVATE_FLAGS_CHANGED = 131072;
        public static final int USER_ACTIVITY_TIMEOUT_CHANGED = 262144;
        public static final int TRANSLUCENT_FLAGS_CHANGED = 524288;
        public static final int SURFACE_INSETS_CHANGED = 0x100000;
        public static final int PREFERRED_REFRESH_RATE_CHANGED = 0x200000;
        public static final int NEEDS_MENU_KEY_CHANGED = 0x400000;
        public static final int PREFERRED_DISPLAY_MODE_ID = 0x800000;
        public static final int ACCESSIBILITY_ANCHOR_CHANGED = 0x1000000;
        public static final int ACCESSIBILITY_TITLE_CHANGED = 0x2000000;
        public static final int COLOR_MODE_CHANGED = 0x4000000;
        public static final int EVERYTHING_CHANGED = -1;
        private int[] mCompatibilityParamsBackup = null;
        private CharSequence mTitle = null;

        public static boolean isSystemAlertWindowType(int type) {
            switch (type) {
                case 2002: 
                case 2003: 
                case 2006: 
                case 2007: 
                case 2010: 
                case 2038: {
                    return true;
                }
            }
            return false;
        }

        public static boolean mayUseInputMethod(int flags) {
            switch (flags & 0x20008) {
                case 0: 
                case 131080: {
                    return true;
                }
            }
            return false;
        }

        public LayoutParams() {
            super(-1, -1);
            this.type = 2;
            this.format = -1;
        }

        public LayoutParams(int _type) {
            super(-1, -1);
            this.type = _type;
            this.format = -1;
        }

        public LayoutParams(int _type, int _flags) {
            super(-1, -1);
            this.type = _type;
            this.flags = _flags;
            this.format = -1;
        }

        public LayoutParams(int _type, int _flags, int _format) {
            super(-1, -1);
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public LayoutParams(int w, int h, int _type, int _flags, int _format) {
            super(w, h);
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public LayoutParams(int w, int h, int xpos, int ypos, int _type, int _flags, int _format) {
            super(w, h);
            this.x = xpos;
            this.y = ypos;
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public void setTitle(CharSequence title) {
            if (null == title) {
                title = "";
            }
            this.mTitle = TextUtils.stringOrSpannedString(title);
        }

        public CharSequence getTitle() {
            return this.mTitle != null ? this.mTitle : "";
        }

        public void setSurfaceInsets(View view, boolean manual, boolean preservePrevious) {
            int surfaceInset = (int)Math.ceil(view.getZ() * 2.0f);
            if (surfaceInset == 0) {
                this.surfaceInsets.set(0, 0, 0, 0);
            } else {
                this.surfaceInsets.set(Math.max(surfaceInset, this.surfaceInsets.left), Math.max(surfaceInset, this.surfaceInsets.top), Math.max(surfaceInset, this.surfaceInsets.right), Math.max(surfaceInset, this.surfaceInsets.bottom));
            }
            this.hasManualSurfaceInsets = manual;
            this.preservePreviousSurfaceInsets = preservePrevious;
        }

        public void setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        @SystemApi
        public void setUserActivityTimeout(long timeout) {
            this.userActivityTimeout = timeout;
        }

        @SystemApi
        public long getUserActivityTimeout() {
            return this.userActivityTimeout;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.width);
            out.writeInt(this.height);
            out.writeInt(this.x);
            out.writeInt(this.y);
            out.writeInt(this.type);
            out.writeInt(this.flags);
            out.writeInt(this.privateFlags);
            out.writeInt(this.softInputMode);
            out.writeInt(this.layoutInDisplayCutoutMode);
            out.writeInt(this.gravity);
            out.writeFloat(this.horizontalMargin);
            out.writeFloat(this.verticalMargin);
            out.writeInt(this.format);
            out.writeInt(this.windowAnimations);
            out.writeFloat(this.alpha);
            out.writeFloat(this.dimAmount);
            out.writeFloat(this.screenBrightness);
            out.writeFloat(this.buttonBrightness);
            out.writeInt(this.rotationAnimation);
            out.writeStrongBinder(this.token);
            out.writeString(this.packageName);
            TextUtils.writeToParcel(this.mTitle, out, parcelableFlags);
            out.writeInt(this.screenOrientation);
            out.writeFloat(this.preferredRefreshRate);
            out.writeInt(this.preferredDisplayModeId);
            out.writeInt(this.systemUiVisibility);
            out.writeInt(this.subtreeSystemUiVisibility);
            out.writeInt(this.hasSystemUiListeners ? 1 : 0);
            out.writeInt(this.inputFeatures);
            out.writeLong(this.userActivityTimeout);
            out.writeInt(this.surfaceInsets.left);
            out.writeInt(this.surfaceInsets.top);
            out.writeInt(this.surfaceInsets.right);
            out.writeInt(this.surfaceInsets.bottom);
            out.writeInt(this.hasManualSurfaceInsets ? 1 : 0);
            out.writeInt(this.preservePreviousSurfaceInsets ? 1 : 0);
            out.writeInt(this.needsMenuKey);
            out.writeLong(this.accessibilityIdOfAnchor);
            TextUtils.writeToParcel(this.accessibilityTitle, out, parcelableFlags);
            out.writeInt(this.mColorMode);
            out.writeLong(this.hideTimeoutMilliseconds);
        }

        public LayoutParams(Parcel in) {
            this.width = in.readInt();
            this.height = in.readInt();
            this.x = in.readInt();
            this.y = in.readInt();
            this.type = in.readInt();
            this.flags = in.readInt();
            this.privateFlags = in.readInt();
            this.softInputMode = in.readInt();
            this.layoutInDisplayCutoutMode = in.readInt();
            this.gravity = in.readInt();
            this.horizontalMargin = in.readFloat();
            this.verticalMargin = in.readFloat();
            this.format = in.readInt();
            this.windowAnimations = in.readInt();
            this.alpha = in.readFloat();
            this.dimAmount = in.readFloat();
            this.screenBrightness = in.readFloat();
            this.buttonBrightness = in.readFloat();
            this.rotationAnimation = in.readInt();
            this.token = in.readStrongBinder();
            this.packageName = in.readString();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.screenOrientation = in.readInt();
            this.preferredRefreshRate = in.readFloat();
            this.preferredDisplayModeId = in.readInt();
            this.systemUiVisibility = in.readInt();
            this.subtreeSystemUiVisibility = in.readInt();
            this.hasSystemUiListeners = in.readInt() != 0;
            this.inputFeatures = in.readInt();
            this.userActivityTimeout = in.readLong();
            this.surfaceInsets.left = in.readInt();
            this.surfaceInsets.top = in.readInt();
            this.surfaceInsets.right = in.readInt();
            this.surfaceInsets.bottom = in.readInt();
            this.hasManualSurfaceInsets = in.readInt() != 0;
            this.preservePreviousSurfaceInsets = in.readInt() != 0;
            this.needsMenuKey = in.readInt();
            this.accessibilityIdOfAnchor = in.readLong();
            this.accessibilityTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mColorMode = in.readInt();
            this.hideTimeoutMilliseconds = in.readLong();
        }

        public int copyFrom(LayoutParams o) {
            int changes = 0;
            if (this.width != o.width) {
                this.width = o.width;
                changes |= 1;
            }
            if (this.height != o.height) {
                this.height = o.height;
                changes |= 1;
            }
            if (this.x != o.x) {
                this.x = o.x;
                changes |= 1;
            }
            if (this.y != o.y) {
                this.y = o.y;
                changes |= 1;
            }
            if (this.horizontalWeight != o.horizontalWeight) {
                this.horizontalWeight = o.horizontalWeight;
                changes |= 1;
            }
            if (this.verticalWeight != o.verticalWeight) {
                this.verticalWeight = o.verticalWeight;
                changes |= 1;
            }
            if (this.horizontalMargin != o.horizontalMargin) {
                this.horizontalMargin = o.horizontalMargin;
                changes |= 1;
            }
            if (this.verticalMargin != o.verticalMargin) {
                this.verticalMargin = o.verticalMargin;
                changes |= 1;
            }
            if (this.type != o.type) {
                this.type = o.type;
                changes |= 2;
            }
            if (this.flags != o.flags) {
                int diff = this.flags ^ o.flags;
                if ((diff & 0xC000000) != 0) {
                    changes |= 0x80000;
                }
                this.flags = o.flags;
                changes |= 4;
            }
            if (this.privateFlags != o.privateFlags) {
                this.privateFlags = o.privateFlags;
                changes |= 0x20000;
            }
            if (this.softInputMode != o.softInputMode) {
                this.softInputMode = o.softInputMode;
                changes |= 0x200;
            }
            if (this.layoutInDisplayCutoutMode != o.layoutInDisplayCutoutMode) {
                this.layoutInDisplayCutoutMode = o.layoutInDisplayCutoutMode;
                changes |= 1;
            }
            if (this.gravity != o.gravity) {
                this.gravity = o.gravity;
                changes |= 1;
            }
            if (this.format != o.format) {
                this.format = o.format;
                changes |= 8;
            }
            if (this.windowAnimations != o.windowAnimations) {
                this.windowAnimations = o.windowAnimations;
                changes |= 0x10;
            }
            if (this.token == null) {
                this.token = o.token;
            }
            if (this.packageName == null) {
                this.packageName = o.packageName;
            }
            if (!Objects.equals(this.mTitle, o.mTitle) && o.mTitle != null) {
                this.mTitle = o.mTitle;
                changes |= 0x40;
            }
            if (this.alpha != o.alpha) {
                this.alpha = o.alpha;
                changes |= 0x80;
            }
            if (this.dimAmount != o.dimAmount) {
                this.dimAmount = o.dimAmount;
                changes |= 0x20;
            }
            if (this.screenBrightness != o.screenBrightness) {
                this.screenBrightness = o.screenBrightness;
                changes |= 0x800;
            }
            if (this.buttonBrightness != o.buttonBrightness) {
                this.buttonBrightness = o.buttonBrightness;
                changes |= 0x2000;
            }
            if (this.rotationAnimation != o.rotationAnimation) {
                this.rotationAnimation = o.rotationAnimation;
                changes |= 0x1000;
            }
            if (this.screenOrientation != o.screenOrientation) {
                this.screenOrientation = o.screenOrientation;
                changes |= 0x400;
            }
            if (this.preferredRefreshRate != o.preferredRefreshRate) {
                this.preferredRefreshRate = o.preferredRefreshRate;
                changes |= 0x200000;
            }
            if (this.preferredDisplayModeId != o.preferredDisplayModeId) {
                this.preferredDisplayModeId = o.preferredDisplayModeId;
                changes |= 0x800000;
            }
            if (this.systemUiVisibility != o.systemUiVisibility || this.subtreeSystemUiVisibility != o.subtreeSystemUiVisibility) {
                this.systemUiVisibility = o.systemUiVisibility;
                this.subtreeSystemUiVisibility = o.subtreeSystemUiVisibility;
                changes |= 0x4000;
            }
            if (this.hasSystemUiListeners != o.hasSystemUiListeners) {
                this.hasSystemUiListeners = o.hasSystemUiListeners;
                changes |= 0x8000;
            }
            if (this.inputFeatures != o.inputFeatures) {
                this.inputFeatures = o.inputFeatures;
                changes |= 0x10000;
            }
            if (this.userActivityTimeout != o.userActivityTimeout) {
                this.userActivityTimeout = o.userActivityTimeout;
                changes |= 0x40000;
            }
            if (!this.surfaceInsets.equals(o.surfaceInsets)) {
                this.surfaceInsets.set(o.surfaceInsets);
                changes |= 0x100000;
            }
            if (this.hasManualSurfaceInsets != o.hasManualSurfaceInsets) {
                this.hasManualSurfaceInsets = o.hasManualSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.preservePreviousSurfaceInsets != o.preservePreviousSurfaceInsets) {
                this.preservePreviousSurfaceInsets = o.preservePreviousSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.needsMenuKey != o.needsMenuKey) {
                this.needsMenuKey = o.needsMenuKey;
                changes |= 0x400000;
            }
            if (this.accessibilityIdOfAnchor != o.accessibilityIdOfAnchor) {
                this.accessibilityIdOfAnchor = o.accessibilityIdOfAnchor;
                changes |= 0x1000000;
            }
            if (!Objects.equals(this.accessibilityTitle, o.accessibilityTitle) && o.accessibilityTitle != null) {
                this.accessibilityTitle = o.accessibilityTitle;
                changes |= 0x2000000;
            }
            if (this.mColorMode != o.mColorMode) {
                this.mColorMode = o.mColorMode;
                changes |= 0x4000000;
            }
            this.hideTimeoutMilliseconds = o.hideTimeoutMilliseconds;
            return changes;
        }

        @Override
        public String debug(String output) {
            output = output + "Contents of " + this + ":";
            Log.d("Debug", output);
            output = super.debug("");
            Log.d("Debug", output);
            Log.d("Debug", "");
            Log.d("Debug", "WindowManager.LayoutParams={title=" + this.mTitle + "}");
            return "";
        }

        public String toString() {
            return this.toString("");
        }

        public void dumpDimensions(StringBuilder sb) {
            sb.append('(');
            sb.append(this.x);
            sb.append(',');
            sb.append(this.y);
            sb.append(")(");
            sb.append(this.width == -1 ? "fill" : (this.width == -2 ? "wrap" : String.valueOf(this.width)));
            sb.append('x');
            sb.append(this.height == -1 ? "fill" : (this.height == -2 ? "wrap" : String.valueOf(this.height)));
            sb.append(")");
        }

        public String toString(String prefix) {
            StringBuilder sb = new StringBuilder(256);
            sb.append('{');
            this.dumpDimensions(sb);
            if (this.horizontalMargin != 0.0f) {
                sb.append(" hm=");
                sb.append(this.horizontalMargin);
            }
            if (this.verticalMargin != 0.0f) {
                sb.append(" vm=");
                sb.append(this.verticalMargin);
            }
            if (this.gravity != 0) {
                sb.append(" gr=");
                sb.append(Gravity.toString(this.gravity));
            }
            if (this.softInputMode != 0) {
                sb.append(" sim={");
                sb.append(LayoutParams.softInputModeToString(this.softInputMode));
                sb.append('}');
            }
            if (this.layoutInDisplayCutoutMode != 0) {
                sb.append(" layoutInDisplayCutoutMode=");
                sb.append(LayoutParams.layoutInDisplayCutoutModeToString(this.layoutInDisplayCutoutMode));
            }
            sb.append(" ty=");
            sb.append(ViewDebug.intToString(LayoutParams.class, "type", this.type));
            if (this.format != -1) {
                sb.append(" fmt=");
                sb.append(PixelFormat.formatToString(this.format));
            }
            if (this.windowAnimations != 0) {
                sb.append(" wanim=0x");
                sb.append(Integer.toHexString(this.windowAnimations));
            }
            if (this.screenOrientation != -1) {
                sb.append(" or=");
                sb.append(ActivityInfo.screenOrientationToString(this.screenOrientation));
            }
            if (this.alpha != 1.0f) {
                sb.append(" alpha=");
                sb.append(this.alpha);
            }
            if (this.screenBrightness != -1.0f) {
                sb.append(" sbrt=");
                sb.append(this.screenBrightness);
            }
            if (this.buttonBrightness != -1.0f) {
                sb.append(" bbrt=");
                sb.append(this.buttonBrightness);
            }
            if (this.rotationAnimation != 0) {
                sb.append(" rotAnim=");
                sb.append(LayoutParams.rotationAnimationToString(this.rotationAnimation));
            }
            if (this.preferredRefreshRate != 0.0f) {
                sb.append(" preferredRefreshRate=");
                sb.append(this.preferredRefreshRate);
            }
            if (this.preferredDisplayModeId != 0) {
                sb.append(" preferredDisplayMode=");
                sb.append(this.preferredDisplayModeId);
            }
            if (this.hasSystemUiListeners) {
                sb.append(" sysuil=");
                sb.append(this.hasSystemUiListeners);
            }
            if (this.inputFeatures != 0) {
                sb.append(" if=").append(LayoutParams.inputFeatureToString(this.inputFeatures));
            }
            if (this.userActivityTimeout >= 0L) {
                sb.append(" userActivityTimeout=").append(this.userActivityTimeout);
            }
            if (this.surfaceInsets.left != 0 || this.surfaceInsets.top != 0 || this.surfaceInsets.right != 0 || this.surfaceInsets.bottom != 0 || this.hasManualSurfaceInsets || !this.preservePreviousSurfaceInsets) {
                sb.append(" surfaceInsets=").append(this.surfaceInsets);
                if (this.hasManualSurfaceInsets) {
                    sb.append(" (manual)");
                }
                if (!this.preservePreviousSurfaceInsets) {
                    sb.append(" (!preservePreviousSurfaceInsets)");
                }
            }
            if (this.needsMenuKey == 1) {
                sb.append(" needsMenuKey");
            }
            if (this.mColorMode != 0) {
                sb.append(" colorMode=").append(ActivityInfo.colorModeToString(this.mColorMode));
            }
            sb.append(System.lineSeparator());
            sb.append(prefix).append("  fl=").append(ViewDebug.flagsToString(LayoutParams.class, "flags", this.flags));
            if (this.privateFlags != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  pfl=").append(ViewDebug.flagsToString(LayoutParams.class, "privateFlags", this.privateFlags));
            }
            if (this.systemUiVisibility != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  sysui=").append(ViewDebug.flagsToString(View.class, "mSystemUiVisibility", this.systemUiVisibility));
            }
            if (this.subtreeSystemUiVisibility != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  vsysui=").append(ViewDebug.flagsToString(View.class, "mSystemUiVisibility", this.subtreeSystemUiVisibility));
            }
            sb.append('}');
            return sb.toString();
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.type);
            proto.write(1120986464258L, this.x);
            proto.write(1120986464259L, this.y);
            proto.write(1120986464260L, this.width);
            proto.write(0x10500000005L, this.height);
            proto.write(1108101562374L, this.horizontalMargin);
            proto.write(1108101562375L, this.verticalMargin);
            proto.write(1120986464264L, this.gravity);
            proto.write(1120986464265L, this.softInputMode);
            proto.write(1159641169930L, this.format);
            proto.write(1120986464267L, this.windowAnimations);
            proto.write(1108101562380L, this.alpha);
            proto.write(1108101562381L, this.screenBrightness);
            proto.write(1108101562382L, this.buttonBrightness);
            proto.write(1159641169935L, this.rotationAnimation);
            proto.write(0x10200000010L, this.preferredRefreshRate);
            proto.write(0x10500000011L, this.preferredDisplayModeId);
            proto.write(1133871366162L, this.hasSystemUiListeners);
            proto.write(1155346202643L, this.inputFeatures);
            proto.write(1112396529684L, this.userActivityTimeout);
            proto.write(1159641169942L, this.needsMenuKey);
            proto.write(1159641169943L, this.mColorMode);
            proto.write(1155346202648L, this.flags);
            proto.write(1155346202650L, this.privateFlags);
            proto.write(1155346202651L, this.systemUiVisibility);
            proto.write(1155346202652L, this.subtreeSystemUiVisibility);
            proto.end(token);
        }

        public void scale(float scale) {
            this.x = (int)((float)this.x * scale + 0.5f);
            this.y = (int)((float)this.y * scale + 0.5f);
            if (this.width > 0) {
                this.width = (int)((float)this.width * scale + 0.5f);
            }
            if (this.height > 0) {
                this.height = (int)((float)this.height * scale + 0.5f);
            }
        }

        void backup() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup == null) {
                backup = this.mCompatibilityParamsBackup = new int[4];
            }
            backup[0] = this.x;
            backup[1] = this.y;
            backup[2] = this.width;
            backup[3] = this.height;
        }

        void restore() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup != null) {
                this.x = backup[0];
                this.y = backup[1];
                this.width = backup[2];
                this.height = backup[3];
            }
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("x", this.x);
            encoder.addProperty("y", this.y);
            encoder.addProperty("horizontalWeight", this.horizontalWeight);
            encoder.addProperty("verticalWeight", this.verticalWeight);
            encoder.addProperty("type", this.type);
            encoder.addProperty("flags", this.flags);
        }

        public boolean isFullscreen() {
            return this.x == 0 && this.y == 0 && this.width == -1 && this.height == -1;
        }

        private static String layoutInDisplayCutoutModeToString(int mode) {
            switch (mode) {
                case 0: {
                    return "default";
                }
                case 1: {
                    return "always";
                }
                case 2: {
                    return "never";
                }
            }
            return "unknown(" + mode + ")";
        }

        private static String softInputModeToString(int softInputMode) {
            int adjust;
            StringBuilder result = new StringBuilder();
            int state = softInputMode & 0xF;
            if (state != 0) {
                result.append("state=");
                switch (state) {
                    case 1: {
                        result.append("unchanged");
                        break;
                    }
                    case 2: {
                        result.append("hidden");
                        break;
                    }
                    case 3: {
                        result.append("always_hidden");
                        break;
                    }
                    case 4: {
                        result.append("visible");
                        break;
                    }
                    case 5: {
                        result.append("always_visible");
                        break;
                    }
                    default: {
                        result.append(state);
                    }
                }
                result.append(' ');
            }
            if ((adjust = softInputMode & 0xF0) != 0) {
                result.append("adjust=");
                switch (adjust) {
                    case 16: {
                        result.append("resize");
                        break;
                    }
                    case 32: {
                        result.append("pan");
                        break;
                    }
                    case 48: {
                        result.append("nothing");
                        break;
                    }
                    default: {
                        result.append(adjust);
                    }
                }
                result.append(' ');
            }
            if ((softInputMode & 0x100) != 0) {
                result.append("forwardNavigation").append(' ');
            }
            result.deleteCharAt(result.length() - 1);
            return result.toString();
        }

        private static String rotationAnimationToString(int rotationAnimation) {
            switch (rotationAnimation) {
                case -1: {
                    return "UNSPECIFIED";
                }
                case 0: {
                    return "ROTATE";
                }
                case 1: {
                    return "CROSSFADE";
                }
                case 2: {
                    return "JUMPCUT";
                }
                case 3: {
                    return "SEAMLESS";
                }
            }
            return Integer.toString(rotationAnimation);
        }

        private static String inputFeatureToString(int inputFeature) {
            switch (inputFeature) {
                case 1: {
                    return "DISABLE_POINTER_GESTURES";
                }
                case 2: {
                    return "NO_INPUT_CHANNEL";
                }
                case 4: {
                    return "DISABLE_USER_ACTIVITY";
                }
            }
            return Integer.toString(inputFeature);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface LayoutInDisplayCutoutMode {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SoftInputModeFlags {
        }
    }

    public static interface KeyboardShortcutsReceiver {
        public void onKeyboardShortcutsReceived(List<KeyboardShortcutGroup> var1);
    }

    public static class InvalidDisplayException
    extends RuntimeException {
        public InvalidDisplayException() {
        }

        public InvalidDisplayException(String name) {
            super(name);
        }
    }

    public static class BadTokenException
    extends RuntimeException {
        public BadTokenException() {
        }

        public BadTokenException(String name) {
            super(name);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransitionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransitionType {
    }
}

