/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.PendingIntent;
import android.app.RemoteAction;
import android.content.ComponentName;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.os.UserManager;
import android.provider.CalendarContract;
import android.view.textclassifier.GenerateLinksLogger;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImplNative;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextClassifierImpl
implements TextClassifier {
    private static final String LOG_TAG = "androidtc";
    private static final String MODEL_DIR = "/etc/textclassifier/";
    private static final String MODEL_FILE_REGEX = "textclassifier\\.(.*)\\.model";
    private static final String UPDATED_MODEL_FILE_PATH = "/data/misc/textclassifier/textclassifier.model";
    private final Context mContext;
    private final TextClassifier mFallback;
    private final GenerateLinksLogger mGenerateLinksLogger;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private List<ModelFile> mAllModelFiles;
    @GuardedBy(value="mLock")
    private ModelFile mModel;
    @GuardedBy(value="mLock")
    private TextClassifierImplNative mNative;
    private final Object mLoggerLock = new Object();
    @GuardedBy(value="mLoggerLock")
    private SelectionSessionLogger mSessionLogger;
    private final TextClassificationConstants mSettings;

    public TextClassifierImpl(Context context, TextClassificationConstants settings, TextClassifier fallback) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mFallback = Preconditions.checkNotNull(fallback);
        this.mSettings = Preconditions.checkNotNull(settings);
        this.mGenerateLinksLogger = new GenerateLinksLogger(this.mSettings.getGenerateLinksLogSampleRate());
    }

    public TextClassifierImpl(Context context, TextClassificationConstants settings) {
        this(context, settings, TextClassifier.NO_OP);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getSuggestSelectionMaxRangeLength()) {
                int end;
                int start;
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                ZonedDateTime refTime = ZonedDateTime.now();
                TextClassifierImplNative nativeImpl = this.getNative(request.getDefaultLocales());
                if (this.mSettings.isModelDarkLaunchEnabled() && !request.isDarkLaunchAllowed()) {
                    start = request.getStartIndex();
                    end = request.getEndIndex();
                } else {
                    int[] startEnd = nativeImpl.suggestSelection(string2, request.getStartIndex(), request.getEndIndex(), new TextClassifierImplNative.SelectionOptions(localesString));
                    start = startEnd[0];
                    end = startEnd[1];
                }
                if (start < end && start >= 0 && end <= string2.length() && start <= request.getStartIndex() && end >= request.getEndIndex()) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end);
                    TextClassifierImplNative.ClassificationResult[] results = nativeImpl.classifyText(string2, start, end, new TextClassifierImplNative.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString));
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].getCollection(), results[i].getScore());
                    }
                    return tsBuilder.setId(this.createId(string2, request.getStartIndex(), request.getEndIndex())).build();
                }
                Log.d(LOG_TAG, "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return this.mFallback.suggestSelection(request);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getClassifyTextMaxRangeLength()) {
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                ZonedDateTime refTime = request.getReferenceTime() != null ? request.getReferenceTime() : ZonedDateTime.now();
                TextClassifierImplNative.ClassificationResult[] results = this.getNative(request.getDefaultLocales()).classifyText(string2, request.getStartIndex(), request.getEndIndex(), new TextClassifierImplNative.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString));
                if (results.length > 0) {
                    return this.createClassificationResult(results, string2, request.getStartIndex(), request.getEndIndex(), refTime.toInstant());
                }
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting text classification info.", t);
        }
        return this.mFallback.classifyText(request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkTextLength(request.getText(), this.getMaxGenerateLinksTextLength());
        TextClassifier.Utils.checkMainThread();
        if (!this.mSettings.isSmartLinkifyEnabled() && request.isLegacyFallback()) {
            return TextClassifier.Utils.generateLegacyLinks(request);
        }
        String textString = request.getText().toString();
        TextLinks.Builder builder = new TextLinks.Builder(textString);
        try {
            TextClassifierImplNative.AnnotatedSpan[] annotations;
            long startTimeMs = System_Delegate.currentTimeMillis();
            ZonedDateTime refTime = ZonedDateTime.now();
            List<String> entitiesToIdentify = request.getEntityConfig() != null ? request.getEntityConfig().resolveEntityListModifications(this.getEntitiesForHints(request.getEntityConfig().getHints())) : this.mSettings.getEntityListDefault();
            TextClassifierImplNative nativeImpl = this.getNative(request.getDefaultLocales());
            for (TextClassifierImplNative.AnnotatedSpan span : annotations = nativeImpl.annotate(textString, new TextClassifierImplNative.AnnotationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), TextClassifierImpl.concatenateLocales(request.getDefaultLocales())))) {
                TextClassifierImplNative.ClassificationResult[] results = span.getClassification();
                if (results.length == 0 || !entitiesToIdentify.contains(results[0].getCollection())) continue;
                HashMap<String, Float> entityScores = new HashMap<String, Float>();
                for (int i = 0; i < results.length; ++i) {
                    entityScores.put(results[i].getCollection(), Float.valueOf(results[i].getScore()));
                }
                builder.addLink(span.getStartIndex(), span.getEndIndex(), entityScores);
            }
            TextLinks links = builder.build();
            long endTimeMs = System_Delegate.currentTimeMillis();
            String callingPackageName = request.getCallingPackageName() == null ? this.mContext.getPackageName() : request.getCallingPackageName();
            this.mGenerateLinksLogger.logGenerateLinks(request.getText(), links, callingPackageName, endTimeMs - startTimeMs);
            return links;
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting links info.", t);
            return this.mFallback.generateLinks(request);
        }
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return this.mSettings.getGenerateLinksMaxTextLength();
    }

    private Collection<String> getEntitiesForHints(Collection<String> hints) {
        boolean notEditable;
        boolean useDefault;
        boolean editable = hints.contains("android.text_is_editable");
        boolean bl = useDefault = editable == (notEditable = hints.contains("android.text_is_not_editable"));
        if (useDefault) {
            return this.mSettings.getEntityListDefault();
        }
        if (editable) {
            return this.mSettings.getEntityListEditable();
        }
        return this.mSettings.getEntityListNotEditable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelectionEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        Object object = this.mLoggerLock;
        synchronized (object) {
            if (this.mSessionLogger == null) {
                this.mSessionLogger = new SelectionSessionLogger();
            }
            this.mSessionLogger.writeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassifierImplNative getNative(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getEmptyLocaleList() : localeList;
            ModelFile bestModel = this.findBestModelLocked(localeList);
            if (bestModel == null) {
                throw new FileNotFoundException("No model for " + localeList.toLanguageTags());
            }
            if (this.mNative == null || !Objects.equals(this.mModel, bestModel)) {
                Log.d(LOG_TAG, "Loading " + bestModel);
                this.destroyNativeIfExistsLocked();
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                this.mNative = new TextClassifierImplNative(fd.getFd());
                TextClassifierImpl.closeAndLogError(fd);
                this.mModel = bestModel;
            }
            return this.mNative;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createId(String text, int start, int end) {
        Object object = this.mLock;
        synchronized (object) {
            return SelectionSessionLogger.createId(text, start, end, this.mContext, this.mModel.getVersion(), this.mModel.getSupportedLocales());
        }
    }

    @GuardedBy(value="mLock")
    private void destroyNativeIfExistsLocked() {
        if (this.mNative != null) {
            this.mNative.close();
            this.mNative = null;
        }
    }

    private static String concatenateLocales(LocaleList locales) {
        return locales == null ? "" : locales.toLanguageTags();
    }

    @GuardedBy(value="mLock")
    private ModelFile findBestModelLocked(LocaleList localeList) {
        String languages = localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags() + "," + LocaleList.getDefault().toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ModelFile bestModel = null;
        for (ModelFile model : this.listAllModelsLocked()) {
            if (!model.isAnyLanguageSupported(languageRangeList) || !model.isPreferredTo(bestModel)) continue;
            bestModel = model;
        }
        return bestModel;
    }

    @GuardedBy(value="mLock")
    private List<ModelFile> listAllModelsLocked() {
        if (this.mAllModelFiles == null) {
            File modelsDir;
            ModelFile updatedModel;
            ArrayList<ModelFile> allModels = new ArrayList<ModelFile>();
            if (new File(UPDATED_MODEL_FILE_PATH).exists() && (updatedModel = ModelFile.fromPath(UPDATED_MODEL_FILE_PATH)) != null) {
                allModels.add(updatedModel);
            }
            if ((modelsDir = new File(MODEL_DIR)).exists() && modelsDir.isDirectory()) {
                File[] modelFiles = modelsDir.listFiles();
                Pattern modelFilenamePattern = Pattern.compile(MODEL_FILE_REGEX);
                for (File modelFile : modelFiles) {
                    ModelFile model;
                    Matcher matcher = modelFilenamePattern.matcher(modelFile.getName());
                    if (!matcher.matches() || !modelFile.isFile() || (model = ModelFile.fromPath(modelFile.getAbsolutePath())) == null) continue;
                    allModels.add(model);
                }
            }
            this.mAllModelFiles = allModels;
        }
        return this.mAllModelFiles;
    }

    private TextClassification createClassificationResult(TextClassifierImplNative.ClassificationResult[] classifications, String text, int start, int end, Instant referenceTime) {
        String classifiedText = text.substring(start, end);
        TextClassification.Builder builder = new TextClassification.Builder().setText(classifiedText);
        int size = classifications.length;
        TextClassifierImplNative.ClassificationResult highestScoringResult = null;
        float highestScore = Float.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            builder.setEntityType(classifications[i].getCollection(), classifications[i].getScore());
            if (!(classifications[i].getScore() > highestScore)) continue;
            highestScoringResult = classifications[i];
            highestScore = classifications[i].getScore();
        }
        boolean isPrimaryAction = true;
        for (LabeledIntent labeledIntent : IntentFactory.create(this.mContext, referenceTime, highestScoringResult, classifiedText)) {
            RemoteAction action = labeledIntent.asRemoteAction(this.mContext);
            if (action == null) continue;
            if (isPrimaryAction) {
                builder.setIcon(action.getIcon().loadDrawable(this.mContext));
                builder.setLabel(action.getTitle().toString());
                builder.setIntent(labeledIntent.getIntent());
                builder.setOnClickListener(TextClassification.createIntentOnClickListener(TextClassification.createPendingIntent(this.mContext, labeledIntent.getIntent(), labeledIntent.getRequestCode())));
                isPrimaryAction = false;
            }
            builder.addAction(action);
        }
        return builder.setId(this.createId(text, start, end)).build();
    }

    private static void closeAndLogError(ParcelFileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Error closing file.", e);
        }
    }

    static class IntentFactory {
        private static final long MIN_EVENT_FUTURE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
        private static final long DEFAULT_EVENT_DURATION = TimeUnit.HOURS.toMillis(1L);

        private IntentFactory() {
        }

        public static List<LabeledIntent> create(Context context, Instant referenceTime, TextClassifierImplNative.ClassificationResult classification, String text) {
            String type = classification.getCollection().trim().toLowerCase(Locale.ENGLISH);
            text = text.trim();
            switch (type) {
                case "email": {
                    return IntentFactory.createForEmail(context, text);
                }
                case "phone": {
                    return IntentFactory.createForPhone(context, text);
                }
                case "address": {
                    return IntentFactory.createForAddress(context, text);
                }
                case "url": {
                    return IntentFactory.createForUrl(context, text);
                }
                case "date": 
                case "datetime": {
                    if (classification.getDatetimeResult() != null) {
                        Instant parsedTime = Instant.ofEpochMilli(classification.getDatetimeResult().getTimeMsUtc());
                        return IntentFactory.createForDatetime(context, type, referenceTime, parsedTime);
                    }
                    return new ArrayList<LabeledIntent>();
                }
                case "flight": {
                    return IntentFactory.createForFlight(context, text);
                }
            }
            return new ArrayList<LabeledIntent>();
        }

        private static List<LabeledIntent> createForEmail(Context context, String text) {
            return Arrays.asList(new LabeledIntent(context.getString(17039815), context.getString(17039821), new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text))), 0), new LabeledIntent(context.getString(17039451), context.getString(17039452), new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("email", text), text.hashCode()));
        }

        private static List<LabeledIntent> createForPhone(Context context, String text) {
            Bundle userRestrictions;
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            UserManager userManager = context.getSystemService(UserManager.class);
            Bundle bundle = userRestrictions = userManager != null ? userManager.getUserRestrictions() : new Bundle();
            if (!userRestrictions.getBoolean("no_outgoing_calls", false)) {
                actions.add(new LabeledIntent(context.getString(17039794), context.getString(17039795), new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text))), 0));
            }
            actions.add(new LabeledIntent(context.getString(17039451), context.getString(17039452), new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("phone", text), text.hashCode()));
            if (!userRestrictions.getBoolean("no_sms", false)) {
                actions.add(new LabeledIntent(context.getString(17040884), context.getString(17040889), new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("smsto:%s", text))), 0));
            }
            return actions;
        }

        private static List<LabeledIntent> createForAddress(Context context, String text) {
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            try {
                String encText = URLEncoder.encode(text, "UTF-8");
                actions.add(new LabeledIntent(context.getString(17040196), context.getString(17040197), new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", encText))), 0));
            }
            catch (UnsupportedEncodingException e) {
                Log.e(TextClassifierImpl.LOG_TAG, "Could not encode address", e);
            }
            return actions;
        }

        private static List<LabeledIntent> createForUrl(Context context, String text) {
            if (Uri.parse(text).getScheme() == null) {
                text = "http://" + text;
            }
            return Arrays.asList(new LabeledIntent(context.getString(17039582), context.getString(17039583), new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName()), 0));
        }

        private static List<LabeledIntent> createForDatetime(Context context, String type, Instant referenceTime, Instant parsedTime) {
            if (referenceTime == null) {
                referenceTime = Instant.now();
            }
            ArrayList<LabeledIntent> actions = new ArrayList<LabeledIntent>();
            actions.add(IntentFactory.createCalendarViewIntent(context, parsedTime));
            long millisUntilEvent = referenceTime.until(parsedTime, ChronoUnit.MILLIS);
            if (millisUntilEvent > MIN_EVENT_FUTURE_MILLIS) {
                actions.add(IntentFactory.createCalendarCreateEventIntent(context, parsedTime, type));
            }
            return actions;
        }

        private static List<LabeledIntent> createForFlight(Context context, String text) {
            return Arrays.asList(new LabeledIntent(context.getString(17041026), context.getString(17041027), new Intent("android.intent.action.WEB_SEARCH").putExtra("query", text), text.hashCode()));
        }

        private static LabeledIntent createCalendarViewIntent(Context context, Instant parsedTime) {
            Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
            builder.appendPath("time");
            ContentUris.appendId(builder, parsedTime.toEpochMilli());
            return new LabeledIntent(context.getString(17041024), context.getString(17041025), new Intent("android.intent.action.VIEW").setData(builder.build()), 0);
        }

        private static LabeledIntent createCalendarCreateEventIntent(Context context, Instant parsedTime, String type) {
            boolean isAllDay = "date".equals(type);
            return new LabeledIntent(context.getString(17039449), context.getString(17039450), new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("allDay", isAllDay).putExtra("beginTime", parsedTime.toEpochMilli()).putExtra("endTime", parsedTime.toEpochMilli() + DEFAULT_EVENT_DURATION), parsedTime.hashCode());
        }
    }

    private static class LabeledIntent {
        static final int DEFAULT_REQUEST_CODE = 0;
        private final String mTitle;
        private final String mDescription;
        private final Intent mIntent;
        private final int mRequestCode;

        LabeledIntent(String title, String description, Intent intent, int requestCode) {
            this.mTitle = title;
            this.mDescription = description;
            this.mIntent = intent;
            this.mRequestCode = requestCode;
        }

        String getTitle() {
            return this.mTitle;
        }

        String getDescription() {
            return this.mDescription;
        }

        Intent getIntent() {
            return this.mIntent;
        }

        int getRequestCode() {
            return this.mRequestCode;
        }

        RemoteAction asRemoteAction(Context context) {
            PendingIntent pendingIntent;
            PackageManager pm = context.getPackageManager();
            ResolveInfo resolveInfo = pm.resolveActivity(this.mIntent, 0);
            String packageName = resolveInfo != null && resolveInfo.activityInfo != null ? resolveInfo.activityInfo.packageName : null;
            Icon icon = null;
            boolean shouldShowIcon = false;
            if (packageName != null && !"android".equals(packageName)) {
                this.mIntent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                if (resolveInfo.activityInfo.getIconResource() != 0) {
                    icon = Icon.createWithResource(packageName, resolveInfo.activityInfo.getIconResource());
                    shouldShowIcon = true;
                }
            }
            if (icon == null) {
                icon = Icon.createWithResource("android", 17302684);
            }
            if ((pendingIntent = TextClassification.createPendingIntent(context, this.mIntent, this.mRequestCode)) == null) {
                return null;
            }
            RemoteAction action = new RemoteAction(icon, this.mTitle, this.mDescription, pendingIntent);
            action.setShouldShowIcon(shouldShowIcon);
            return action;
        }
    }

    private static class ModelFile {
        private final String mPath;
        private final String mName;
        private final int mVersion;
        private final List<Locale> mSupportedLocales;
        private final boolean mLanguageIndependent;

        static ModelFile fromPath(String path) {
            File file = new File(path);
            try {
                ParcelFileDescriptor modelFd = ParcelFileDescriptor.open(file, 0x10000000);
                int version = TextClassifierImplNative.getVersion(modelFd.getFd());
                String supportedLocalesStr = TextClassifierImplNative.getLocales(modelFd.getFd());
                if (supportedLocalesStr.isEmpty()) {
                    Log.d(TextClassifierImpl.LOG_TAG, "Ignoring " + file.getAbsolutePath());
                    return null;
                }
                boolean languageIndependent = supportedLocalesStr.equals("*");
                ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
                for (String langTag : supportedLocalesStr.split(",")) {
                    supportedLocales.add(AndroidLocale.forLanguageTag(langTag));
                }
                TextClassifierImpl.closeAndLogError(modelFd);
                return new ModelFile(path, file.getName(), version, supportedLocales, languageIndependent);
            }
            catch (FileNotFoundException e) {
                Log.e(TextClassifierImpl.LOG_TAG, "Failed to peek " + file.getAbsolutePath(), e);
                return null;
            }
        }

        String getPath() {
            return this.mPath;
        }

        String getName() {
            return this.mName;
        }

        int getVersion() {
            return this.mVersion;
        }

        boolean isAnyLanguageSupported(List<Locale.LanguageRange> languageRanges) {
            return this.mLanguageIndependent || Locale.lookup(languageRanges, this.mSupportedLocales) != null;
        }

        List<Locale> getSupportedLocales() {
            return Collections.unmodifiableList(this.mSupportedLocales);
        }

        public boolean isPreferredTo(ModelFile model) {
            if (model == null) {
                return true;
            }
            if (!this.mLanguageIndependent && model.mLanguageIndependent) {
                return true;
            }
            return this.getVersion() > model.getVersion();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !ModelFile.class.isAssignableFrom(other.getClass())) {
                return false;
            }
            ModelFile otherModel = (ModelFile)other;
            return this.mPath.equals(otherModel.mPath);
        }

        public String toString() {
            StringJoiner localesJoiner = new StringJoiner(",");
            for (Locale locale : this.mSupportedLocales) {
                localesJoiner.add(AndroidLocale.toLanguageTag(locale));
            }
            return String.format(Locale.US, "ModelFile { path=%s name=%s version=%d locales=%s }", this.mPath, this.mName, this.mVersion, localesJoiner.toString());
        }

        private ModelFile(String path, String name, int version, List<Locale> supportedLocales, boolean languageIndependent) {
            this.mPath = path;
            this.mName = name;
            this.mVersion = version;
            this.mSupportedLocales = supportedLocales;
            this.mLanguageIndependent = languageIndependent;
        }
    }
}

