/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinksParams;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class TextLinks
implements Parcelable {
    public static final int STATUS_LINKS_APPLIED = 0;
    public static final int STATUS_NO_LINKS_FOUND = 1;
    public static final int STATUS_NO_LINKS_APPLIED = 2;
    public static final int STATUS_DIFFERENT_TEXT = 3;
    public static final int APPLY_STRATEGY_IGNORE = 0;
    public static final int APPLY_STRATEGY_REPLACE = 1;
    private final String mFullText;
    private final List<TextLink> mLinks;
    public static final Parcelable.Creator<TextLinks> CREATOR = new Parcelable.Creator<TextLinks>(){

        @Override
        public TextLinks createFromParcel(Parcel in) {
            return new TextLinks(in);
        }

        public TextLinks[] newArray(int size) {
            return new TextLinks[size];
        }
    };

    private TextLinks(String fullText, ArrayList<TextLink> links) {
        this.mFullText = fullText;
        this.mLinks = Collections.unmodifiableList(links);
    }

    public String getText() {
        return this.mFullText;
    }

    public Collection<TextLink> getLinks() {
        return this.mLinks;
    }

    public int apply(Spannable text, int applyStrategy, Function<TextLink, TextLinkSpan> spanFactory) {
        Preconditions.checkNotNull(text);
        return new TextLinksParams.Builder().setApplyStrategy(applyStrategy).setSpanFactory(spanFactory).build().apply(text, this);
    }

    public String toString() {
        return String.format(Locale.US, "TextLinks{fullText=%s, links=%s}", this.mFullText, this.mLinks);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFullText);
        dest.writeTypedList(this.mLinks);
    }

    private TextLinks(Parcel in) {
        this.mFullText = in.readString();
        this.mLinks = in.createTypedArrayList(TextLink.CREATOR);
    }

    public static class Options {
        private final TextClassificationSessionId mSessionId;
        private final Request mRequest;
        private LocaleList mDefaultLocales;
        private TextClassifier.EntityConfig mEntityConfig;
        private boolean mLegacyFallback;
        private int mApplyStrategy;
        private Function<TextLink, TextLinkSpan> mSpanFactory;
        private String mCallingPackageName;

        public Options() {
            this(null, null);
        }

        private Options(TextClassificationSessionId sessionId, Request request) {
            this.mSessionId = sessionId;
            this.mRequest = request;
        }

        public static Options from(TextClassificationSessionId sessionId, Request request) {
            Options options = new Options(sessionId, request);
            options.setDefaultLocales(request.getDefaultLocales());
            options.setEntityConfig(request.getEntityConfig());
            return options;
        }

        public static Options fromLinkMask(int mask) {
            ArrayList<String> entitiesToFind = new ArrayList<String>();
            if ((mask & 1) != 0) {
                entitiesToFind.add("url");
            }
            if ((mask & 2) != 0) {
                entitiesToFind.add("email");
            }
            if ((mask & 4) != 0) {
                entitiesToFind.add("phone");
            }
            if ((mask & 8) != 0) {
                entitiesToFind.add("address");
            }
            return new Options().setEntityConfig(TextClassifier.EntityConfig.createWithEntityList(entitiesToFind));
        }

        public Options setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        public Options setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            this.mEntityConfig = entityConfig;
            return this;
        }

        public Options setApplyStrategy(int applyStrategy) {
            Options.checkValidApplyStrategy(applyStrategy);
            this.mApplyStrategy = applyStrategy;
            return this;
        }

        public Options setSpanFactory(Function<TextLink, TextLinkSpan> spanFactory) {
            this.mSpanFactory = spanFactory;
            return this;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return this.mEntityConfig;
        }

        public int getApplyStrategy() {
            return this.mApplyStrategy;
        }

        public Function<TextLink, TextLinkSpan> getSpanFactory() {
            return this.mSpanFactory;
        }

        public Request getRequest() {
            return this.mRequest;
        }

        public TextClassificationSessionId getSessionId() {
            return this.mSessionId;
        }

        private static void checkValidApplyStrategy(int applyStrategy) {
            if (applyStrategy != 0 && applyStrategy != 1) {
                throw new IllegalArgumentException("Invalid apply strategy. See TextLinks.ApplyStrategy for options.");
            }
        }
    }

    public static class Builder {
        private final String mFullText;
        private final ArrayList<TextLink> mLinks;

        public Builder(String fullText) {
            this.mFullText = Preconditions.checkNotNull(fullText);
            this.mLinks = new ArrayList();
        }

        public Builder addLink(int start, int end, Map<String, Float> entityScores) {
            this.mLinks.add(new TextLink(start, end, entityScores, null));
            return this;
        }

        Builder addLink(int start, int end, Map<String, Float> entityScores, URLSpan urlSpan) {
            this.mLinks.add(new TextLink(start, end, entityScores, urlSpan));
            return this;
        }

        public Builder clearTextLinks() {
            this.mLinks.clear();
            return this;
        }

        public TextLinks build() {
            return new TextLinks(this.mFullText, this.mLinks);
        }
    }

    public static class TextLinkSpan
    extends ClickableSpan {
        public static final int INVOCATION_METHOD_UNSPECIFIED = -1;
        public static final int INVOCATION_METHOD_TOUCH = 0;
        public static final int INVOCATION_METHOD_KEYBOARD = 1;
        private final TextLink mTextLink;

        public TextLinkSpan(TextLink textLink) {
            this.mTextLink = textLink;
        }

        @Override
        public void onClick(View widget) {
            this.onClick(widget, -1);
        }

        public void onClick(View widget, int invocationMethod) {
            if (widget instanceof TextView) {
                TextView textView = (TextView)widget;
                Context context = textView.getContext();
                if (TextClassificationManager.getSettings(context).isSmartLinkifyEnabled()) {
                    switch (invocationMethod) {
                        case 0: {
                            textView.requestActionMode(this);
                            break;
                        }
                        default: {
                            textView.handleClick(this);
                            break;
                        }
                    }
                } else if (this.mTextLink.mUrlSpan != null) {
                    this.mTextLink.mUrlSpan.onClick(textView);
                } else {
                    textView.handleClick(this);
                }
            }
        }

        public TextLink getTextLink() {
            return this.mTextLink;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        public String getUrl() {
            if (this.mTextLink.mUrlSpan != null) {
                return this.mTextLink.mUrlSpan.getURL();
            }
            return null;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InvocationMethod {
        }
    }

    public static class Request
    implements Parcelable {
        private final CharSequence mText;
        private final LocaleList mDefaultLocales;
        private final TextClassifier.EntityConfig mEntityConfig;
        private final boolean mLegacyFallback;
        private String mCallingPackageName;
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return new Request(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(CharSequence text, LocaleList defaultLocales, TextClassifier.EntityConfig entityConfig, boolean legacyFallback, String callingPackageName) {
            this.mText = text;
            this.mDefaultLocales = defaultLocales;
            this.mEntityConfig = entityConfig;
            this.mLegacyFallback = legacyFallback;
            this.mCallingPackageName = callingPackageName;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return this.mEntityConfig;
        }

        public boolean isLegacyFallback() {
            return this.mLegacyFallback;
        }

        void setCallingPackageName(String callingPackageName) {
            this.mCallingPackageName = callingPackageName;
        }

        public String getCallingPackageName() {
            return this.mCallingPackageName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mEntityConfig != null ? 1 : 0);
            if (this.mEntityConfig != null) {
                this.mEntityConfig.writeToParcel(dest, flags);
            }
            dest.writeString(this.mCallingPackageName);
        }

        private Request(Parcel in) {
            this.mText = in.readString();
            this.mDefaultLocales = in.readInt() == 0 ? null : LocaleList.CREATOR.createFromParcel(in);
            this.mEntityConfig = in.readInt() == 0 ? null : TextClassifier.EntityConfig.CREATOR.createFromParcel(in);
            this.mLegacyFallback = true;
            this.mCallingPackageName = in.readString();
        }

        public static class Builder {
            private final CharSequence mText;
            private LocaleList mDefaultLocales;
            private TextClassifier.EntityConfig mEntityConfig;
            private boolean mLegacyFallback = true;
            private String mCallingPackageName;

            public Builder(CharSequence text) {
                this.mText = Preconditions.checkNotNull(text);
            }

            public Builder setDefaultLocales(LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            public Builder setEntityConfig(TextClassifier.EntityConfig entityConfig) {
                this.mEntityConfig = entityConfig;
                return this;
            }

            public Builder setLegacyFallback(boolean legacyFallback) {
                this.mLegacyFallback = legacyFallback;
                return this;
            }

            public Builder setCallingPackageName(String callingPackageName) {
                this.mCallingPackageName = callingPackageName;
                return this;
            }

            public Request build() {
                return new Request(this.mText, this.mDefaultLocales, this.mEntityConfig, this.mLegacyFallback, this.mCallingPackageName);
            }
        }
    }

    public static class TextLink
    implements Parcelable {
        private final EntityConfidence mEntityScores;
        private final int mStart;
        private final int mEnd;
        final URLSpan mUrlSpan;
        public static final Parcelable.Creator<TextLink> CREATOR = new Parcelable.Creator<TextLink>(){

            @Override
            public TextLink createFromParcel(Parcel in) {
                return new TextLink(in);
            }

            public TextLink[] newArray(int size) {
                return new TextLink[size];
            }
        };

        TextLink(int start, int end, Map<String, Float> entityScores, URLSpan urlSpan) {
            Preconditions.checkNotNull(entityScores);
            Preconditions.checkArgument(!entityScores.isEmpty());
            Preconditions.checkArgument(start <= end);
            this.mStart = start;
            this.mEnd = end;
            this.mEntityScores = new EntityConfidence(entityScores);
            this.mUrlSpan = urlSpan;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getEntityCount() {
            return this.mEntityScores.getEntities().size();
        }

        public String getEntity(int index) {
            return this.mEntityScores.getEntities().get(index);
        }

        public float getConfidenceScore(String entityType) {
            return this.mEntityScores.getConfidenceScore(entityType);
        }

        public String toString() {
            return String.format(Locale.US, "TextLink{start=%s, end=%s, entityScores=%s, urlSpan=%s}", this.mStart, this.mEnd, this.mEntityScores, this.mUrlSpan);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mEntityScores.writeToParcel(dest, flags);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mEnd);
        }

        private TextLink(Parcel in) {
            this.mEntityScores = EntityConfidence.CREATOR.createFromParcel(in);
            this.mStart = in.readInt();
            this.mEnd = in.readInt();
            this.mUrlSpan = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

