/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.UserHandle;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppSecurityPermissions {
    public static final int WHICH_NEW = 4;
    public static final int WHICH_ALL = 65535;
    private static final String TAG = "AppSecurityPermissions";
    private static final boolean localLOGV = false;
    private final Context mContext;
    private final LayoutInflater mInflater;
    private final PackageManager mPm;
    private final Map<String, MyPermissionGroupInfo> mPermGroups = new HashMap<String, MyPermissionGroupInfo>();
    private final List<MyPermissionGroupInfo> mPermGroupsList = new ArrayList<MyPermissionGroupInfo>();
    private final PermissionGroupInfoComparator mPermGroupComparator = new PermissionGroupInfoComparator();
    private final PermissionInfoComparator mPermComparator = new PermissionInfoComparator();
    private final List<MyPermissionInfo> mPermsList = new ArrayList<MyPermissionInfo>();
    private final CharSequence mNewPermPrefix;
    private String mPackageName;

    private AppSecurityPermissions(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPm = this.mContext.getPackageManager();
        this.mNewPermPrefix = this.mContext.getText(17040669);
    }

    public AppSecurityPermissions(Context context, String packageName) {
        this(context);
        PackageInfo pkgInfo;
        this.mPackageName = packageName;
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Couldn't retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo.applicationInfo != null && pkgInfo.applicationInfo.uid != -1) {
            this.getAllUsedPermissions(pkgInfo.applicationInfo.uid, permSet);
        }
        this.mPermsList.addAll(permSet);
        this.setPermissions(this.mPermsList);
    }

    public AppSecurityPermissions(Context context, PackageInfo info) {
        this(context);
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        if (info == null) {
            return;
        }
        this.mPackageName = info.packageName;
        PackageInfo installedPkgInfo = null;
        if (info.requestedPermissions != null) {
            try {
                installedPkgInfo = this.mPm.getPackageInfo(info.packageName, 4096);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            this.extractPerms(info, permSet, installedPkgInfo);
        }
        if (info.sharedUserId != null) {
            try {
                int sharedUid = this.mPm.getUidForSharedUser(info.sharedUserId);
                this.getAllUsedPermissions(sharedUid, permSet);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "Couldn't retrieve shared user id for: " + info.packageName);
            }
        }
        this.mPermsList.addAll(permSet);
        this.setPermissions(this.mPermsList);
    }

    public static View getPermissionItemView(Context context, CharSequence grpName, CharSequence description, boolean dangerous) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Drawable icon = context.getDrawable(dangerous ? 17302287 : 17302764);
        return AppSecurityPermissions.getPermissionItemViewOld(context, inflater, grpName, description, dangerous, icon);
    }

    private void getAllUsedPermissions(int sharedUid, Set<MyPermissionInfo> permSet) {
        String[] sharedPkgList = this.mPm.getPackagesForUid(sharedUid);
        if (sharedPkgList == null || sharedPkgList.length == 0) {
            return;
        }
        for (String sharedPkg : sharedPkgList) {
            this.getPermissionsForPackage(sharedPkg, permSet);
        }
    }

    private void getPermissionsForPackage(String packageName, Set<MyPermissionInfo> permSet) {
        try {
            PackageInfo pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
            this.extractPerms(pkgInfo, permSet, pkgInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Couldn't retrieve permissions for package: " + packageName);
        }
    }

    private void extractPerms(PackageInfo info, Set<MyPermissionInfo> permSet, PackageInfo installedPkgInfo) {
        String[] strList = info.requestedPermissions;
        int[] flagsList = info.requestedPermissionsFlags;
        if (strList == null || strList.length == 0) {
            return;
        }
        for (int i = 0; i < strList.length; ++i) {
            String permName = strList[i];
            try {
                MyPermissionGroupInfo group;
                int existingFlags;
                PermissionInfo tmpPermInfo = this.mPm.getPermissionInfo(permName, 0);
                if (tmpPermInfo == null) continue;
                int existingIndex = -1;
                if (installedPkgInfo != null && installedPkgInfo.requestedPermissions != null) {
                    for (int j = 0; j < installedPkgInfo.requestedPermissions.length; ++j) {
                        if (!permName.equals(installedPkgInfo.requestedPermissions[j])) continue;
                        existingIndex = j;
                        break;
                    }
                }
                int n = existingFlags = existingIndex >= 0 ? installedPkgInfo.requestedPermissionsFlags[existingIndex] : 0;
                if (!this.isDisplayablePermission(tmpPermInfo, flagsList[i], existingFlags)) continue;
                String origGroupName = tmpPermInfo.group;
                String groupName = origGroupName;
                if (groupName == null) {
                    tmpPermInfo.group = groupName = tmpPermInfo.packageName;
                }
                if ((group = this.mPermGroups.get(groupName)) == null) {
                    PermissionGroupInfo grp = null;
                    if (origGroupName != null) {
                        grp = this.mPm.getPermissionGroupInfo(origGroupName, 0);
                    }
                    if (grp != null) {
                        group = new MyPermissionGroupInfo(grp);
                    } else {
                        tmpPermInfo.group = tmpPermInfo.packageName;
                        group = this.mPermGroups.get(tmpPermInfo.group);
                        if (group == null) {
                            group = new MyPermissionGroupInfo(tmpPermInfo);
                        }
                        group = new MyPermissionGroupInfo(tmpPermInfo);
                    }
                    this.mPermGroups.put(tmpPermInfo.group, group);
                }
                boolean newPerm = installedPkgInfo != null && (existingFlags & 2) == 0;
                MyPermissionInfo myPerm = new MyPermissionInfo(tmpPermInfo);
                myPerm.mNewReqFlags = flagsList[i];
                myPerm.mExistingReqFlags = existingFlags;
                myPerm.mNew = newPerm;
                permSet.add(myPerm);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i(TAG, "Ignoring unknown permission:" + permName);
            }
        }
    }

    public int getPermissionCount() {
        return this.getPermissionCount(65535);
    }

    private List<MyPermissionInfo> getPermissionList(MyPermissionGroupInfo grp, int which) {
        if (which == 4) {
            return grp.mNewPermissions;
        }
        return grp.mAllPermissions;
    }

    public int getPermissionCount(int which) {
        int N = 0;
        for (int i = 0; i < this.mPermGroupsList.size(); ++i) {
            N += this.getPermissionList(this.mPermGroupsList.get(i), which).size();
        }
        return N;
    }

    public View getPermissionsView() {
        return this.getPermissionsView(65535, false);
    }

    public View getPermissionsViewWithRevokeButtons() {
        return this.getPermissionsView(65535, true);
    }

    public View getPermissionsView(int which) {
        return this.getPermissionsView(which, false);
    }

    private View getPermissionsView(int which, boolean showRevokeUI) {
        LinearLayout permsView = (LinearLayout)this.mInflater.inflate(17367098, null);
        LinearLayout displayList = (LinearLayout)permsView.findViewById(16909173);
        Object noPermsView = permsView.findViewById(16909107);
        this.displayPermissions(this.mPermGroupsList, displayList, which, showRevokeUI);
        if (displayList.getChildCount() <= 0) {
            ((View)noPermsView).setVisibility(0);
        }
        return permsView;
    }

    private void displayPermissions(List<MyPermissionGroupInfo> groups, LinearLayout permListView, int which, boolean showRevokeUI) {
        permListView.removeAllViews();
        int spacing = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
        for (int i = 0; i < groups.size(); ++i) {
            MyPermissionGroupInfo grp = groups.get(i);
            List<MyPermissionInfo> perms = this.getPermissionList(grp, which);
            for (int j = 0; j < perms.size(); ++j) {
                MyPermissionInfo perm = perms.get(j);
                PermissionItemView view = this.getPermissionItemView(grp, perm, j == 0, which != 4 ? this.mNewPermPrefix : null, showRevokeUI);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                if (j == 0) {
                    lp.topMargin = spacing;
                }
                if (j == grp.mAllPermissions.size() - 1) {
                    lp.bottomMargin = spacing;
                }
                if (permListView.getChildCount() == 0) {
                    lp.topMargin *= 2;
                }
                permListView.addView((View)view, lp);
            }
        }
    }

    private PermissionItemView getPermissionItemView(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, boolean showRevokeUI) {
        return AppSecurityPermissions.getPermissionItemView(this.mContext, this.mInflater, grp, perm, first, newPermPrefix, this.mPackageName, showRevokeUI);
    }

    private static PermissionItemView getPermissionItemView(Context context, LayoutInflater inflater, MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, String packageName, boolean showRevokeUI) {
        PermissionItemView permView = (PermissionItemView)inflater.inflate((perm.flags & 1) != 0 ? 17367096 : 17367095, null);
        permView.setPermission(grp, perm, first, newPermPrefix, packageName, showRevokeUI);
        return permView;
    }

    private static View getPermissionItemViewOld(Context context, LayoutInflater inflater, CharSequence grpName, CharSequence permList, boolean dangerous, Drawable icon) {
        View permView = inflater.inflate(17367097, null);
        TextView permGrpView = (TextView)permView.findViewById(16909170);
        TextView permDescView = (TextView)permView.findViewById(16909172);
        ImageView imgView = (ImageView)permView.findViewById(16909166);
        imgView.setImageDrawable(icon);
        if (grpName != null) {
            permGrpView.setText(grpName);
            permDescView.setText(permList);
        } else {
            permGrpView.setText(permList);
            permDescView.setVisibility(8);
        }
        return permView;
    }

    private boolean isDisplayablePermission(PermissionInfo pInfo, int newReqFlags, int existingReqFlags) {
        boolean isGranted;
        boolean isNormal;
        int base = pInfo.protectionLevel & 0xF;
        boolean bl = isNormal = base == 0;
        if (isNormal) {
            return false;
        }
        boolean isDangerous = base == 1 || (pInfo.protectionLevel & 0x80) != 0;
        boolean isRequired = (newReqFlags & 1) != 0;
        boolean isDevelopment = (pInfo.protectionLevel & 0x20) != 0;
        boolean wasGranted = (existingReqFlags & 2) != 0;
        boolean bl2 = isGranted = (newReqFlags & 2) != 0;
        if (isDangerous && (isRequired || wasGranted || isGranted)) {
            return true;
        }
        return isDevelopment && wasGranted;
    }

    private void addPermToList(List<MyPermissionInfo> permList, MyPermissionInfo pInfo) {
        int idx;
        if (pInfo.mLabel == null) {
            pInfo.mLabel = pInfo.loadLabel(this.mPm);
        }
        if ((idx = Collections.binarySearch(permList, pInfo, this.mPermComparator)) < 0) {
            idx = -idx - 1;
            permList.add(idx, pInfo);
        }
    }

    private void setPermissions(List<MyPermissionInfo> permList) {
        if (permList != null) {
            for (MyPermissionInfo pInfo : permList) {
                MyPermissionGroupInfo group;
                if (!this.isDisplayablePermission(pInfo, pInfo.mNewReqFlags, pInfo.mExistingReqFlags) || (group = this.mPermGroups.get(pInfo.group)) == null) continue;
                pInfo.mLabel = pInfo.loadLabel(this.mPm);
                this.addPermToList(group.mAllPermissions, pInfo);
                if (!pInfo.mNew) continue;
                this.addPermToList(group.mNewPermissions, pInfo);
            }
        }
        for (MyPermissionGroupInfo pgrp : this.mPermGroups.values()) {
            if (pgrp.labelRes != 0 || pgrp.nonLocalizedLabel != null) {
                pgrp.mLabel = pgrp.loadLabel(this.mPm);
            } else {
                try {
                    ApplicationInfo app = this.mPm.getApplicationInfo(pgrp.packageName, 0);
                    pgrp.mLabel = app.loadLabel(this.mPm);
                }
                catch (PackageManager.NameNotFoundException e) {
                    pgrp.mLabel = pgrp.loadLabel(this.mPm);
                }
            }
            this.mPermGroupsList.add(pgrp);
        }
        Collections.sort(this.mPermGroupsList, this.mPermGroupComparator);
    }

    private static class PermissionInfoComparator
    implements Comparator<MyPermissionInfo> {
        private final Collator sCollator = Collator.getInstance();

        PermissionInfoComparator() {
        }

        @Override
        public int compare(MyPermissionInfo a, MyPermissionInfo b) {
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }
    }

    private static class PermissionGroupInfoComparator
    implements Comparator<MyPermissionGroupInfo> {
        private final Collator sCollator = Collator.getInstance();

        private PermissionGroupInfoComparator() {
        }

        @Override
        public int compare(MyPermissionGroupInfo a, MyPermissionGroupInfo b) {
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }
    }

    public static class PermissionItemView
    extends LinearLayout
    implements View.OnClickListener {
        MyPermissionGroupInfo mGroup;
        MyPermissionInfo mPerm;
        AlertDialog mDialog;
        private boolean mShowRevokeUI = false;
        private String mPackageName;

        public PermissionItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.setClickable(true);
        }

        public void setPermission(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, String packageName, boolean showRevokeUI) {
            this.mGroup = grp;
            this.mPerm = perm;
            this.mShowRevokeUI = showRevokeUI;
            this.mPackageName = packageName;
            ImageView permGrpIcon = (ImageView)this.findViewById(16909166);
            TextView permNameView = (TextView)this.findViewById(16909169);
            PackageManager pm = this.getContext().getPackageManager();
            Drawable icon = null;
            if (first) {
                icon = grp.loadGroupIcon(this.getContext(), pm);
            }
            CharSequence label = perm.mLabel;
            if (perm.mNew && newPermPrefix != null) {
                SpannableStringBuilder builder = new SpannableStringBuilder();
                Parcel parcel = Parcel.obtain();
                TextUtils.writeToParcel(newPermPrefix, parcel, 0);
                parcel.setDataPosition(0);
                CharSequence newStr = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                parcel.recycle();
                builder.append(newStr);
                builder.append(label);
                label = builder;
            }
            permGrpIcon.setImageDrawable(icon);
            permNameView.setText(label);
            this.setOnClickListener(this);
        }

        @Override
        public void onClick(View v) {
            if (this.mGroup != null && this.mPerm != null) {
                if (this.mDialog != null) {
                    this.mDialog.dismiss();
                }
                PackageManager pm = this.getContext().getPackageManager();
                AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
                builder.setTitle(this.mGroup.mLabel);
                if (this.mPerm.descriptionRes != 0) {
                    builder.setMessage(this.mPerm.loadDescription(pm));
                } else {
                    CharSequence appName;
                    try {
                        ApplicationInfo app = pm.getApplicationInfo(this.mPerm.packageName, 0);
                        appName = app.loadLabel(pm);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        appName = this.mPerm.packageName;
                    }
                    StringBuilder sbuilder = new StringBuilder(128);
                    sbuilder.append(this.getContext().getString(17040668, appName));
                    sbuilder.append("\n\n");
                    sbuilder.append(this.mPerm.name);
                    builder.setMessage(sbuilder.toString());
                }
                builder.setCancelable(true);
                builder.setIcon(this.mGroup.loadGroupIcon(this.getContext(), pm));
                this.addRevokeUIIfNecessary(builder);
                this.mDialog = builder.show();
                this.mDialog.setCanceledOnTouchOutside(true);
            }
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
        }

        private void addRevokeUIIfNecessary(AlertDialog.Builder builder) {
            boolean isRequired;
            if (!this.mShowRevokeUI) {
                return;
            }
            boolean bl = isRequired = (this.mPerm.mExistingReqFlags & 1) != 0;
            if (isRequired) {
                return;
            }
            DialogInterface.OnClickListener ocl = new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    PackageManager pm = this.getContext().getPackageManager();
                    pm.revokeRuntimePermission(mPackageName, mPerm.name, new UserHandle(mContext.getUserId()));
                    this.setVisibility(8);
                }
            };
            builder.setNegativeButton(17040778, ocl);
            builder.setPositiveButton(17039370, null);
        }
    }

    private static class MyPermissionInfo
    extends PermissionInfo {
        CharSequence mLabel;
        int mNewReqFlags;
        int mExistingReqFlags;
        boolean mNew;

        MyPermissionInfo(PermissionInfo info) {
            super(info);
        }
    }

    static class MyPermissionGroupInfo
    extends PermissionGroupInfo {
        CharSequence mLabel;
        final ArrayList<MyPermissionInfo> mNewPermissions = new ArrayList();
        final ArrayList<MyPermissionInfo> mAllPermissions = new ArrayList();

        MyPermissionGroupInfo(PermissionInfo perm) {
            this.name = perm.packageName;
            this.packageName = perm.packageName;
        }

        MyPermissionGroupInfo(PermissionGroupInfo info) {
            super(info);
        }

        public Drawable loadGroupIcon(Context context, PackageManager pm) {
            if (this.icon != 0) {
                return this.loadUnbadgedIcon(pm);
            }
            return context.getDrawable(17302692);
        }
    }
}

