/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DialerKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;

@Deprecated
public class DialerFilter
extends RelativeLayout {
    public static final int DIGITS_AND_LETTERS = 1;
    public static final int DIGITS_AND_LETTERS_NO_DIGITS = 2;
    public static final int DIGITS_AND_LETTERS_NO_LETTERS = 3;
    public static final int DIGITS_ONLY = 4;
    public static final int LETTERS_ONLY = 5;
    EditText mLetters;
    EditText mDigits;
    EditText mPrimary;
    EditText mHint;
    InputFilter[] mInputFilters;
    ImageView mIcon;
    int mMode;
    private boolean mIsQwerty;

    public DialerFilter(Context context) {
        super(context);
    }

    public DialerFilter(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mInputFilters = new InputFilter[]{new InputFilter.AllCaps()};
        this.mHint = (EditText)this.findViewById(16908293);
        if (this.mHint == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named hint");
        }
        this.mHint.setFilters(this.mInputFilters);
        this.mLetters = this.mHint;
        this.mLetters.setKeyListener(TextKeyListener.getInstance());
        this.mLetters.setMovementMethod(null);
        this.mLetters.setFocusable(false);
        this.mPrimary = (EditText)this.findViewById(16908300);
        if (this.mPrimary == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named primary");
        }
        this.mPrimary.setFilters(this.mInputFilters);
        this.mDigits = this.mPrimary;
        this.mDigits.setKeyListener(DialerKeyListener.getInstance());
        this.mDigits.setMovementMethod(null);
        this.mDigits.setFocusable(false);
        this.mIcon = (ImageView)this.findViewById(16908294);
        this.setFocusable(true);
        this.mIsQwerty = true;
        this.setMode(1);
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.mIcon != null) {
            this.mIcon.setVisibility(focused ? 0 : 8);
        }
    }

    public boolean isQwertyKeyboard() {
        return this.mIsQwerty;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean handled = false;
        block0 : switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: {
                break;
            }
            case 67: {
                switch (this.mMode) {
                    case 1: {
                        handled = this.mDigits.onKeyDown(keyCode, event);
                        handled &= this.mLetters.onKeyDown(keyCode, event);
                        break;
                    }
                    case 2: {
                        handled = this.mLetters.onKeyDown(keyCode, event);
                        if (this.mLetters.getText().length() != this.mDigits.getText().length()) break;
                        this.setMode(1);
                        break;
                    }
                    case 3: {
                        if (this.mDigits.getText().length() == this.mLetters.getText().length()) {
                            this.mLetters.onKeyDown(keyCode, event);
                            this.setMode(1);
                        }
                        handled = this.mDigits.onKeyDown(keyCode, event);
                        break;
                    }
                    case 4: {
                        handled = this.mDigits.onKeyDown(keyCode, event);
                        break;
                    }
                    case 5: {
                        handled = this.mLetters.onKeyDown(keyCode, event);
                    }
                }
                break;
            }
            default: {
                switch (this.mMode) {
                    case 1: {
                        handled = this.mLetters.onKeyDown(keyCode, event);
                        if (KeyEvent.isModifierKey(keyCode)) {
                            this.mDigits.onKeyDown(keyCode, event);
                            handled = true;
                            break block0;
                        }
                        boolean isPrint = event.isPrintingKey();
                        if (!isPrint && keyCode != 62 && keyCode != 61) break block0;
                        char c = event.getMatch(DialerKeyListener.CHARACTERS);
                        if (c != '\u0000') {
                            handled &= this.mDigits.onKeyDown(keyCode, event);
                            break block0;
                        }
                        this.setMode(2);
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        handled = this.mDigits.onKeyDown(keyCode, event);
                        break block0;
                    }
                    case 2: 
                    case 5: {
                        handled = this.mLetters.onKeyDown(keyCode, event);
                    }
                }
            }
        }
        if (!handled) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean a = this.mLetters.onKeyUp(keyCode, event);
        boolean b = this.mDigits.onKeyUp(keyCode, event);
        return a || b;
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int newMode) {
        switch (newMode) {
            case 1: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(0);
                break;
            }
            case 4: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(8);
                this.mDigits.setVisibility(0);
                break;
            }
            case 5: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(8);
                break;
            }
            case 3: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(4);
                this.mDigits.setVisibility(0);
                break;
            }
            case 2: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(4);
            }
        }
        int oldMode = this.mMode;
        this.mMode = newMode;
        this.onModeChange(oldMode, newMode);
    }

    private void makeLettersPrimary() {
        if (this.mPrimary == this.mDigits) {
            this.swapPrimaryAndHint(true);
        }
    }

    private void makeDigitsPrimary() {
        if (this.mPrimary == this.mLetters) {
            this.swapPrimaryAndHint(false);
        }
    }

    private void swapPrimaryAndHint(boolean makeLettersPrimary) {
        Editable lettersText = this.mLetters.getText();
        Editable digitsText = this.mDigits.getText();
        KeyListener lettersInput = this.mLetters.getKeyListener();
        KeyListener digitsInput = this.mDigits.getKeyListener();
        if (makeLettersPrimary) {
            this.mLetters = this.mPrimary;
            this.mDigits = this.mHint;
        } else {
            this.mLetters = this.mHint;
            this.mDigits = this.mPrimary;
        }
        this.mLetters.setKeyListener(lettersInput);
        this.mLetters.setText(lettersText);
        lettersText = this.mLetters.getText();
        Selection.setSelection(lettersText, lettersText.length());
        this.mDigits.setKeyListener(digitsInput);
        this.mDigits.setText(digitsText);
        digitsText = this.mDigits.getText();
        Selection.setSelection(digitsText, digitsText.length());
        this.mPrimary.setFilters(this.mInputFilters);
        this.mHint.setFilters(this.mInputFilters);
    }

    public CharSequence getLetters() {
        if (this.mLetters.getVisibility() == 0) {
            return this.mLetters.getText();
        }
        return "";
    }

    public CharSequence getDigits() {
        if (this.mDigits.getVisibility() == 0) {
            return this.mDigits.getText();
        }
        return "";
    }

    public CharSequence getFilterText() {
        if (this.mMode != 4) {
            return this.getLetters();
        }
        return this.getDigits();
    }

    public void append(String text) {
        switch (this.mMode) {
            case 1: {
                this.mDigits.getText().append(text);
                this.mLetters.getText().append(text);
                break;
            }
            case 3: 
            case 4: {
                this.mDigits.getText().append(text);
                break;
            }
            case 2: 
            case 5: {
                this.mLetters.getText().append(text);
            }
        }
    }

    public void clearText() {
        Editable text = this.mLetters.getText();
        text.clear();
        text = this.mDigits.getText();
        text.clear();
        if (this.mIsQwerty) {
            this.setMode(1);
        } else {
            this.setMode(4);
        }
    }

    public void setLettersWatcher(TextWatcher watcher) {
        Editable text = this.mLetters.getText();
        Spannable span = text;
        span.setSpan(watcher, 0, text.length(), 18);
    }

    public void setDigitsWatcher(TextWatcher watcher) {
        Editable text = this.mDigits.getText();
        Spannable span = text;
        span.setSpan(watcher, 0, text.length(), 18);
    }

    public void setFilterWatcher(TextWatcher watcher) {
        if (this.mMode != 4) {
            this.setLettersWatcher(watcher);
        } else {
            this.setDigitsWatcher(watcher);
        }
    }

    public void removeFilterWatcher(TextWatcher watcher) {
        Editable text = this.mMode != 4 ? this.mLetters.getText() : this.mDigits.getText();
        text.removeSpan(watcher);
    }

    protected void onModeChange(int oldMode, int newMode) {
    }
}

