/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.LinearLayout;
import android.widget.ZoomButton;

public class ZoomControls
extends LinearLayout {
    private final ZoomButton mZoomIn;
    private final ZoomButton mZoomOut;

    public ZoomControls(Context context) {
        this(context, null);
    }

    public ZoomControls(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setFocusable(false);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(17367334, (ViewGroup)this, true);
        this.mZoomIn = (ZoomButton)this.findViewById(16909520);
        this.mZoomOut = (ZoomButton)this.findViewById(16909522);
    }

    public void setOnZoomInClickListener(View.OnClickListener listener) {
        this.mZoomIn.setOnClickListener(listener);
    }

    public void setOnZoomOutClickListener(View.OnClickListener listener) {
        this.mZoomOut.setOnClickListener(listener);
    }

    public void setZoomSpeed(long speed) {
        this.mZoomIn.setZoomSpeed(speed);
        this.mZoomOut.setZoomSpeed(speed);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public void show() {
        this.fade(0, 0.0f, 1.0f);
    }

    public void hide() {
        this.fade(8, 1.0f, 0.0f);
    }

    private void fade(int visibility, float startAlpha, float endAlpha) {
        AlphaAnimation anim2 = new AlphaAnimation(startAlpha, endAlpha);
        anim2.setDuration(500L);
        this.startAnimation(anim2);
        this.setVisibility(visibility);
    }

    public void setIsZoomInEnabled(boolean isEnabled) {
        this.mZoomIn.setEnabled(isEnabled);
    }

    public void setIsZoomOutEnabled(boolean isEnabled) {
        this.mZoomOut.setEnabled(isEnabled);
    }

    @Override
    public boolean hasFocus() {
        return this.mZoomIn.hasFocus() || this.mZoomOut.hasFocus();
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ZoomControls.class.getName();
    }
}

