/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.ml.clustering;

import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class KMeans {
    private static final boolean DEBUG = false;
    private static final String TAG = "KMeans";
    private final Random mRandomState;
    private final int mMaxIterations;
    private float mSqConvergenceEpsilon;

    public KMeans() {
        this(new Random());
    }

    public KMeans(Random random) {
        this(random, 30, 0.005f);
    }

    public KMeans(Random random, int maxIterations, float convergenceEpsilon) {
        this.mRandomState = random;
        this.mMaxIterations = maxIterations;
        this.mSqConvergenceEpsilon = convergenceEpsilon * convergenceEpsilon;
    }

    public List<Mean> predict(int k, float[][] inputData) {
        this.checkDataSetSanity(inputData);
        int dimension = inputData[0].length;
        ArrayList<Mean> means = new ArrayList<Mean>();
        for (int i = 0; i < k; ++i) {
            Mean m = new Mean(dimension);
            for (int j = 0; j < dimension; ++j) {
                m.mCentroid[j] = this.mRandomState.nextFloat();
            }
            means.add(m);
        }
        boolean converged = false;
        for (int i = 0; i < this.mMaxIterations && !(converged = this.step(means, inputData)); ++i) {
        }
        if (!converged) {
            // empty if block
        }
        return means;
    }

    public static double score(List<Mean> means) {
        double score = 0.0;
        int meansSize = means.size();
        for (int i = 0; i < meansSize; ++i) {
            Mean mean = means.get(i);
            for (int j = 0; j < meansSize; ++j) {
                Mean compareTo = means.get(j);
                if (mean == compareTo) continue;
                double distance = Math.sqrt(KMeans.sqDistance(mean.mCentroid, compareTo.mCentroid));
                score += distance;
            }
        }
        return score;
    }

    @VisibleForTesting
    public void checkDataSetSanity(float[][] inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException("Data set is null.");
        }
        if (inputData.length == 0) {
            throw new IllegalArgumentException("Data set is empty.");
        }
        if (inputData[0] == null) {
            throw new IllegalArgumentException("Bad data set format.");
        }
        int dimension = inputData[0].length;
        int length = inputData.length;
        for (int i = 1; i < length; ++i) {
            if (inputData[i] != null && inputData[i].length == dimension) continue;
            throw new IllegalArgumentException("Bad data set format.");
        }
    }

    private boolean step(ArrayList<Mean> means, float[][] inputData) {
        int i;
        for (i = means.size() - 1; i >= 0; --i) {
            Mean mean = means.get(i);
            mean.mClosestItems.clear();
        }
        for (i = inputData.length - 1; i >= 0; --i) {
            float[] current = inputData[i];
            Mean nearest = KMeans.nearestMean(current, means);
            nearest.mClosestItems.add(current);
        }
        boolean converged = true;
        for (int i2 = means.size() - 1; i2 >= 0; --i2) {
            int j;
            Mean mean = means.get(i2);
            if (mean.mClosestItems.size() == 0) continue;
            float[] oldCentroid = mean.mCentroid;
            mean.mCentroid = new float[oldCentroid.length];
            for (j = 0; j < mean.mClosestItems.size(); ++j) {
                for (int p = 0; p < mean.mCentroid.length; ++p) {
                    int n = p;
                    mean.mCentroid[n] = mean.mCentroid[n] + mean.mClosestItems.get(j)[p];
                }
            }
            j = 0;
            while (j < mean.mCentroid.length) {
                int n = j++;
                mean.mCentroid[n] = mean.mCentroid[n] / (float)mean.mClosestItems.size();
            }
            if (!(KMeans.sqDistance(oldCentroid, mean.mCentroid) > this.mSqConvergenceEpsilon)) continue;
            converged = false;
        }
        return converged;
    }

    @VisibleForTesting
    public static Mean nearestMean(float[] point, List<Mean> means) {
        Mean nearest = null;
        float nearestDistance = Float.MAX_VALUE;
        int meanCount = means.size();
        for (int i = 0; i < meanCount; ++i) {
            Mean next = means.get(i);
            float nextDistance = KMeans.sqDistance(point, next.mCentroid);
            if (!(nextDistance < nearestDistance)) continue;
            nearest = next;
            nearestDistance = nextDistance;
        }
        return nearest;
    }

    @VisibleForTesting
    public static float sqDistance(float[] a, float[] b) {
        float dist = 0.0f;
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            dist += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return dist;
    }

    public static class Mean {
        float[] mCentroid;
        final ArrayList<float[]> mClosestItems = new ArrayList();

        public Mean(int dimension) {
            this.mCentroid = new float[dimension];
        }

        public Mean(float ... centroid) {
            this.mCentroid = centroid;
        }

        public float[] getCentroid() {
            return this.mCentroid;
        }

        public List<float[]> getItems() {
            return this.mClosestItems;
        }

        public String toString() {
            return "Mean(centroid: " + Arrays.toString(this.mCentroid) + ", size: " + this.mClosestItems.size() + ")";
        }
    }
}

