/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuProcReader;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;

public class KernelUidCpuClusterTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    private static final String TAG = KernelUidCpuClusterTimeReader.class.getSimpleName();
    private final KernelCpuProcReader mProcReader;
    private SparseArray<double[]> mLastUidPolicyTimeMs = new SparseArray();
    private int mNumClusters = -1;
    private int mNumCores;
    private int[] mNumCoresOnCluster;
    private double[] mCurTime;
    private long[] mDeltaTime;
    private long[] mCurTimeRounded;

    public KernelUidCpuClusterTimeReader() {
        this.mProcReader = KernelCpuProcReader.getClusterTimeReaderInstance();
    }

    @VisibleForTesting
    public KernelUidCpuClusterTimeReader(KernelCpuProcReader procReader) {
        this.mProcReader = procReader;
    }

    @Override
    protected void readDeltaImpl(Callback cb) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double[] lastTimes = this.mLastUidPolicyTimeMs.get(uid);
            if (lastTimes == null) {
                lastTimes = new double[this.mNumClusters];
                this.mLastUidPolicyTimeMs.put(uid, lastTimes);
            }
            if (!this.sumClusterTime((IntBuffer)buf, this.mCurTime)) {
                return;
            }
            boolean valid = true;
            boolean notify = false;
            for (int i = 0; i < this.mNumClusters; ++i) {
                this.mDeltaTime[i] = (long)(this.mCurTime[i] - lastTimes[i]);
                if (this.mDeltaTime[i] < 0L) {
                    Slog.e(TAG, "Negative delta from cluster time proc: " + this.mDeltaTime[i]);
                    valid = false;
                }
                notify |= this.mDeltaTime[i] > 0L;
            }
            if (notify && valid) {
                System.arraycopy(this.mCurTime, 0, lastTimes, 0, this.mNumClusters);
                if (cb != null) {
                    cb.onUidCpuPolicyTime(uid, this.mDeltaTime);
                }
            }
        });
    }

    public void readAbsolute(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            if (this.sumClusterTime((IntBuffer)buf, this.mCurTime)) {
                for (int i = 0; i < this.mNumClusters; ++i) {
                    this.mCurTimeRounded[i] = (long)this.mCurTime[i];
                }
                callback.onUidCpuPolicyTime(uid, this.mCurTimeRounded);
            }
        });
    }

    private boolean sumClusterTime(IntBuffer buffer, double[] clusterTime) {
        boolean valid = true;
        for (int i = 0; i < this.mNumClusters; ++i) {
            clusterTime[i] = 0.0;
            for (int j = 1; j <= this.mNumCoresOnCluster[i]; ++j) {
                int time = buffer.get();
                if (time < 0) {
                    Slog.e(TAG, "Negative time from cluster time proc: " + time);
                    valid = false;
                }
                int n = i;
                clusterTime[n] = clusterTime[n] + (double)time * 10.0 / (double)j;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Consumer<IntBuffer> processUid) {
        KernelCpuProcReader kernelCpuProcReader = this.mProcReader;
        synchronized (kernelCpuProcReader) {
            ByteBuffer bytes = this.mProcReader.readBytes();
            if (bytes == null || bytes.remaining() <= 4) {
                return;
            }
            if ((bytes.remaining() & 3) != 0) {
                Slog.wtf(TAG, "Cannot parse cluster time proc bytes to int: " + bytes.remaining());
                return;
            }
            IntBuffer buf = bytes.asIntBuffer();
            int numClusters = buf.get();
            if (numClusters <= 0) {
                Slog.wtf(TAG, "Cluster time format error: " + numClusters);
                return;
            }
            if (this.mNumClusters == -1) {
                this.mNumClusters = numClusters;
            }
            if (buf.remaining() < numClusters) {
                Slog.wtf(TAG, "Too few data left in the buffer: " + buf.remaining());
                return;
            }
            if (this.mNumCores <= 0) {
                if (!this.readCoreInfo(buf, numClusters)) {
                    return;
                }
            } else {
                buf.position(buf.position() + numClusters);
            }
            if (buf.remaining() % (this.mNumCores + 1) != 0) {
                Slog.wtf(TAG, "Cluster time format error: " + buf.remaining() + " / " + (this.mNumCores + 1));
                return;
            }
            int numUids = buf.remaining() / (this.mNumCores + 1);
            for (int i = 0; i < numUids; ++i) {
                processUid.accept(buf);
            }
        }
    }

    private boolean readCoreInfo(IntBuffer buf, int numClusters) {
        int numCores = 0;
        int[] numCoresOnCluster = new int[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            numCoresOnCluster[i] = buf.get();
            numCores += numCoresOnCluster[i];
        }
        if (numCores <= 0) {
            Slog.e(TAG, "Invalid # cores from cluster time proc file: " + numCores);
            return false;
        }
        this.mNumCores = numCores;
        this.mNumCoresOnCluster = numCoresOnCluster;
        this.mCurTime = new double[numClusters];
        this.mDeltaTime = new long[numClusters];
        this.mCurTimeRounded = new long[numClusters];
        return true;
    }

    public void removeUid(int uid) {
        this.mLastUidPolicyTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        this.mLastUidPolicyTimeMs.put(startUid, null);
        this.mLastUidPolicyTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidPolicyTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidPolicyTimeMs.indexOfKey(endUid);
        this.mLastUidPolicyTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback {
        public void onUidCpuPolicyTime(int var1, long[] var2);
    }
}

