/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.app.SystemServiceRegistry_Accessor;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.BridgeAssetManager;
import android.content.res.BridgeTypedArray;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.Resources_Delegate;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.BridgeInflater;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.textservice.TextServicesManager;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContentResolver;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgePackageManager;
import com.android.layoutlib.bridge.android.BridgePowerManager;
import com.android.layoutlib.bridge.android.BridgeSharedPreferences;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.android.UnresolvedResourceValue;
import com.android.layoutlib.bridge.android.XmlPullParserResolver;
import com.android.layoutlib.bridge.android.view.WindowManagerImpl;
import com.android.layoutlib.bridge.impl.Stack;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import com.android.util.PropertiesMap;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class BridgeContext
extends Context {
    private static final String PREFIX_THEME_APPCOMPAT = "Theme.AppCompat";
    private static final Map<String, ResourceValue> FRAMEWORK_PATCHED_VALUES = new HashMap<String, ResourceValue>(2);
    private static final Map<String, ResourceValue> FRAMEWORK_REPLACE_VALUES = new HashMap<String, ResourceValue>(3);
    private final HashMap<View, Object> mViewKeyMap = new HashMap();
    private final HashMap<Object, Object> mViewKeyHelpMap = new HashMap();
    private final BridgeAssetManager mAssets;
    private Resources mSystemResources;
    private final Object mProjectKey;
    private final DisplayMetrics mMetrics;
    private final RenderResources mRenderResources;
    private final Configuration mConfig;
    private final ApplicationInfo mApplicationInfo;
    private final LayoutlibCallback mLayoutlibCallback;
    private final WindowManager mWindowManager;
    private final DisplayManager mDisplayManager;
    private final HashMap<View, Integer> mScrollYPos = new HashMap();
    private final HashMap<View, Integer> mScrollXPos = new HashMap();
    private Resources.Theme mTheme;
    private final Map<Object, PropertiesMap> mDefaultPropMaps = new IdentityHashMap<Object, PropertiesMap>();
    private TypedArrayCache mTypedArrayCache;
    private BridgeInflater mBridgeInflater;
    private BridgeContentResolver mContentResolver;
    private final Stack<BridgeXmlBlockParser> mParserStack = new Stack();
    private SharedPreferences mSharedPreferences;
    private ClassLoader mClassLoader;
    private IBinder mBinder;
    private PackageManager mPackageManager;
    private Boolean mIsThemeAppCompat;
    private final ResourceNamespace mAppCompatNamespace;
    private static Map<String, String> RTL_ATTRS;

    public BridgeContext(Object projectKey, DisplayMetrics metrics, RenderResources renderResources, AssetRepository assets, LayoutlibCallback layoutlibCallback, Configuration config, int targetSdkVersion, boolean hasRtlSupport) {
        this.mProjectKey = projectKey;
        this.mMetrics = metrics;
        this.mLayoutlibCallback = layoutlibCallback;
        this.mRenderResources = renderResources;
        this.mConfig = config;
        AssetManager systemAssetManager = AssetManager.getSystem();
        if (!(systemAssetManager instanceof BridgeAssetManager)) {
            throw new AssertionError((Object)"Creating BridgeContext without initializing Bridge");
        }
        this.mAssets = (BridgeAssetManager)systemAssetManager;
        this.mAssets.setAssetRepository(assets);
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.targetSdkVersion = targetSdkVersion;
        if (hasRtlSupport) {
            this.mApplicationInfo.flags |= 0x400000;
        }
        this.mWindowManager = new WindowManagerImpl(this.mMetrics);
        this.mDisplayManager = new DisplayManager(this);
        this.mAppCompatNamespace = this.mLayoutlibCallback.isResourceNamespacingRequired() ? (this.mLayoutlibCallback.hasAndroidXAppCompat() ? ResourceNamespace.APPCOMPAT : ResourceNamespace.APPCOMPAT_LEGACY) : ResourceNamespace.RES_AUTO;
    }

    public void initResources() {
        AssetManager assetManager = AssetManager.getSystem();
        this.mSystemResources = Resources_Delegate.initSystem(this, assetManager, this.mMetrics, this.mConfig, this.mLayoutlibCallback);
        this.mTheme = this.mSystemResources.newTheme();
    }

    public void disposeResources() {
        Resources_Delegate.disposeSystem();
    }

    public void setBridgeInflater(BridgeInflater inflater) {
        this.mBridgeInflater = inflater;
    }

    public void addViewKey(View view, Object viewKey) {
        this.mViewKeyMap.put(view, viewKey);
    }

    public Object getViewKey(View view) {
        return this.mViewKeyMap.get(view);
    }

    public void addCookie(Object o, Object cookie) {
        this.mViewKeyHelpMap.put(o, cookie);
    }

    public Object getCookie(Object o) {
        return this.mViewKeyHelpMap.get(o);
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public DisplayMetrics getMetrics() {
        return this.mMetrics;
    }

    public LayoutlibCallback getLayoutlibCallback() {
        return this.mLayoutlibCallback;
    }

    public RenderResources getRenderResources() {
        return this.mRenderResources;
    }

    public Map<Object, PropertiesMap> getDefaultProperties() {
        return this.mDefaultPropMaps;
    }

    public Configuration getConfiguration() {
        return this.mConfig;
    }

    public void pushParser(BridgeXmlBlockParser parser) {
        this.mParserStack.push(parser);
    }

    public void popParser() {
        BridgeXmlBlockParser parser = this.mParserStack.pop();
    }

    private BridgeXmlBlockParser getCurrentParser() {
        return this.mParserStack.peek();
    }

    public BridgeXmlBlockParser getPreviousParser() {
        if (this.mParserStack.size() < 2) {
            return null;
        }
        return (BridgeXmlBlockParser)this.mParserStack.get(this.mParserStack.size() - 2);
    }

    public boolean resolveThemeAttribute(int resId, TypedValue outValue, boolean resolveRefs) {
        int a;
        ResourceReference resourceInfo = Bridge.resolveResourceId(resId);
        if (resourceInfo == null) {
            resourceInfo = this.mLayoutlibCallback.resolveResourceId(resId);
        }
        if (resourceInfo == null || resourceInfo.getResourceType() != ResourceType.ATTR) {
            return false;
        }
        ResourceValue value = this.mRenderResources.findItemInTheme(resourceInfo);
        if (resolveRefs) {
            value = this.mRenderResources.resolveResValue(value);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof StyleResourceValue) {
            outValue.resourceId = this.getDynamicIdByStyle((StyleResourceValue)value);
            return true;
        }
        String stringValue = value.getValue();
        if (!stringValue.isEmpty()) {
            if (stringValue.charAt(0) == '#') {
                outValue.type = 28;
                outValue.data = Color.parseColor(value.getValue());
            } else if (stringValue.charAt(0) == '@') {
                outValue.type = 1;
            }
        }
        if ((a = value.isFramework() ? this.getFrameworkResourceId(value.getResourceType(), value.getName(), 0) : this.getProjectResourceId(value.asReference(), 0)) != 0) {
            outValue.resourceId = a;
            return true;
        }
        outValue.string = stringValue;
        return true;
    }

    public ResourceReference resolveId(int id2) {
        ResourceReference resourceInfo = Bridge.resolveResourceId(id2);
        if (resourceInfo != null) {
            return resourceInfo;
        }
        if (this.mLayoutlibCallback != null && (resourceInfo = this.mLayoutlibCallback.resolveResourceId(id2)) != null) {
            return resourceInfo;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public Pair<View, Boolean> inflateView(ResourceReference layout, ViewGroup parent, boolean attachToRoot, boolean skipCallbackParser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAppCompatTheme() {
        if (this.mIsThemeAppCompat != null) {
            return this.mIsThemeAppCompat;
        }
        StyleResourceValue defaultTheme = this.mRenderResources.getDefaultTheme();
        boolean isThemeAppCompat = false;
        for (int i = 0; i < 50 && defaultTheme != null; ++i) {
            if (defaultTheme.getName().startsWith(PREFIX_THEME_APPCOMPAT)) {
                isThemeAppCompat = true;
                break;
            }
            defaultTheme = this.mRenderResources.getParent(defaultTheme);
        }
        this.mIsThemeAppCompat = isThemeAppCompat;
        return isThemeAppCompat;
    }

    @Override
    public Resources getResources() {
        return this.mSystemResources;
    }

    @Override
    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mClassLoader == null) {
            this.mClassLoader = new ClassLoader(this.getClass().getClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    for (String prefix : BridgeInflater.getClassPrefixList()) {
                        if (!name.startsWith(prefix)) continue;
                        throw new ClassNotFoundException(name + " not found");
                    }
                    return BridgeContext.this.mLayoutlibCallback.findClass(name);
                }
            };
        }
        return this.mClassLoader;
    }

    @Override
    public Object getSystemService(String service) {
        switch (service) {
            case "layout_inflater": {
                return this.mBridgeInflater;
            }
            case "textservices": {
                return TextServicesManager.getInstance();
            }
            case "window": {
                return this.mWindowManager;
            }
            case "power": {
                return new PowerManager(this, new BridgePowerManager(), new Handler());
            }
            case "display": {
                return this.mDisplayManager;
            }
            case "accessibility": {
                return AccessibilityManager.getInstance(this);
            }
            case "input_method": 
            case "autofill": 
            case "audio": 
            case "textclassification": {
                return null;
            }
        }
        assert (false) : "Unsupported Service: " + service;
        return null;
    }

    @Override
    public String getSystemServiceName(Class<?> serviceClass) {
        return SystemServiceRegistry_Accessor.getSystemServiceName(serviceClass);
    }

    public final BridgeTypedArray internalObtainStyledAttributes(int resId, int[] attrs) throws Resources.NotFoundException {
        List currentThemes;
        Pair<BridgeTypedArray, PropertiesMap> typeArrayAndPropertiesPair;
        StyleResourceValue style2 = null;
        if (resId != 0) {
            ResourceReference ref;
            style2 = this.getStyleByDynamicId(resId);
            if (style2 == null && (ref = this.resolveId(resId)) != null) {
                style2 = this.mRenderResources.getStyle(ref);
            }
            if (style2 == null) {
                Bridge.getLog().error("resources.resolve", "Failed to find style with " + resId, null);
                return null;
            }
        }
        if (this.mTypedArrayCache == null) {
            this.mTypedArrayCache = new TypedArrayCache();
        }
        if ((typeArrayAndPropertiesPair = this.mTypedArrayCache.get(attrs, currentThemes = this.mRenderResources.getAllThemes(), resId)) == null) {
            typeArrayAndPropertiesPair = this.createStyleBasedTypedArray(style2, attrs);
            this.mTypedArrayCache.put(attrs, currentThemes, resId, typeArrayAndPropertiesPair);
        }
        if (typeArrayAndPropertiesPair.getSecond() != null) {
            Object key;
            BridgeXmlBlockParser parser = this.getCurrentParser();
            Object object = key = parser != null ? parser.getViewCookie() : null;
            if (key != null) {
                PropertiesMap defaultPropMap = this.mDefaultPropMaps.get(key);
                if (defaultPropMap == null) {
                    defaultPropMap = (PropertiesMap)typeArrayAndPropertiesPair.getSecond();
                    this.mDefaultPropMaps.put(key, defaultPropMap);
                } else {
                    defaultPropMap.putAll((Map)typeArrayAndPropertiesPair.getSecond());
                }
            }
        }
        return (BridgeTypedArray)typeArrayAndPropertiesPair.getFirst();
    }

    public BridgeTypedArray internalObtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        ResourceValue resolved;
        String customStyle;
        ResourceNamespace.Resolver resolver;
        ResourceNamespace currentFileNamespace;
        PropertiesMap defaultPropMap = null;
        if (set instanceof BridgeXmlBlockParser) {
            BridgeXmlBlockParser parser = (BridgeXmlBlockParser)set;
            Object key = parser.getViewCookie();
            if (key != null) {
                defaultPropMap = this.mDefaultPropMaps.computeIfAbsent(key, k -> new PropertiesMap());
            }
            currentFileNamespace = parser.getFileResourceNamespace();
            resolver = new XmlPullParserResolver(parser, this.mLayoutlibCallback.getImplicitNamespaces());
        } else if (set instanceof BridgeLayoutParamsMapAttributes) {
            currentFileNamespace = ResourceNamespace.RES_AUTO;
            resolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        } else {
            if (set != null) {
                Bridge.getLog().error("broken", "Parser is not a BridgeXmlBlockParser!", null);
                return null;
            }
            currentFileNamespace = ResourceNamespace.RES_AUTO;
            resolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        }
        List<AttributeHolder> attributeList = this.searchAttrs(attrs);
        BridgeTypedArray ta = Resources_Delegate.newTypeArray(this.mSystemResources, attrs.length);
        StyleResourceValue customStyleValues = null;
        if (set != null && (customStyle = set.getAttributeValue(null, "style")) != null && (resolved = this.mRenderResources.resolveResValue((ResourceValue)new UnresolvedResourceValue(customStyle, currentFileNamespace, resolver))) instanceof StyleResourceValue) {
            customStyleValues = (StyleResourceValue)resolved;
        }
        StyleResourceValue defStyleValues = null;
        if (defStyleAttr != 0) {
            ResourceReference defStyleAttribute = this.searchAttr(defStyleAttr);
            if (defStyleAttribute == null) {
                Bridge.getLog().error("resources.resolve", "Failed to find the style corresponding to the id " + defStyleAttr, null);
            } else {
                ResourceValue item = this.mRenderResources.findItemInTheme(defStyleAttribute);
                if (item != null) {
                    if ((item = this.mRenderResources.resolveResValue(item)) instanceof StyleResourceValue) {
                        defStyleValues = (StyleResourceValue)item;
                    }
                    if (defaultPropMap != null) {
                        defaultPropMap.put((Object)"style", (Object)new PropertiesMap.Property(defStyleAttribute.getResourceUrl().getQualifiedName(), item.getValue()));
                    }
                }
            }
        }
        if (defStyleValues == null && defStyleRes != 0) {
            StyleResourceValue item = this.getStyleByDynamicId(defStyleRes);
            if (item != null) {
                defStyleValues = item;
            } else {
                ResourceReference value = Bridge.resolveResourceId(defStyleRes);
                if (value == null) {
                    value = this.mLayoutlibCallback.resolveResourceId(defStyleRes);
                }
                if (value != null) {
                    if (value.getResourceType() == ResourceType.STYLE) {
                        item = this.mRenderResources.getStyle(value);
                        if (item != null) {
                            if (defaultPropMap != null) {
                                String name = item.getName();
                                defaultPropMap.put((Object)"style", (Object)new PropertiesMap.Property(name, name));
                            }
                            defStyleValues = item;
                        } else {
                            Bridge.getLog().error(null, String.format("Style with id 0x%x (resolved to '%s') does not exist.", defStyleRes, value.getName()), null);
                        }
                    } else {
                        Bridge.getLog().error(null, String.format("Resource id 0x%x is not of type STYLE (instead %s)", defStyleRes, value.getResourceType().name()), null);
                    }
                } else {
                    Bridge.getLog().error(null, String.format("Failed to find style with id 0x%x in current theme", defStyleRes), null);
                }
            }
        }
        if (attributeList != null) {
            for (int index = 0; index < attributeList.size(); ++index) {
                AttributeHolder attributeHolder = attributeList.get(index);
                if (attributeHolder == null) continue;
                String attrName = attributeHolder.getName();
                String value = null;
                if (set != null) {
                    value = set.getAttributeValue(attributeHolder.getNamespace().getXmlNamespaceUri(), attrName);
                    if (attributeHolder.getNamespace() != ResourceNamespace.ANDROID && value == null) {
                        value = set.getAttributeValue("http://schemas.android.com/apk/res-auto", attrName);
                    }
                }
                ResourceValue defaultValue = null;
                if (defaultPropMap != null || value == null) {
                    ResourceReference attrRef = attributeHolder.asReference();
                    if (customStyleValues != null) {
                        defaultValue = this.mRenderResources.findItemInStyle(customStyleValues, attrRef);
                    }
                    if (defaultValue == null && defStyleValues != null) {
                        defaultValue = this.mRenderResources.findItemInStyle(defStyleValues, attrRef);
                    }
                    if (defaultValue == null) {
                        defaultValue = this.mRenderResources.findItemInTheme(attrRef);
                    }
                    if (defaultValue != null) {
                        String preResolve = defaultValue.getValue();
                        defaultValue = this.mRenderResources.resolveResValue(defaultValue);
                        if (defaultPropMap != null) {
                            defaultPropMap.put((Object)attrRef.getResourceUrl().getQualifiedName(), (Object)new PropertiesMap.Property(preResolve, defaultValue.getValue()));
                        }
                    }
                }
                if (value == null) {
                    String val;
                    ResourceValue patchedValue;
                    if (attributeHolder.getNamespace() == ResourceNamespace.ANDROID && (patchedValue = FRAMEWORK_PATCHED_VALUES.get(attrName)) != null) {
                        defaultValue = patchedValue;
                    }
                    if (defaultValue != null && (val = defaultValue.getValue()) != null && val.startsWith("?") && (defaultValue = FRAMEWORK_REPLACE_VALUES.get(attrName)) == null && (this.getApplicationInfo().targetSdkVersion < 17 || !attrName.equals(RTL_ATTRS.get(val)))) {
                        Bridge.getLog().warning("resources.resolve.theme", String.format("Failed to find '%s' in current theme.", val), (Object)val);
                    }
                    ta.bridgeSetValue(index, attrName, attributeHolder.getNamespace(), attributeHolder.getResourceId(), defaultValue);
                    continue;
                }
                ta.bridgeSetValue(index, attrName, attributeHolder.getNamespace(), attributeHolder.getResourceId(), this.mRenderResources.resolveResValue((ResourceValue)new UnresolvedResourceValue(value, currentFileNamespace, resolver)));
            }
        }
        ta.sealArray();
        return ta;
    }

    @Override
    public Looper getMainLooper() {
        return Looper.myLooper();
    }

    @Override
    public String getPackageName() {
        if (this.mApplicationInfo.packageName == null) {
            this.mApplicationInfo.packageName = (String)this.mLayoutlibCallback.getFlag(RenderParamsFlags.FLAG_KEY_APPLICATION_PACKAGE);
        }
        return this.mApplicationInfo.packageName;
    }

    @Override
    public PackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            this.mPackageManager = new BridgePackageManager();
        }
        return this.mPackageManager;
    }

    private Pair<BridgeTypedArray, PropertiesMap> createStyleBasedTypedArray(StyleResourceValue style2, int[] attrs) throws Resources.NotFoundException {
        List<AttributeHolder> attributes = this.searchAttrs(attrs);
        BridgeTypedArray ta = Resources_Delegate.newTypeArray(this.mSystemResources, attrs.length);
        PropertiesMap defaultPropMap = new PropertiesMap();
        for (int i = 0; i < attrs.length; ++i) {
            ResourceValue resValue;
            AttributeHolder attrHolder = attributes.get(i);
            if (attrHolder == null || (resValue = style2 != null ? this.mRenderResources.findItemInStyle(style2, attrHolder.asReference()) : this.mRenderResources.findItemInTheme(attrHolder.asReference())) == null) continue;
            String preResolve = resValue.getValue();
            resValue = this.mRenderResources.resolveResValue(resValue);
            ta.bridgeSetValue(i, attrHolder.getName(), attrHolder.getNamespace(), attrHolder.getResourceId(), resValue);
            defaultPropMap.put((Object)attrHolder.asReference().getResourceUrl().getQualifiedName(), (Object)new PropertiesMap.Property(preResolve, resValue.getValue()));
        }
        ta.sealArray();
        return Pair.of((Object)ta, (Object)defaultPropMap);
    }

    private List<AttributeHolder> searchAttrs(int[] attributeIds) {
        ArrayList<AttributeHolder> results = new ArrayList<AttributeHolder>(attributeIds.length);
        for (int id2 : attributeIds) {
            ResourceReference refForId = Bridge.resolveResourceId(id2);
            if (refForId == null) {
                refForId = this.mLayoutlibCallback.resolveResourceId(id2);
            }
            if (refForId != null) {
                results.add(new AttributeHolder(id2, refForId));
                continue;
            }
            results.add(null);
        }
        return results;
    }

    private ResourceReference searchAttr(int attrId) {
        ResourceReference attr2 = Bridge.resolveResourceId(attrId);
        if (attr2 == null) {
            attr2 = this.mLayoutlibCallback.resolveResourceId(attrId);
        }
        return attr2;
    }

    public int getDynamicIdByStyle(StyleResourceValue resValue) {
        if (resValue.isFramework()) {
            return Bridge.getResourceId(resValue.getResourceType(), resValue.getName());
        }
        return this.mLayoutlibCallback.getOrGenerateResourceId(resValue.asReference());
    }

    private StyleResourceValue getStyleByDynamicId(int id2) {
        ResourceReference reference = Bridge.resolveResourceId(id2);
        if (reference == null) {
            reference = this.mLayoutlibCallback.resolveResourceId(id2);
        }
        if (reference == null) {
            return null;
        }
        return this.mRenderResources.getStyle(reference);
    }

    public int getFrameworkResourceId(ResourceType resType, String resName, int defValue) {
        ResourceReference reference = new ResourceReference(ResourceNamespace.ANDROID, resType, resName);
        if (this.getRenderResources().getUnresolvedResource(reference) != null) {
            return Bridge.getResourceId(resType, resName);
        }
        return defValue;
    }

    public int getProjectResourceId(ResourceReference resource, int defValue) {
        if (this.getRenderResources().getUnresolvedResource(resource) != null && this.mLayoutlibCallback != null) {
            return this.mLayoutlibCallback.getOrGenerateResourceId(resource);
        }
        return defValue;
    }

    public static Context getBaseContext(Context context) {
        while (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public static ResourceReference createFrameworkAttrReference(String name) {
        return BridgeContext.createFrameworkResourceReference(ResourceType.ATTR, name);
    }

    public static ResourceReference createFrameworkResourceReference(ResourceType type, String name) {
        return new ResourceReference(ResourceNamespace.ANDROID, type, name);
    }

    public ResourceReference createAppCompatAttrReference(String name) {
        return this.createAppCompatResourceReference(ResourceType.ATTR, name);
    }

    public ResourceReference createAppCompatResourceReference(ResourceType type, String name) {
        return new ResourceReference(this.mAppCompatNamespace, type, name);
    }

    public IBinder getBinder() {
        if (this.mBinder == null) {
            this.mBinder = new IBinder(){

                @Override
                public String getInterfaceDescriptor() throws RemoteException {
                    return null;
                }

                @Override
                public boolean pingBinder() {
                    return false;
                }

                @Override
                public boolean isBinderAlive() {
                    return false;
                }

                @Override
                public IInterface queryLocalInterface(String descriptor) {
                    return null;
                }

                @Override
                public void dump(FileDescriptor fd, String[] args) throws RemoteException {
                }

                @Override
                public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
                }

                @Override
                public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                    return false;
                }

                @Override
                public void linkToDeath(IBinder.DeathRecipient recipient, int flags) throws RemoteException {
                }

                @Override
                public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
                    return false;
                }

                @Override
                public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback shellCallback, ResultReceiver resultReceiver) {
                }
            };
        }
        return this.mBinder;
    }

    @Override
    public boolean bindService(Intent arg0, ServiceConnection arg1, int arg2) {
        return false;
    }

    @Override
    public int checkCallingOrSelfPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkCallingPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkPermission(String arg0, int arg1, int arg2) {
        return 0;
    }

    @Override
    public int checkSelfPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkPermission(String arg0, int arg1, int arg2, IBinder arg3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3, IBinder arg4) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5) {
        return 0;
    }

    @Override
    public void clearWallpaper() {
    }

    @Override
    public Context createPackageContext(String arg0, int arg1) {
        return null;
    }

    @Override
    public Context createPackageContextAsUser(String arg0, int arg1, UserHandle user) {
        return null;
    }

    @Override
    public Context createConfigurationContext(Configuration overrideConfiguration) {
        return null;
    }

    @Override
    public Context createDisplayContext(Display display) {
        return null;
    }

    @Override
    public Context createContextForSplit(String splitName) {
        return null;
    }

    @Override
    public String[] databaseList() {
        return null;
    }

    @Override
    public Context createApplicationContext(ApplicationInfo application, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Override
    public boolean moveDatabaseFrom(Context sourceContext, String name) {
        return false;
    }

    @Override
    public boolean deleteDatabase(String arg0) {
        return false;
    }

    @Override
    public boolean deleteFile(String arg0) {
        return false;
    }

    @Override
    public void enforceCallingOrSelfPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforceCallingPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforcePermission(String arg0, int arg1, int arg2, String arg3) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, int arg1, int arg2, int arg3, String arg4) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5, String arg6) {
    }

    @Override
    public String[] fileList() {
        return null;
    }

    @Override
    public BridgeAssetManager getAssets() {
        return this.mAssets;
    }

    @Override
    public File getCacheDir() {
        return null;
    }

    @Override
    public File getCodeCacheDir() {
        return null;
    }

    @Override
    public File getExternalCacheDir() {
        return null;
    }

    @Override
    public File getPreloadsFileCache() {
        return null;
    }

    @Override
    public ContentResolver getContentResolver() {
        if (this.mContentResolver == null) {
            this.mContentResolver = new BridgeContentResolver(this);
        }
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String arg0) {
        return null;
    }

    @Override
    public File getDir(String arg0, int arg1) {
        return null;
    }

    @Override
    public File getFileStreamPath(String arg0) {
        return null;
    }

    @Override
    public File getSharedPreferencesPath(String name) {
        return null;
    }

    @Override
    public File getDataDir() {
        return null;
    }

    @Override
    public File getFilesDir() {
        return null;
    }

    @Override
    public File getNoBackupFilesDir() {
        return null;
    }

    @Override
    public File getExternalFilesDir(String type) {
        return null;
    }

    @Override
    public String getPackageCodePath() {
        return null;
    }

    @Override
    public String getBasePackageName() {
        return null;
    }

    @Override
    public String getOpPackageName() {
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    @Override
    public String getPackageResourcePath() {
        return null;
    }

    @Override
    public SharedPreferences getSharedPreferences(String arg0, int arg1) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = new BridgeSharedPreferences();
        }
        return this.mSharedPreferences;
    }

    @Override
    public SharedPreferences getSharedPreferences(File arg0, int arg1) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = new BridgeSharedPreferences();
        }
        return this.mSharedPreferences;
    }

    @Override
    public void reloadSharedPreferences() {
    }

    @Override
    public boolean moveSharedPreferencesFrom(Context sourceContext, String name) {
        return false;
    }

    @Override
    public boolean deleteSharedPreferences(String name) {
        return false;
    }

    @Override
    public Drawable getWallpaper() {
        return null;
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return -1;
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return -1;
    }

    @Override
    public void grantUriPermission(String arg0, Uri arg1, int arg2) {
    }

    @Override
    public FileInputStream openFileInput(String arg0) throws FileNotFoundException {
        return null;
    }

    @Override
    public FileOutputStream openFileOutput(String arg0, int arg1) throws FileNotFoundException {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, SQLiteDatabase.CursorFactory arg2) {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, SQLiteDatabase.CursorFactory arg2, DatabaseErrorHandler arg3) {
        return null;
    }

    @Override
    public Drawable peekWallpaper() {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, int arg2) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2, Handler arg3) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2, Handler arg3, int arg4) {
        return null;
    }

    @Override
    public Intent registerReceiverAsUser(BroadcastReceiver arg0, UserHandle arg0p5, IntentFilter arg1, String arg2, Handler arg3) {
        return null;
    }

    @Override
    public void removeStickyBroadcast(Intent arg0) {
    }

    @Override
    public void revokeUriPermission(Uri arg0, int arg1) {
    }

    @Override
    public void revokeUriPermission(String arg0, Uri arg1, int arg2) {
    }

    @Override
    public void sendBroadcast(Intent arg0) {
    }

    @Override
    public void sendBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendBroadcastMultiplePermissions(Intent intent, String[] receiverPermissions) {
    }

    @Override
    public void sendBroadcastAsUserMultiplePermissions(Intent intent, UserHandle user, String[] receiverPermissions) {
    }

    @Override
    public void sendBroadcast(Intent arg0, String arg1, Bundle arg2) {
    }

    @Override
    public void sendBroadcast(Intent intent, String receiverPermission, int appOp) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1, BroadcastReceiver arg2, Handler arg3, int arg4, String arg5, Bundle arg6) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1, Bundle arg7, BroadcastReceiver arg2, Handler arg3, int arg4, String arg5, Bundle arg6) {
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, Bundle options) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendStickyBroadcast(Intent arg0) {
    }

    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user, Bundle options) {
    }

    @Override
    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void setTheme(int arg0) {
    }

    @Override
    public void setWallpaper(Bitmap arg0) throws IOException {
    }

    @Override
    public void setWallpaper(InputStream arg0) throws IOException {
    }

    @Override
    public void startActivity(Intent arg0) {
    }

    @Override
    public void startActivity(Intent arg0, Bundle arg1) {
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
    }

    @Override
    public boolean startInstrumentation(ComponentName arg0, String arg1, Bundle arg2) {
        return false;
    }

    @Override
    public ComponentName startService(Intent arg0) {
        return null;
    }

    @Override
    public ComponentName startForegroundService(Intent service) {
        return null;
    }

    @Override
    public ComponentName startForegroundServiceAsUser(Intent service, UserHandle user) {
        return null;
    }

    @Override
    public boolean stopService(Intent arg0) {
        return false;
    }

    @Override
    public ComponentName startServiceAsUser(Intent arg0, UserHandle arg1) {
        return null;
    }

    @Override
    public boolean stopServiceAsUser(Intent arg0, UserHandle arg1) {
        return false;
    }

    @Override
    public void unbindService(ServiceConnection arg0) {
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver arg0) {
    }

    @Override
    public Context getApplicationContext() {
        return this;
    }

    @Override
    public void startActivities(Intent[] arg0) {
    }

    @Override
    public void startActivities(Intent[] arg0, Bundle arg1) {
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public File getObbDir() {
        Bridge.getLog().error("unsupported", "OBB not supported", null);
        return null;
    }

    @Override
    public DisplayAdjustments getDisplayAdjustments(int displayId) {
        return null;
    }

    @Override
    public Display getDisplay() {
        return null;
    }

    @Override
    public void updateDisplay(int displayId) {
    }

    @Override
    public int getUserId() {
        return 0;
    }

    @Override
    public File[] getExternalFilesDirs(String type) {
        return new File[0];
    }

    @Override
    public File[] getObbDirs() {
        return new File[0];
    }

    @Override
    public File[] getExternalCacheDirs() {
        return new File[0];
    }

    @Override
    public File[] getExternalMediaDirs() {
        return new File[0];
    }

    public void setScrollYPos(View view, int scrollPos) {
        this.mScrollYPos.put(view, scrollPos);
    }

    public int getScrollYPos(View view) {
        Integer pos = this.mScrollYPos.get(view);
        return pos != null ? pos : 0;
    }

    public void setScrollXPos(View view, int scrollPos) {
        this.mScrollXPos.put(view, scrollPos);
    }

    public int getScrollXPos(View view) {
        Integer pos = this.mScrollXPos.get(view);
        return pos != null ? pos : 0;
    }

    @Override
    public Context createDeviceProtectedStorageContext() {
        return null;
    }

    @Override
    public Context createCredentialProtectedStorageContext() {
        return null;
    }

    @Override
    public boolean isDeviceProtectedStorage() {
        return false;
    }

    @Override
    public boolean isCredentialProtectedStorage() {
        return false;
    }

    @Override
    public boolean canLoadUnsafeResources() {
        return true;
    }

    static {
        FRAMEWORK_PATCHED_VALUES.put("animateFirstView", (ResourceValue)new ResourceValueImpl(ResourceNamespace.ANDROID, ResourceType.BOOL, "animateFirstView", "false"));
        FRAMEWORK_PATCHED_VALUES.put("animateLayoutChanges", (ResourceValue)new ResourceValueImpl(ResourceNamespace.ANDROID, ResourceType.BOOL, "animateLayoutChanges", "false"));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionItemLayout", (ResourceValue)new ResourceValueImpl(ResourceNamespace.ANDROID, ResourceType.LAYOUT, "textEditSuggestionItemLayout", "text_edit_suggestion_item"));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionContainerLayout", (ResourceValue)new ResourceValueImpl(ResourceNamespace.ANDROID, ResourceType.LAYOUT, "textEditSuggestionContainerLayout", "text_edit_suggestion_container"));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionHighlightStyle", (ResourceValue)new ResourceValueImpl(ResourceNamespace.ANDROID, ResourceType.STYLE, "textEditSuggestionHighlightStyle", "TextAppearance.Holo.SuggestionHighlight"));
        RTL_ATTRS = new HashMap<String, String>(10);
        RTL_ATTRS.put("?android:attr/paddingLeft", "paddingStart");
        RTL_ATTRS.put("?android:attr/paddingRight", "paddingEnd");
        RTL_ATTRS.put("?android:attr/layout_marginLeft", "layout_marginStart");
        RTL_ATTRS.put("?android:attr/layout_marginRight", "layout_marginEnd");
        RTL_ATTRS.put("?android:attr/layout_toLeftOf", "layout_toStartOf");
        RTL_ATTRS.put("?android:attr/layout_toRightOf", "layout_toEndOf");
        RTL_ATTRS.put("?android:attr/layout_alignParentLeft", "layout_alignParentStart");
        RTL_ATTRS.put("?android:attr/layout_alignParentRight", "layout_alignParentEnd");
        RTL_ATTRS.put("?android:attr/drawableLeft", "drawableStart");
        RTL_ATTRS.put("?android:attr/drawableRight", "drawableEnd");
    }

    private static class TypedArrayCache {
        private Map<int[], Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>>> mCache = new IdentityHashMap<int[], Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>>>();

        private TypedArrayCache() {
        }

        public Pair<BridgeTypedArray, PropertiesMap> get(int[] attrs, List<StyleResourceValue> themes, int resId) {
            Map<Integer, Pair<BridgeTypedArray, PropertiesMap>> cacheFromResId;
            Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>> cacheFromThemes = this.mCache.get(attrs);
            if (cacheFromThemes != null && (cacheFromResId = cacheFromThemes.get(themes)) != null) {
                return cacheFromResId.get(resId);
            }
            return null;
        }

        public void put(int[] attrs, List<StyleResourceValue> themes, int resId, Pair<BridgeTypedArray, PropertiesMap> value) {
            Map cacheFromThemes = this.mCache.computeIfAbsent(attrs, k -> new HashMap());
            Map cacheFromResId = cacheFromThemes.computeIfAbsent(themes, k -> new HashMap());
            cacheFromResId.put(resId, value);
        }
    }

    private class AttributeHolder {
        private final int resourceId;
        private final ResourceReference reference;

        private AttributeHolder(int resourceId, ResourceReference reference) {
            this.resourceId = resourceId;
            this.reference = reference;
        }

        private ResourceReference asReference() {
            return this.reference;
        }

        private int getResourceId() {
            return this.resourceId;
        }

        private String getName() {
            return this.reference.getName();
        }

        private ResourceNamespace getNamespace() {
            return this.reference.getNamespace();
        }
    }
}

