/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AppCompatActionBar
extends BridgeActionBar {
    private Object mWindowDecorActionBar;
    private static final String[] WINDOW_ACTION_BAR_CLASS_NAMES = new String[]{"android.support.v7.internal.app.WindowDecorActionBar", "android.support.v7.app.WindowDecorActionBar", "androidx.appcompat.app.WindowDecorActionBar"};
    private Class<?> mWindowActionBarClass;

    public AppCompatActionBar(BridgeContext context, SessionParams params) {
        super(context, params);
        int contentRootId = context.getProjectResourceId(new ResourceReference(ResourceNamespace.TODO(), ResourceType.ID, "action_bar_activity_content"), 0);
        Object contentView = this.getDecorContent().findViewById(contentRootId);
        if (contentView != null) {
            assert (contentView instanceof FrameLayout);
            this.setContentRoot((FrameLayout)contentView);
        } else {
            FrameLayout contentRoot = new FrameLayout(context);
            AppCompatActionBar.setMatchParent(contentRoot);
            if (this.mEnclosingLayout != null) {
                this.mEnclosingLayout.addView(contentRoot);
            }
            this.setContentRoot(contentRoot);
        }
        try {
            Class[] constructorParams = new Class[]{View.class};
            Object[] constructorArgs = new Object[]{this.getDecorContent()};
            LayoutlibCallback callback = params.getLayoutlibCallback();
            String actionBarClass = null;
            for (int i = WINDOW_ACTION_BAR_CLASS_NAMES.length - 1; i >= 0; --i) {
                actionBarClass = WINDOW_ACTION_BAR_CLASS_NAMES[i];
                try {
                    callback.findClass(actionBarClass);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
            this.mWindowDecorActionBar = callback.loadView(actionBarClass, constructorParams, constructorArgs);
            this.mWindowActionBarClass = this.mWindowDecorActionBar == null ? null : this.mWindowDecorActionBar.getClass();
            this.inflateMenus();
            this.setupActionBar();
        }
        catch (Exception e) {
            Bridge.getLog().warning("broken", "Failed to load AppCompat ActionBar with unknown error.", (Object)e);
        }
    }

    @Override
    protected ResourceValue getLayoutResource(BridgeContext context) {
        return context.getRenderResources().getResolvedResource(context.createAppCompatResourceReference(ResourceType.LAYOUT, "abc_screen_toolbar"));
    }

    @Override
    protected LayoutInflater getInflater(BridgeContext context) {
        int styleId;
        Context themedContext = context;
        RenderResources resources = context.getRenderResources();
        ResourceValue actionBarTheme = resources.findItemInTheme(context.createAppCompatAttrReference("actionBarTheme"));
        if (actionBarTheme != null) {
            actionBarTheme = resources.resolveResValue(actionBarTheme);
        }
        if (actionBarTheme instanceof StyleResourceValue && (styleId = context.getDynamicIdByStyle((StyleResourceValue)actionBarTheme)) != 0) {
            themedContext = new ContextThemeWrapper((Context)context, styleId);
        }
        return LayoutInflater.from(themedContext);
    }

    @Override
    protected void setTitle(CharSequence title) {
        if (title != null && this.mWindowDecorActionBar != null) {
            Method setTitle = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setTitle", CharSequence.class);
            AppCompatActionBar.invoke(setTitle, this.mWindowDecorActionBar, title);
        }
    }

    @Override
    protected void setSubtitle(CharSequence subtitle) {
        if (subtitle != null && this.mWindowDecorActionBar != null) {
            Method setSubtitle = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setSubtitle", CharSequence.class);
            AppCompatActionBar.invoke(setSubtitle, this.mWindowDecorActionBar, subtitle);
        }
    }

    @Override
    protected void setIcon(String icon) {
        Drawable iconDrawable;
        if (icon != null && !icon.isEmpty() && this.mWindowDecorActionBar != null && AppCompatActionBar.invoke(AppCompatActionBar.getMethod(this.mWindowActionBarClass, "hasIcon", new Class[0]), this.mWindowDecorActionBar, new Object[0]) == Boolean.TRUE && (iconDrawable = this.getDrawable(icon, false)) != null) {
            Method setIcon = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setIcon", Drawable.class);
            AppCompatActionBar.invoke(setIcon, this.mWindowDecorActionBar, iconDrawable);
        }
    }

    @Override
    protected void setHomeAsUp(boolean homeAsUp) {
        if (this.mWindowDecorActionBar != null) {
            Method setHomeAsUp = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setDefaultDisplayHomeAsUpEnabled", Boolean.TYPE);
            AppCompatActionBar.invoke(setHomeAsUp, this.mWindowDecorActionBar, homeAsUp);
        }
    }

    private void inflateMenus() {
        int id2;
        String name;
        List menuNames = this.getCallBack().getMenuIdNames();
        if (menuNames.isEmpty()) {
            return;
        }
        if (menuNames.size() > 1) {
            Bridge.getLog().fidelityWarning("unsupported", "Support Toolbar does not currently support multiple menus in the preview.", null, null, null);
        }
        if ((name = (String)menuNames.get(0)).startsWith("android:")) {
            name = name.substring("android:".length());
            id2 = this.mBridgeContext.getFrameworkResourceId(ResourceType.MENU, name, -1);
        } else {
            id2 = this.mBridgeContext.getProjectResourceId(new ResourceReference(ResourceNamespace.TODO(), ResourceType.MENU, name), -1);
        }
        if (id2 < 1) {
            return;
        }
        Object mDecorToolbar = AppCompatActionBar.getFieldValue(this.mWindowDecorActionBar, "mDecorToolbar");
        if (mDecorToolbar == null) {
            return;
        }
        Class<?> mDecorToolbarClass = mDecorToolbar.getClass();
        Context themedContext = (Context)AppCompatActionBar.invoke(AppCompatActionBar.getMethod(this.mWindowActionBarClass, "getThemedContext", new Class[0]), this.mWindowDecorActionBar, new Object[0]);
        MenuInflater inflater = new MenuInflater(themedContext);
        Menu menuBuilder = (Menu)AppCompatActionBar.invoke(AppCompatActionBar.getMethod(mDecorToolbarClass, "getMenu", new Class[0]), mDecorToolbar, new Object[0]);
        inflater.inflate(id2, menuBuilder);
        AppCompatActionBar.invoke(AppCompatActionBar.findMethod(mDecorToolbarClass, "setMenu"), mDecorToolbar, menuBuilder, null);
    }

    @Override
    public void createMenuPopup() {
    }

    private static Method getMethod(Class<?> owner, String name, Class<?> ... parameterTypes) {
        try {
            return owner == null ? null : owner.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method findMethod(Class<?> owner, String name) {
        if (owner == null) {
            return null;
        }
        for (Method method : owner.getMethods()) {
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFieldValue(Object instance, String name) {
        if (instance == null) {
            return null;
        }
        Class<?> instanceClass = instance.getClass();
        Field field = instanceClass.getDeclaredField(name);
        boolean accesible = field.isAccessible();
        if (!accesible) {
            field.setAccessible(true);
        }
        try {
            Object object = field.get(instance);
            field.setAccessible(accesible);
            return object;
        }
        catch (Throwable throwable) {
            try {
                field.setAccessible(accesible);
                throw throwable;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static Object invoke(Method method, Object owner, Object ... args) {
        try {
            return method == null ? null : method.invoke(owner, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Drawable getDrawable(String name, boolean isFramework) {
        RenderResources res = this.mBridgeContext.getRenderResources();
        ResourceValue value = res.findResValue(name, isFramework);
        if ((value = res.resolveResValue(value)) != null) {
            return ResourceHelper.getDrawable(value, this.mBridgeContext);
        }
        return null;
    }
}

