/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.java.System_Delegate;

public class CloseGuard {
    private static volatile boolean stackAndTrackingEnabled = true;
    private static volatile Reporter reporter = new DefaultReporter();
    private static volatile Tracker currentTracker = null;
    private Object closerNameOrAllocationInfo;

    public static CloseGuard get() {
        return new CloseGuard();
    }

    public static void setEnabled(boolean enabled) {
        stackAndTrackingEnabled = enabled;
    }

    public static boolean isEnabled() {
        return stackAndTrackingEnabled;
    }

    public static void setReporter(Reporter rep) {
        if (rep == null) {
            throw new NullPointerException("reporter == null");
        }
        reporter = rep;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    public static void setTracker(Tracker tracker) {
        currentTracker = tracker;
    }

    public static Tracker getTracker() {
        return currentTracker;
    }

    private CloseGuard() {
    }

    public void open(String closer) {
        if (closer == null) {
            throw new NullPointerException("closer == null");
        }
        if (!stackAndTrackingEnabled) {
            this.closerNameOrAllocationInfo = closer;
            return;
        }
        String message = "Explicit termination method '" + closer + "' not called";
        Throwable stack = new Throwable(message);
        this.closerNameOrAllocationInfo = stack;
        Tracker tracker = currentTracker;
        if (tracker != null) {
            tracker.open(stack);
        }
    }

    public void close() {
        Tracker tracker = currentTracker;
        if (tracker != null && this.closerNameOrAllocationInfo instanceof Throwable) {
            tracker.close((Throwable)this.closerNameOrAllocationInfo);
        }
        this.closerNameOrAllocationInfo = null;
    }

    public void warnIfOpen() {
        if (this.closerNameOrAllocationInfo != null) {
            if (this.closerNameOrAllocationInfo instanceof String) {
                System_Delegate.log("A resource failed to call " + (String)this.closerNameOrAllocationInfo + ". ");
            } else {
                String message = "A resource was acquired at attached stack trace but never released. ";
                message = message + "See java.io.Closeable for information on avoiding resource leaks.";
                Throwable stack = (Throwable)this.closerNameOrAllocationInfo;
                reporter.report(message, stack);
            }
        }
    }

    private static class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            System_Delegate.log(message, allocationSite);
        }
    }

    public static interface Reporter {
        public void report(String var1, Throwable var2);
    }

    public static interface Tracker {
        public void open(Throwable var1);

        public void close(Throwable var1);
    }
}

