/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pollexor;

import com.squareup.pollexor.Utilities;
import java.util.ArrayList;
import java.util.List;

public final class Pollexor {
    private static final String PREFIX_UNSAFE = "unsafe/";
    private static final String PREFIX_META = "meta/";
    private static final String PART_SMART = "smart";
    private static final String PART_FIT_IN = "fit-in";
    private static final String PART_FILTERS = "filters";
    private static final String FILTER_BRIGHTNESS = "brightness";
    private static final String FILTER_CONTRAST = "contrast";
    private static final String FILTER_NOISE = "noise";
    private static final String FILTER_QUALITY = "quality";
    private static final String FILTER_RGB = "rgb";
    private static final String FILTER_ROUND_CORNER = "round_corner";
    private static final String FILTER_WATERMARK = "watermark";
    private static final String FILTER_SHARPEN = "sharpen";
    private static final String FILTER_FILL = "fill";
    private static final String FILTER_FRAME = "frame";
    private static final String FILTER_STRIP_ICC = "strip_icc";
    final String target;
    String host = "/";
    String key;
    boolean hasCrop;
    boolean hasResize;
    boolean isSmart;
    boolean isLegacy;
    boolean flipHorizontally;
    boolean flipVertically;
    boolean fitIn;
    int resizeWidth;
    int resizeHeight;
    int cropTop;
    int cropLeft;
    int cropBottom;
    int cropRight;
    HorizontalAlign cropHorizontalAlign;
    VerticalAlign cropVerticalAlign;
    List<String> filters;

    Pollexor(String target) {
        this.target = Utilities.stripProtocolAndParams(target);
    }

    public static Pollexor image(String target) {
        if (target == null || target.length() == 0) {
            throw new UnableToBuildException("Target image URL must not be blank.");
        }
        return new Pollexor(target);
    }

    public Pollexor key(String key) {
        if (key == null || key.length() == 0) {
            throw new UnableToBuildException("Key must not be blank.");
        }
        this.key = key;
        return this;
    }

    public Pollexor host(String host) {
        if (host == null || host.length() == 0) {
            throw new UnableToBuildException("Host must not be blank.");
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        this.host = host;
        return this;
    }

    public Pollexor resize(int width, int height) {
        if (width < 1) {
            throw new UnableToBuildException("Width must be greater than zero.");
        }
        if (height < 1) {
            throw new UnableToBuildException("Height must be greater than zero.");
        }
        this.hasResize = true;
        this.resizeWidth = width;
        this.resizeHeight = height;
        return this;
    }

    public Pollexor flipHorizontally() {
        if (!this.hasResize) {
            throw new UnableToBuildException("Image must be resized first in order to flip.");
        }
        this.flipHorizontally = true;
        return this;
    }

    public Pollexor flipVertically() {
        if (!this.hasResize) {
            throw new UnableToBuildException("Image must be resized first in order to flip.");
        }
        this.flipVertically = true;
        return this;
    }

    public Pollexor fitIn() {
        if (!this.hasResize) {
            throw new UnableToBuildException("Image must be resized first in order to apply 'fit-in'.");
        }
        this.fitIn = true;
        return this;
    }

    public Pollexor crop(int top, int left, int bottom, int right) {
        if (top < 0) {
            throw new UnableToBuildException("Top must be greater or equal to zero.");
        }
        if (left < 0) {
            throw new UnableToBuildException("Left must be greater or equal to zero.");
        }
        if (bottom < 1 || bottom <= top) {
            throw new UnableToBuildException("Bottom must be greater than zero and top.");
        }
        if (right < 1 || right <= left) {
            throw new UnableToBuildException("Right must be greater than zero and left.");
        }
        this.hasCrop = true;
        this.cropTop = top;
        this.cropLeft = left;
        this.cropBottom = bottom;
        this.cropRight = right;
        return this;
    }

    public Pollexor align(HorizontalAlign align) {
        if (!this.hasCrop) {
            throw new UnableToBuildException("Image must be cropped first in order to align.");
        }
        this.cropHorizontalAlign = align;
        return this;
    }

    public Pollexor align(VerticalAlign align) {
        if (!this.hasCrop) {
            throw new UnableToBuildException("Image must be cropped first in order to align.");
        }
        this.cropVerticalAlign = align;
        return this;
    }

    public Pollexor align(VerticalAlign valign, HorizontalAlign halign) {
        return this.align(valign).align(halign);
    }

    public Pollexor smart() {
        if (!this.hasCrop) {
            throw new UnableToBuildException("Image must be cropped first in order to smart align.");
        }
        this.isSmart = true;
        return this;
    }

    public Pollexor legacy() {
        this.isLegacy = true;
        return this;
    }

    public Pollexor filter(String ... filters) {
        if (filters.length == 0) {
            throw new UnableToBuildException("You must provide at least one filter.");
        }
        if (this.filters == null) {
            this.filters = new ArrayList<String>(filters.length);
        }
        for (String filter : filters) {
            if (filter == null || filter.length() == 0) {
                throw new UnableToBuildException("Filter must not be blank.");
            }
            this.filters.add(filter);
        }
        return this;
    }

    public String toUrl() {
        return this.key == null ? this.toUrlUnsafe() : this.toUrlSafe();
    }

    public String toUrlUnsafe() {
        return this.host + PREFIX_UNSAFE + this.assembleConfig(false);
    }

    public String toUrlSafe() {
        if (this.key == null) {
            throw new UnableToBuildException("Cannot build safe URL without a key.");
        }
        try {
            boolean legacy = this.isLegacy;
            StringBuilder config = this.assembleConfig(false);
            byte[] encrypted = legacy ? Utilities.aes128Encrypt(config, this.key) : Utilities.hmacSha1(config, this.key);
            String encoded = Utilities.base64Encode(encrypted);
            CharSequence suffix = legacy ? this.target : config;
            return this.host + encoded + "/" + suffix;
        }
        catch (IllegalArgumentException e) {
            throw new UnableToBuildException(e);
        }
    }

    public String toMeta() {
        return this.key == null ? this.toMetaUnsafe() : this.toMetaSafe();
    }

    public String toMetaUnsafe() {
        return this.host + this.assembleConfig(true);
    }

    public String toMetaSafe() {
        try {
            StringBuilder config = this.assembleConfig(true);
            byte[] encrypted = Utilities.hmacSha1(config, this.key);
            String encoded = Utilities.base64Encode(encrypted);
            return this.host + encoded + "/" + config;
        }
        catch (Exception e) {
            throw new UnableToBuildException(e);
        }
    }

    public String toString() {
        return this.toUrl();
    }

    StringBuilder assembleConfig(boolean meta) {
        StringBuilder builder = new StringBuilder();
        if (meta) {
            builder.append(PREFIX_META);
        }
        if (this.hasCrop) {
            builder.append(this.cropLeft).append("x").append(this.cropTop).append(":").append(this.cropRight).append("x").append(this.cropBottom);
            if (this.isSmart) {
                builder.append("/").append(PART_SMART);
            } else {
                if (this.cropHorizontalAlign != null) {
                    builder.append("/").append(this.cropHorizontalAlign.value);
                }
                if (this.cropVerticalAlign != null) {
                    builder.append("/").append(this.cropVerticalAlign.value);
                }
            }
            builder.append("/");
        }
        if (this.hasResize) {
            if (this.flipHorizontally) {
                builder.append("-");
            }
            builder.append(this.resizeWidth).append("x");
            if (this.flipVertically) {
                builder.append("-");
            }
            builder.append(this.resizeHeight);
            if (this.fitIn) {
                builder.append("/").append(PART_FIT_IN);
            }
            builder.append("/");
        }
        if (this.filters != null) {
            builder.append(PART_FILTERS);
            for (String filter : this.filters) {
                builder.append(":").append(filter);
            }
            builder.append("/");
        }
        builder.append(this.isLegacy ? Utilities.md5(this.target) : this.target);
        return builder;
    }

    public static String brightness(int amount) {
        if (amount < -100 || amount > 100) {
            throw new UnableToBuildException("Amount must be between -100 and 100, inclusive.");
        }
        return "brightness(" + amount + ")";
    }

    public static String contrast(int amount) {
        if (amount < -100 || amount > 100) {
            throw new UnableToBuildException("Amount must be between -100 and 100, inclusive.");
        }
        return "contrast(" + amount + ")";
    }

    public static String noise(int amount) {
        if (amount < 0 || amount > 100) {
            throw new UnableToBuildException("Amount must be between 0 and 100, inclusive");
        }
        return "noise(" + amount + ")";
    }

    public static String quality(int amount) {
        if (amount < 0 || amount > 100) {
            throw new UnableToBuildException("Amount must be between 0 and 100, inclusive.");
        }
        return "quality(" + amount + ")";
    }

    public static String rgb(int r, int g, int b) {
        if (r < -100 || r > 100) {
            throw new UnableToBuildException("Redness value must be between -100 and 100, inclusive.");
        }
        if (g < -100 || g > 100) {
            throw new UnableToBuildException("Greenness value must be between -100 and 100, inclusive.");
        }
        if (b < -100 || b > 100) {
            throw new UnableToBuildException("Blueness value must be between -100 and 100, inclusive.");
        }
        return "rgb(" + r + "," + g + "," + b + ")";
    }

    public static String roundCorner(int radius) {
        return Pollexor.roundCorner(radius, 0xFFFFFF);
    }

    public static String roundCorner(int radius, int color) {
        return Pollexor.roundCorner(radius, 0, color);
    }

    public static String roundCorner(int radiusInner, int radiusOuter, int color) {
        if (radiusInner < 1) {
            throw new UnableToBuildException("Radius must be greater than zero.");
        }
        if (radiusOuter < 0) {
            throw new UnableToBuildException("Outer radius must be greater than or equal to zero.");
        }
        StringBuilder builder = new StringBuilder(FILTER_ROUND_CORNER).append("(").append(radiusInner);
        if (radiusOuter > 0) {
            builder.append("|").append(radiusOuter);
        }
        int r = (color & 0xFF0000) >>> 16;
        int g = (color & 0xFF00) >>> 8;
        int b = color & 0xFF;
        return builder.append(",").append(r).append(",").append(g).append(",").append(b).append(")").toString();
    }

    public static String watermark(String imageUrl) {
        return Pollexor.watermark(imageUrl, 0, 0);
    }

    public static String watermark(Pollexor image) {
        return Pollexor.watermark(image, 0, 0);
    }

    public static String watermark(String imageUrl, int x, int y) {
        return Pollexor.watermark(imageUrl, x, y, 0);
    }

    public static String watermark(Pollexor image, int x, int y) {
        if (image == null) {
            throw new UnableToBuildException("Image must not be null.");
        }
        return Pollexor.watermark(image.toString(), x, y, 0);
    }

    public static String watermark(String imageUrl, int x, int y, int transparency) {
        if (imageUrl == null || imageUrl.length() == 0) {
            throw new UnableToBuildException("Image URL must not be blank.");
        }
        if (transparency < 0 || transparency > 100) {
            throw new UnableToBuildException("Transparency must be between 0 and 100, inclusive.");
        }
        return "watermark(" + Utilities.stripProtocolAndParams(imageUrl) + "," + x + "," + y + "," + transparency + ")";
    }

    public static String watermark(Pollexor image, int x, int y, int transparency) {
        if (image == null) {
            throw new UnableToBuildException("Image must not be null.");
        }
        return Pollexor.watermark(image.toString(), x, y, transparency);
    }

    public static String sharpen(float amount, float radius, boolean luminanceOnly) {
        return "sharpen(" + amount + "," + radius + "," + luminanceOnly + ")";
    }

    public static String fill(int color) {
        String colorCode = Integer.toHexString(color & 0xFFFFFF);
        return "fill(" + colorCode + ")";
    }

    public static String frame(String imageUrl) {
        if (imageUrl == null || imageUrl.length() == 0) {
            throw new UnableToBuildException("Image URL must not be blank.");
        }
        return "frame(" + Utilities.stripProtocolAndParams(imageUrl) + ")";
    }

    public static String stripicc() {
        return "strip_icc()";
    }

    public static class UnableToBuildException
    extends RuntimeException {
        public UnableToBuildException(String reason) {
            super(reason);
        }

        public UnableToBuildException(Throwable e) {
            super(e);
        }
    }

    public static enum VerticalAlign {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        final String value;

        private VerticalAlign(String value) {
            this.value = value;
        }
    }

    public static enum HorizontalAlign {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        final String value;

        private HorizontalAlign(String value) {
            this.value = value;
        }
    }
}

