/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pollexor;

import com.squareup.pollexor.Pollexor;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

final class Utilities {
    private static final String BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final int BASE64_UPPER_BOUND = 0x5FFFFFFD;

    private Utilities() {
    }

    public static String base64Encode(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Input bytes must not be null.");
        }
        if (bytes.length >= 0x5FFFFFFD) {
            throw new IllegalArgumentException("Input bytes length must not exceed 1610612733");
        }
        int triples = bytes.length / 3;
        if (bytes.length % 3 != 0) {
            ++triples;
        }
        char[] encoding = new char[triples << 2];
        int in = 0;
        int out = 0;
        while (in < bytes.length) {
            int triple = (bytes[in] & 0xFF) << 16;
            if (in + 1 < bytes.length) {
                triple |= (bytes[in + 1] & 0xFF) << 8;
            }
            if (in + 2 < bytes.length) {
                triple |= bytes[in + 2] & 0xFF;
            }
            encoding[out] = BASE64_CHARS.charAt(triple >> 18 & 0x3F);
            encoding[out + 1] = BASE64_CHARS.charAt(triple >> 12 & 0x3F);
            encoding[out + 2] = BASE64_CHARS.charAt(triple >> 6 & 0x3F);
            encoding[out + 3] = BASE64_CHARS.charAt(triple & 0x3F);
            in += 3;
            out += 4;
        }
        for (int i = encoding.length - (triples * 3 - bytes.length); i < encoding.length; ++i) {
            encoding[i] = 61;
        }
        return String.valueOf(encoding);
    }

    static void rightPadString(StringBuilder builder, char padding, int multipleOf) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder input must not be empty.");
        }
        if (multipleOf < 2) {
            throw new IllegalArgumentException("Multiple must be greater than one.");
        }
        int needed = multipleOf - builder.length() % multipleOf;
        if (needed < multipleOf) {
            for (int i = needed; i > 0; --i) {
                builder.append(padding);
            }
        }
    }

    static String normalizeString(String string, int desiredLength) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Must supply a non-null, non-empty string.");
        }
        if (desiredLength <= 0) {
            throw new IllegalArgumentException("Desired length must be greater than zero.");
        }
        if (string.length() >= desiredLength) {
            return string.substring(0, desiredLength);
        }
        StringBuilder builder = new StringBuilder(string);
        while (builder.length() < desiredLength) {
            builder.append(string);
        }
        return builder.substring(0, desiredLength);
    }

    static String md5(String input) {
        if (input == null || input.length() == 0) {
            throw new IllegalArgumentException("Input string must not be blank.");
        }
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(input.getBytes());
            byte[] messageDigest = algorithm.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(messageDigest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new Pollexor.UnableToBuildException(e);
        }
    }

    static byte[] hmacSha1(StringBuilder message, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key.getBytes(), "HmacSHA1"));
            return mac.doFinal(message.toString().getBytes());
        }
        catch (Exception e) {
            throw new Pollexor.UnableToBuildException(e);
        }
    }

    static byte[] aes128Encrypt(StringBuilder message, String key) {
        try {
            key = Utilities.normalizeString(key, 16);
            Utilities.rightPadString(message, '{', 16);
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, new SecretKeySpec(key.getBytes(), "AES"));
            return cipher.doFinal(message.toString().getBytes());
        }
        catch (Exception e) {
            throw new Pollexor.UnableToBuildException(e);
        }
    }
}

