/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pollexor;

import com.squareup.pollexor.ThumborUrlBuilder;

public final class Thumbor {
    private final String host;
    private final String key;

    public static Thumbor create(String host) {
        return new Thumbor(host, null);
    }

    public static Thumbor create(String host, String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key must not be blank.");
        }
        return new Thumbor(host, key);
    }

    private Thumbor(String host, String key) {
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("Host must not be blank.");
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        this.host = host;
        this.key = key;
    }

    public String getHost() {
        return this.host;
    }

    public String getKey() {
        return this.key;
    }

    public ThumborUrlBuilder buildImage(String image) {
        if (image == null || image.length() == 0) {
            throw new IllegalArgumentException("Image must not be blank.");
        }
        return new ThumborUrlBuilder(this.host, this.key, image);
    }
}

