/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pollexor;

import com.squareup.pollexor.Utilities;
import java.util.ArrayList;
import java.util.List;

public final class ThumborUrlBuilder {
    private static final String PREFIX_UNSAFE = "unsafe/";
    private static final String PREFIX_META = "meta/";
    private static final String PART_SMART = "smart";
    private static final String PART_TRIM = "trim";
    private static final String PART_FILTERS = "filters";
    private static final String FILTER_BRIGHTNESS = "brightness";
    private static final String FILTER_CONTRAST = "contrast";
    private static final String FILTER_NOISE = "noise";
    private static final String FILTER_QUALITY = "quality";
    private static final String FILTER_RGB = "rgb";
    private static final String FILTER_ROUND_CORNER = "round_corner";
    private static final String FILTER_WATERMARK = "watermark";
    private static final String FILTER_SHARPEN = "sharpen";
    private static final String FILTER_FILL = "fill";
    private static final String FILTER_FORMAT = "format";
    private static final String FILTER_FRAME = "frame";
    private static final String FILTER_STRIP_ICC = "strip_icc";
    private static final String FILTER_GRAYSCALE = "grayscale";
    private static final String FILTER_EQUALIZE = "equalize";
    private static final String FILTER_BLUR = "blur";
    private static final String FILTER_NO_UPSCALE = "no_upscale";
    private static final String FILTER_ROTATE = "rotate";
    public static final int ORIGINAL_SIZE = Integer.MIN_VALUE;
    final String image;
    final String host;
    final String key;
    boolean hasCrop;
    boolean hasResize;
    boolean isSmart;
    boolean isTrim;
    boolean flipHorizontally;
    boolean flipVertically;
    FitInStyle fitInStyle;
    int resizeWidth;
    int resizeHeight;
    int cropTop;
    int cropLeft;
    int cropBottom;
    int cropRight;
    int trimColorTolerance;
    HorizontalAlign cropHorizontalAlign;
    VerticalAlign cropVerticalAlign;
    TrimPixelColor trimPixelColor;
    List<String> filters;

    ThumborUrlBuilder(String host, String key, String image) {
        this.host = host;
        this.key = key;
        this.image = image;
    }

    public ThumborUrlBuilder resize(int width, int height) {
        if (width < 0 && width != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Width must be a positive number.");
        }
        if (height < 0 && height != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Height must be a positive number.");
        }
        if (width == 0 && height == 0) {
            throw new IllegalArgumentException("Both width and height must not be zero.");
        }
        this.hasResize = true;
        this.resizeWidth = width;
        this.resizeHeight = height;
        return this;
    }

    public ThumborUrlBuilder flipHorizontally() {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to flip.");
        }
        this.flipHorizontally = true;
        return this;
    }

    public ThumborUrlBuilder flipVertically() {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to flip.");
        }
        this.flipVertically = true;
        return this;
    }

    public ThumborUrlBuilder fitIn() {
        return this.fitIn(FitInStyle.NORMAL);
    }

    public ThumborUrlBuilder fitIn(FitInStyle fitInStyle) {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to apply 'fit-in'.");
        }
        this.fitInStyle = fitInStyle;
        return this;
    }

    public ThumborUrlBuilder crop(int top, int left, int bottom, int right) {
        if (top < 0) {
            throw new IllegalArgumentException("Top must be greater or equal to zero.");
        }
        if (left < 0) {
            throw new IllegalArgumentException("Left must be greater or equal to zero.");
        }
        if (bottom < 1 || bottom <= top) {
            throw new IllegalArgumentException("Bottom must be greater than zero and top.");
        }
        if (right < 1 || right <= left) {
            throw new IllegalArgumentException("Right must be greater than zero and left.");
        }
        this.hasCrop = true;
        this.cropTop = top;
        this.cropLeft = left;
        this.cropBottom = bottom;
        this.cropRight = right;
        return this;
    }

    public ThumborUrlBuilder align(HorizontalAlign align) {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to align.");
        }
        this.cropHorizontalAlign = align;
        return this;
    }

    public ThumborUrlBuilder align(VerticalAlign align) {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to align.");
        }
        this.cropVerticalAlign = align;
        return this;
    }

    public ThumborUrlBuilder align(VerticalAlign valign, HorizontalAlign halign) {
        return this.align(valign).align(halign);
    }

    public ThumborUrlBuilder smart() {
        if (!this.hasResize) {
            throw new IllegalStateException("Image must be resized first in order to smart align.");
        }
        this.isSmart = true;
        return this;
    }

    public ThumborUrlBuilder trim() {
        return this.trim(null);
    }

    public ThumborUrlBuilder trim(TrimPixelColor value) {
        return this.trim(value, 0);
    }

    public ThumborUrlBuilder trim(TrimPixelColor value, int colorTolerance) {
        if (colorTolerance < 0 || colorTolerance > 442) {
            throw new IllegalArgumentException("Color tolerance must be between 0 and 442.");
        }
        if (colorTolerance > 0 && value == null) {
            throw new IllegalArgumentException("Trim pixel color value must not be null.");
        }
        this.isTrim = true;
        this.trimPixelColor = value;
        this.trimColorTolerance = colorTolerance;
        return this;
    }

    public ThumborUrlBuilder filter(String ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("You must provide at least one filter.");
        }
        if (this.filters == null) {
            this.filters = new ArrayList<String>(filters.length);
        }
        for (String filter : filters) {
            if (filter == null || filter.length() == 0) {
                throw new IllegalArgumentException("Filter must not be blank.");
            }
            this.filters.add(filter);
        }
        return this;
    }

    public String toUrl() {
        return this.key == null ? this.toUrlUnsafe() : this.toUrlSafe();
    }

    public String toUrlUnsafe() {
        return this.host + PREFIX_UNSAFE + this.assembleConfig(false);
    }

    public String toUrlSafe() {
        if (this.key == null) {
            throw new IllegalStateException("Cannot build safe URL without a key.");
        }
        StringBuilder config = this.assembleConfig(false);
        byte[] encrypted = Utilities.hmacSha1(config, this.key);
        String encoded = Utilities.base64Encode(encrypted);
        return this.host + encoded + "/" + config;
    }

    public String toMeta() {
        return this.key == null ? this.toMetaUnsafe() : this.toMetaSafe();
    }

    public String toMetaUnsafe() {
        return this.host + this.assembleConfig(true);
    }

    public String toMetaSafe() {
        StringBuilder config = this.assembleConfig(true);
        byte[] encrypted = Utilities.hmacSha1(config, this.key);
        String encoded = Utilities.base64Encode(encrypted);
        return this.host + encoded + "/" + config;
    }

    public String toString() {
        return this.toUrl();
    }

    StringBuilder assembleConfig(boolean meta) {
        StringBuilder builder = new StringBuilder();
        if (meta) {
            builder.append(PREFIX_META);
        }
        if (this.isTrim) {
            builder.append(PART_TRIM);
            if (this.trimPixelColor != null) {
                builder.append(":").append(this.trimPixelColor.value);
                if (this.trimColorTolerance > 0) {
                    builder.append(":").append(this.trimColorTolerance);
                }
            }
            builder.append("/");
        }
        if (this.hasCrop) {
            builder.append(this.cropLeft).append("x").append(this.cropTop).append(":").append(this.cropRight).append("x").append(this.cropBottom);
            builder.append("/");
        }
        if (this.hasResize) {
            if (this.fitInStyle != null) {
                builder.append(this.fitInStyle.value).append("/");
            }
            if (this.flipHorizontally) {
                builder.append("-");
            }
            if (this.resizeWidth == Integer.MIN_VALUE) {
                builder.append("orig");
            } else {
                builder.append(this.resizeWidth);
            }
            builder.append("x");
            if (this.flipVertically) {
                builder.append("-");
            }
            if (this.resizeHeight == Integer.MIN_VALUE) {
                builder.append("orig");
            } else {
                builder.append(this.resizeHeight);
            }
            if (this.isSmart) {
                builder.append("/").append(PART_SMART);
            } else {
                if (this.cropHorizontalAlign != null) {
                    builder.append("/").append(this.cropHorizontalAlign.value);
                }
                if (this.cropVerticalAlign != null) {
                    builder.append("/").append(this.cropVerticalAlign.value);
                }
            }
            builder.append("/");
        }
        if (this.filters != null) {
            builder.append(PART_FILTERS);
            for (String filter : this.filters) {
                builder.append(":").append(filter);
            }
            builder.append("/");
        }
        builder.append(this.image);
        return builder;
    }

    public static String brightness(int amount) {
        if (amount < -100 || amount > 100) {
            throw new IllegalArgumentException("Amount must be between -100 and 100, inclusive.");
        }
        return "brightness(" + amount + ")";
    }

    public static String contrast(int amount) {
        if (amount < -100 || amount > 100) {
            throw new IllegalArgumentException("Amount must be between -100 and 100, inclusive.");
        }
        return "contrast(" + amount + ")";
    }

    public static String noise(int amount) {
        if (amount < 0 || amount > 100) {
            throw new IllegalArgumentException("Amount must be between 0 and 100, inclusive");
        }
        return "noise(" + amount + ")";
    }

    public static String quality(int amount) {
        if (amount < 0 || amount > 100) {
            throw new IllegalArgumentException("Amount must be between 0 and 100, inclusive.");
        }
        return "quality(" + amount + ")";
    }

    public static String rgb(int r, int g, int b) {
        if (r < -100 || r > 100) {
            throw new IllegalArgumentException("Red value must be between -100 and 100, inclusive.");
        }
        if (g < -100 || g > 100) {
            throw new IllegalArgumentException("Green value must be between -100 and 100, inclusive.");
        }
        if (b < -100 || b > 100) {
            throw new IllegalArgumentException("Blue value must be between -100 and 100, inclusive.");
        }
        return "rgb(" + r + "," + g + "," + b + ")";
    }

    public static String roundCorner(int radius) {
        return ThumborUrlBuilder.roundCorner(radius, 0xFFFFFF);
    }

    public static String roundCorner(int radius, int color) {
        return ThumborUrlBuilder.roundCorner(radius, 0, color);
    }

    public static String roundCorner(int radiusInner, int radiusOuter, int color) {
        if (radiusInner < 1) {
            throw new IllegalArgumentException("Radius must be greater than zero.");
        }
        if (radiusOuter < 0) {
            throw new IllegalArgumentException("Outer radius must be greater than or equal to zero.");
        }
        StringBuilder builder = new StringBuilder(FILTER_ROUND_CORNER).append("(").append(radiusInner);
        if (radiusOuter > 0) {
            builder.append("|").append(radiusOuter);
        }
        int r = (color & 0xFF0000) >>> 16;
        int g = (color & 0xFF00) >>> 8;
        int b = color & 0xFF;
        return builder.append(",").append(r).append(",").append(g).append(",").append(b).append(")").toString();
    }

    public static String watermark(String imageUrl) {
        return ThumborUrlBuilder.watermark(imageUrl, 0, 0);
    }

    public static String watermark(ThumborUrlBuilder image) {
        return ThumborUrlBuilder.watermark(image, 0, 0);
    }

    public static String watermark(String imageUrl, int x, int y) {
        return ThumborUrlBuilder.watermark(imageUrl, x, y, 0);
    }

    public static String watermark(ThumborUrlBuilder image, int x, int y) {
        if (image == null) {
            throw new IllegalArgumentException("Image must not be null.");
        }
        return ThumborUrlBuilder.watermark(image.toString(), x, y, 0);
    }

    public static String watermark(String imageUrl, int x, int y, int transparency) {
        if (imageUrl == null || imageUrl.length() == 0) {
            throw new IllegalArgumentException("Image URL must not be blank.");
        }
        if (transparency < 0 || transparency > 100) {
            throw new IllegalArgumentException("Transparency must be between 0 and 100, inclusive.");
        }
        return "watermark(" + imageUrl + "," + x + "," + y + "," + transparency + ")";
    }

    public static String watermark(ThumborUrlBuilder image, int x, int y, int transparency) {
        if (image == null) {
            throw new IllegalArgumentException("Image must not be null.");
        }
        return ThumborUrlBuilder.watermark(image.toString(), x, y, transparency);
    }

    public static String sharpen(float amount, float radius, boolean luminanceOnly) {
        return "sharpen(" + amount + "," + radius + "," + luminanceOnly + ")";
    }

    public static String fill(int color) {
        String colorCode = Integer.toHexString(color & 0xFFFFFF);
        return "fill(" + colorCode + ")";
    }

    public static String format(ImageFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("You must specify an image format.");
        }
        return "format(" + format.value + ")";
    }

    public static String frame(String imageUrl) {
        if (imageUrl == null || imageUrl.length() == 0) {
            throw new IllegalArgumentException("Image URL must not be blank.");
        }
        return "frame(" + imageUrl + ")";
    }

    public static String stripicc() {
        return "strip_icc()";
    }

    public static String grayscale() {
        return "grayscale()";
    }

    public static String equalize() {
        return "equalize()";
    }

    public static String blur(int radius) {
        return ThumborUrlBuilder.blur(radius, 0);
    }

    public static String blur(int radius, int sigma) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be greater than zero.");
        }
        if (radius > 150) {
            throw new IllegalArgumentException("Radius must be lower or equal than 150.");
        }
        if (sigma < 0) {
            throw new IllegalArgumentException("Sigma must be greater than zero.");
        }
        return "blur(" + radius + "," + sigma + ")";
    }

    public static String noUpscale() {
        return "no_upscale()";
    }

    public static String rotate(int angle) {
        if (angle % 90 != 0) {
            throw new IllegalArgumentException("Angle must be multiple of 90\u00b0");
        }
        return "rotate(" + angle + ")";
    }

    public static enum FitInStyle {
        NORMAL("fit-in"),
        FULL("full-fit-in"),
        ADAPTIVE("adaptive-fit-in");

        final String value;

        private FitInStyle(String value) {
            this.value = value;
        }
    }

    public static enum ImageFormat {
        GIF("gif"),
        JPEG("jpeg"),
        PNG("png"),
        WEBP("webp");

        final String value;

        private ImageFormat(String value) {
            this.value = value;
        }
    }

    public static enum TrimPixelColor {
        TOP_LEFT("top-left"),
        BOTTOM_RIGHT("bottom-right");

        final String value;

        private TrimPixelColor(String value) {
            this.value = value;
        }
    }

    public static enum VerticalAlign {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        final String value;

        private VerticalAlign(String value) {
            this.value = value;
        }
    }

    public static enum HorizontalAlign {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        final String value;

        private HorizontalAlign(String value) {
            this.value = value;
        }
    }
}

