/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import retrofit.Converter;

final class JacksonConverter<T>
implements Converter<T> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private final ObjectWriter writer;
    private final ObjectReader reader;

    JacksonConverter(ObjectWriter writer, ObjectReader reader) {
        this.writer = writer;
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromBody(ResponseBody body) throws IOException {
        InputStream is = body.byteStream();
        Object object = this.reader.readValue(is);
        return (T)object;
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestBody toBody(T value) {
        try {
            byte[] bytes = this.writer.writeValueAsBytes(value);
            return RequestBody.create((MediaType)MEDIA_TYPE, (byte[])bytes);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

