/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.util.ArrayList;
import java.util.List;
import retrofit.MockTypedInput;
import retrofit.client.Header;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.mime.TypedInput;

public class MockHttpException
extends RuntimeException {
    final int code;
    final String reason;
    final Object responseBody;
    final List<Header> headers = new ArrayList<Header>(2);

    public static MockHttpException newMovedPermanentely(String location, Object responseBody) {
        if (location == null || "".equals(location.trim())) {
            throw new IllegalArgumentException("Location must not be blank.");
        }
        return new MockHttpException(301, "Moved Permanently", responseBody).withHeader("Location", location);
    }

    public static MockHttpException newMovedTemporarily(String location, Object responseBody) {
        if (location == null || "".equals(location.trim())) {
            throw new IllegalArgumentException("Location must not be blank.");
        }
        return new MockHttpException(302, "Moved Temporarily", responseBody).withHeader("Location", location);
    }

    public static MockHttpException newBadRequest(Object responseBody) {
        return new MockHttpException(400, "Bad Request", responseBody);
    }

    public static MockHttpException newUnauthorized(Object responseBody) {
        return new MockHttpException(401, "Unauthorized", responseBody);
    }

    public static MockHttpException newForbidden(Object responseBody) {
        return new MockHttpException(403, "Forbidded", responseBody);
    }

    public static MockHttpException newNotFound(Object responseBody) {
        return new MockHttpException(404, "Not Found", responseBody);
    }

    public static MockHttpException newInternalError(Object responseBody) {
        return new MockHttpException(500, "Internal Server Error", responseBody);
    }

    public MockHttpException(int code, String reason, Object responseBody) {
        super("HTTP " + code + " " + reason);
        if (code < 300 || code > 599) {
            throw new IllegalArgumentException("Unsupported HTTP error code: " + code);
        }
        if (reason == null || "".equals(reason.trim())) {
            throw new IllegalArgumentException("Reason must not be blank.");
        }
        this.code = code;
        this.reason = reason;
        this.responseBody = responseBody;
    }

    public MockHttpException withHeader(String name, String value) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Header name must not be blank.");
        }
        if (value == null || "".equals(value.trim())) {
            throw new IllegalArgumentException("Header value must not be blank.");
        }
        this.headers.add(new Header(name, value));
        return this;
    }

    Response toResponse(Converter converter) {
        return new Response("", this.code, this.reason, this.headers, (TypedInput)new MockTypedInput(converter, this.responseBody));
    }
}

