/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import retrofit.Callback;
import retrofit.ErrorHandler;
import retrofit.MockHttpException;
import retrofit.MockHttpRetrofitError;
import retrofit.Platform;
import retrofit.RequestBuilder;
import retrofit.RequestInterceptor;
import retrofit.RequestInterceptorTape;
import retrofit.RestAdapter;
import retrofit.RestMethodInfo;
import retrofit.RetrofitError;
import retrofit.Utils;
import retrofit.client.Request;
import retrofit.client.Response;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public final class MockRestAdapter {
    private static final int DEFAULT_DELAY_MS = 2000;
    private static final int DEFAULT_VARIANCE_PCT = 40;
    private static final int DEFAULT_ERROR_PCT = 3;
    private static final int ERROR_DELAY_FACTOR = 3;
    private final RestAdapter restAdapter;
    private MockRxSupport mockRxSupport;
    final Random random = new Random();
    private ValueChangeListener listener = ValueChangeListener.EMPTY;
    private int delayMs = 2000;
    private int variancePct = 40;
    private int errorPct = 3;

    public static MockRestAdapter from(RestAdapter restAdapter) {
        return new MockRestAdapter(restAdapter);
    }

    private MockRestAdapter(RestAdapter restAdapter) {
        this.restAdapter = restAdapter;
    }

    public void setValueChangeListener(ValueChangeListener listener) {
        this.listener = listener;
    }

    private void notifyValueChangeListener() {
        this.listener.onMockValuesChanged(this.delayMs, this.variancePct, this.errorPct);
    }

    public void setDelay(long delayMs) {
        if (delayMs < 0L) {
            throw new IllegalArgumentException("Delay must be positive value.");
        }
        if (delayMs > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Delay value too large. Max: 2147483647");
        }
        if ((long)this.delayMs != delayMs) {
            this.delayMs = (int)delayMs;
            this.notifyValueChangeListener();
        }
    }

    public long getDelay() {
        return this.delayMs;
    }

    public void setVariancePercentage(int variancePct) {
        if (variancePct < 0 || variancePct > 100) {
            throw new IllegalArgumentException("Variance percentage must be between 0 and 100.");
        }
        if (this.variancePct != variancePct) {
            this.variancePct = variancePct;
            this.notifyValueChangeListener();
        }
    }

    public int getVariancePercentage() {
        return this.variancePct;
    }

    public void setErrorPercentage(int errorPct) {
        if (errorPct < 0 || errorPct > 100) {
            throw new IllegalArgumentException("Error percentage must be between 0 and 100.");
        }
        if (this.errorPct != errorPct) {
            this.errorPct = errorPct;
            this.notifyValueChangeListener();
        }
    }

    public int getErrorPercentage() {
        return this.errorPct;
    }

    public boolean calculateIsFailure() {
        int randomValue = this.random.nextInt(100) + 1;
        return randomValue <= this.errorPct;
    }

    public int calculateDelayForError() {
        return this.random.nextInt(this.delayMs * 3);
    }

    public int calculateDelayForCall() {
        float errorPercent = (float)this.variancePct / 100.0f;
        float lowerBound = 1.0f - errorPercent;
        float upperBound = 1.0f + errorPercent;
        float bound = upperBound - lowerBound;
        float delayPercent = this.random.nextFloat() * bound + lowerBound;
        return (int)((float)this.delayMs * delayPercent);
    }

    public <T> T create(Class<T> service, T mockService) {
        Utils.validateServiceClass(service);
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, (InvocationHandler)new MockHandler(mockService, this.restAdapter.getMethodInfoCache(service)));
    }

    private static void sleep(long ms) {
        long start = MockRestAdapter.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        while (duration > 0L) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            duration = start + ms - MockRestAdapter.uptimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static long uptimeMillis() {
        return System.nanoTime() / 1000000L;
    }

    private static class MockRxSupport {
        private final Scheduler httpScheduler;
        private final ErrorHandler errorHandler;

        MockRxSupport(RestAdapter restAdapter) {
            this.httpScheduler = Schedulers.from((Executor)restAdapter.httpExecutor);
            this.errorHandler = restAdapter.errorHandler;
        }

        Observable createMockObservable(final MockHandler mockHandler, final RestMethodInfo methodInfo, final RequestInterceptor interceptor, final Object[] args) {
            return Observable.just((Object)"nothing").flatMap(new Func1<String, Observable<?>>(){

                public Observable<?> call(String s) {
                    try {
                        return (Observable)mockHandler.invokeSync(methodInfo, interceptor, args);
                    }
                    catch (RetrofitError e) {
                        return Observable.error((Throwable)MockRxSupport.this.errorHandler.handleError(e));
                    }
                    catch (Throwable throwable) {
                        return Observable.error((Throwable)throwable);
                    }
                }
            }).subscribeOn(this.httpScheduler);
        }
    }

    private class MockHandler
    implements InvocationHandler {
        private final Object mockService;
        private final Map<Method, RestMethodInfo> methodInfoCache;

        public MockHandler(Object mockService, Map<Method, RestMethodInfo> methodInfoCache) {
            this.mockService = mockService;
            this.methodInfoCache = methodInfoCache;
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            final RestMethodInfo methodInfo = RestAdapter.getMethodInfo(this.methodInfoCache, (Method)method);
            if (methodInfo.isSynchronous) {
                try {
                    return this.invokeSync(methodInfo, ((MockRestAdapter)MockRestAdapter.this).restAdapter.requestInterceptor, args);
                }
                catch (RetrofitError error) {
                    Throwable newError = ((MockRestAdapter)MockRestAdapter.this).restAdapter.errorHandler.handleError(error);
                    if (newError == null) {
                        throw new IllegalStateException("Error handler returned null for wrapped exception.", error);
                    }
                    throw newError;
                }
            }
            if (((MockRestAdapter)MockRestAdapter.this).restAdapter.httpExecutor == null || ((MockRestAdapter)MockRestAdapter.this).restAdapter.callbackExecutor == null) {
                throw new IllegalStateException("Asynchronous invocation requires calling setExecutors.");
            }
            final RequestInterceptorTape interceptorTape = new RequestInterceptorTape();
            ((MockRestAdapter)MockRestAdapter.this).restAdapter.requestInterceptor.intercept((RequestInterceptor.RequestFacade)interceptorTape);
            if (methodInfo.isObservable) {
                if (MockRestAdapter.this.mockRxSupport == null) {
                    if (Platform.HAS_RX_JAVA) {
                        MockRestAdapter.this.mockRxSupport = new MockRxSupport(MockRestAdapter.this.restAdapter);
                    } else {
                        throw new IllegalStateException("Observable method found but no RxJava on classpath");
                    }
                }
                return MockRestAdapter.this.mockRxSupport.createMockObservable(this, methodInfo, (RequestInterceptor)interceptorTape, args);
            }
            ((MockRestAdapter)MockRestAdapter.this).restAdapter.httpExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MockHandler.this.invokeAsync(methodInfo, (RequestInterceptor)interceptorTape, args);
                }
            });
            return null;
        }

        private Request buildRequest(RestMethodInfo methodInfo, RequestInterceptor interceptor, Object[] args) throws Throwable {
            methodInfo.init();
            String apiUrl = ((MockRestAdapter)MockRestAdapter.this).restAdapter.server.getUrl();
            RequestBuilder requestBuilder = new RequestBuilder(apiUrl, methodInfo, ((MockRestAdapter)MockRestAdapter.this).restAdapter.converter);
            requestBuilder.setArguments(args);
            interceptor.intercept((RequestInterceptor.RequestFacade)requestBuilder);
            Request request = requestBuilder.build();
            if (((MockRestAdapter)MockRestAdapter.this).restAdapter.logLevel.log()) {
                request = MockRestAdapter.this.restAdapter.logAndReplaceRequest("MOCK", request, args);
            }
            return request;
        }

        private Object invokeSync(RestMethodInfo methodInfo, RequestInterceptor interceptor, Object[] args) throws Throwable {
            Request request = this.buildRequest(methodInfo, interceptor, args);
            String url = request.getUrl();
            if (MockRestAdapter.this.calculateIsFailure()) {
                MockRestAdapter.sleep(MockRestAdapter.this.calculateDelayForError());
                IOException exception = new IOException("Mock network error!");
                if (((MockRestAdapter)MockRestAdapter.this).restAdapter.logLevel.log()) {
                    MockRestAdapter.this.restAdapter.logException((Throwable)exception, url);
                }
                throw RetrofitError.networkError((String)url, (IOException)exception);
            }
            RestAdapter.LogLevel logLevel = ((MockRestAdapter)MockRestAdapter.this).restAdapter.logLevel;
            RestAdapter.Log log = ((MockRestAdapter)MockRestAdapter.this).restAdapter.log;
            int callDelay = MockRestAdapter.this.calculateDelayForCall();
            long beforeNanos = System.nanoTime();
            try {
                Object returnValue = methodInfo.method.invoke(this.mockService, args);
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeNanos);
                MockRestAdapter.sleep((long)callDelay - tookMs);
                if (logLevel.log()) {
                    log.log(String.format("<--- MOCK 200 %s (%sms)", url, callDelay));
                    if (logLevel.ordinal() >= RestAdapter.LogLevel.FULL.ordinal()) {
                        log.log(returnValue + "");
                        log.log("<--- END MOCK");
                    }
                }
                return returnValue;
            }
            catch (InvocationTargetException e) {
                Throwable innerEx = e.getCause();
                if (!(innerEx instanceof MockHttpException)) {
                    throw innerEx;
                }
                MockHttpException httpEx = (MockHttpException)innerEx;
                Response response = httpEx.toResponse(((MockRestAdapter)MockRestAdapter.this).restAdapter.converter);
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeNanos);
                MockRestAdapter.sleep((long)callDelay - tookMs);
                if (logLevel.log()) {
                    log.log(String.format("<---- MOCK %s %s (%sms)", httpEx.code, url, callDelay));
                    if (logLevel.ordinal() >= RestAdapter.LogLevel.FULL.ordinal()) {
                        log.log(httpEx.responseBody + "");
                        log.log("<--- END MOCK");
                    }
                }
                throw new MockHttpRetrofitError(httpEx.reason, url, response, httpEx.responseBody, methodInfo.responseObjectType);
            }
        }

        private void invokeAsync(final RestMethodInfo methodInfo, RequestInterceptor interceptorTape, final Object[] args) {
            Request request;
            try {
                request = this.buildRequest(methodInfo, interceptorTape, args);
            }
            catch (Throwable throwable) {
                ((MockRestAdapter)MockRestAdapter.this).restAdapter.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(throwable);
                    }
                });
                return;
            }
            final String url = request.getUrl();
            final Callback callback = (Callback)args[args.length - 1];
            if (MockRestAdapter.this.calculateIsFailure()) {
                RetrofitError error;
                Throwable cause;
                MockRestAdapter.sleep(MockRestAdapter.this.calculateDelayForError());
                IOException exception = new IOException("Mock network error!");
                if (((MockRestAdapter)MockRestAdapter.this).restAdapter.logLevel.log()) {
                    MockRestAdapter.this.restAdapter.logException((Throwable)exception, url);
                }
                final RetrofitError e = (cause = ((MockRestAdapter)MockRestAdapter.this).restAdapter.errorHandler.handleError(error = RetrofitError.networkError((String)url, (IOException)exception))) == error ? error : RetrofitError.unexpectedError((String)error.getUrl(), (Throwable)cause);
                ((MockRestAdapter)MockRestAdapter.this).restAdapter.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.failure(e);
                    }
                });
                return;
            }
            final int callDelay = MockRestAdapter.this.calculateDelayForCall();
            MockRestAdapter.sleep(callDelay);
            ((MockRestAdapter)MockRestAdapter.this).restAdapter.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    RestAdapter.LogLevel logLevel = ((MockRestAdapter)MockRestAdapter.this).restAdapter.logLevel;
                    RestAdapter.Log log = ((MockRestAdapter)MockRestAdapter.this).restAdapter.log;
                    try {
                        methodInfo.method.invoke(MockHandler.this.mockService, args);
                        if (logLevel.log()) {
                            log.log(String.format("<--- MOCK 200 %s (%sms)", url, callDelay));
                        }
                    }
                    catch (Throwable throwable) {
                        MockHttpRetrofitError error;
                        Throwable cause;
                        Throwable innerEx = throwable.getCause();
                        if (!(innerEx instanceof MockHttpException)) {
                            if (innerEx instanceof RuntimeException) {
                                throw (RuntimeException)innerEx;
                            }
                            throw new RuntimeException(innerEx);
                        }
                        MockHttpException httpEx = (MockHttpException)innerEx;
                        Response response = httpEx.toResponse(((MockRestAdapter)MockRestAdapter.this).restAdapter.converter);
                        if (logLevel.log()) {
                            log.log(String.format("<---- MOCK %s %s (%sms)", httpEx.code, url, callDelay));
                            if (logLevel.ordinal() >= RestAdapter.LogLevel.FULL.ordinal()) {
                                log.log(String.valueOf(httpEx.responseBody));
                                log.log("<--- END MOCK");
                            }
                        }
                        MockHttpRetrofitError e = (cause = ((MockRestAdapter)MockRestAdapter.this).restAdapter.errorHandler.handleError((RetrofitError)(error = new MockHttpRetrofitError(httpEx.getMessage(), url, response, httpEx.responseBody, methodInfo.responseObjectType)))) == error ? error : RetrofitError.unexpectedError((String)error.getUrl(), (Throwable)cause);
                        callback.failure((RetrofitError)e);
                    }
                }
            });
        }
    }

    public static interface ValueChangeListener {
        public static final ValueChangeListener EMPTY = new ValueChangeListener(){

            @Override
            public void onMockValuesChanged(long delayMs, int variancePct, int errorPct) {
            }
        };

        public void onMockValuesChanged(long var1, int var3, int var4);
    }
}

