/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import retrofit.converter.Converter;
import retrofit.mime.TypedInput;

class MockTypedInput
implements TypedInput {
    private final Converter converter;
    private final Object body;
    private byte[] bytes;

    MockTypedInput(Converter converter, Object body) {
        this.converter = converter;
        this.body = body;
    }

    public String mimeType() {
        return "application/unknown";
    }

    public long length() {
        try {
            this.initBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.bytes.length;
    }

    public InputStream in() throws IOException {
        this.initBytes();
        return new ByteArrayInputStream(this.bytes);
    }

    private synchronized void initBytes() throws IOException {
        if (this.bytes == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.converter.toBody(this.body).writeTo((OutputStream)out);
            this.bytes = out.toByteArray();
        }
    }
}

