/*
 * Decompiled with CFR 0.152.
 */
package retrofit.android;

import android.content.SharedPreferences;
import retrofit.MockRestAdapter;

public final class AndroidMockValuePersistence
implements MockRestAdapter.ValueChangeListener {
    private static final String KEY_DELAY = "retrofit-mock-delay";
    private static final String KEY_VARIANCE = "retrofit-mock-variance";
    private static final String KEY_ERROR = "retrofit-mock-error";
    private final SharedPreferences preferences;

    public static void install(MockRestAdapter mockRestAdapter, SharedPreferences preferences) {
        int error;
        int variance;
        long delay = preferences.getLong(KEY_DELAY, -1L);
        if (delay != -1L) {
            mockRestAdapter.setDelay(delay);
        }
        if ((variance = preferences.getInt(KEY_VARIANCE, -1)) != -1) {
            mockRestAdapter.setVariancePercentage(variance);
        }
        if ((error = preferences.getInt(KEY_ERROR, -1)) != -1) {
            mockRestAdapter.setErrorPercentage(error);
        }
        mockRestAdapter.setValueChangeListener(new AndroidMockValuePersistence(preferences));
    }

    private AndroidMockValuePersistence(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void onMockValuesChanged(long delayMs, int variancePct, int errorPct) {
        this.preferences.edit().putLong(KEY_DELAY, delayMs).putInt(KEY_VARIANCE, variancePct).putInt(KEY_ERROR, errorPct).apply();
    }
}

