/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mock;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import retrofit.Call;
import retrofit.Callback;
import retrofit.Response;
import retrofit.Retrofit;
import retrofit.mock.NetworkBehavior;

final class BehaviorCall<T>
implements Call<T> {
    private final Retrofit retrofit;
    private final NetworkBehavior behavior;
    private final ExecutorService backgroundExecutor;
    private final Executor callbackExecutor;
    private final Call<T> delegate;
    private volatile Future<?> task;
    private volatile boolean canceled;
    private volatile boolean executed;

    BehaviorCall(Retrofit retrofit, NetworkBehavior behavior, ExecutorService backgroundExecutor, Call<T> delegate) {
        this.retrofit = retrofit;
        this.behavior = behavior;
        this.backgroundExecutor = backgroundExecutor;
        this.delegate = delegate;
        Executor callbackExecutor = retrofit.callbackExecutor();
        if (callbackExecutor == null) {
            callbackExecutor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
        this.callbackExecutor = callbackExecutor;
    }

    public Call<T> clone() {
        return new BehaviorCall<T>(this.retrofit, this.behavior, this.backgroundExecutor, this.delegate.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(final Callback<T> callback) {
        BehaviorCall behaviorCall = this;
        synchronized (behaviorCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed");
            }
            this.executed = true;
        }
        this.task = this.backgroundExecutor.submit(new Runnable(){

            private boolean delaySleep() {
                long sleepMs = BehaviorCall.this.behavior.calculateDelay(TimeUnit.MILLISECONDS);
                if (sleepMs > 0L) {
                    try {
                        Thread.sleep(sleepMs);
                    }
                    catch (InterruptedException e) {
                        this.callFailure(new InterruptedIOException("canceled"));
                        return false;
                    }
                }
                return true;
            }

            private void callResponse(final Response<T> response) {
                BehaviorCall.this.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onResponse(response, BehaviorCall.this.retrofit);
                    }
                });
            }

            private void callFailure(final Throwable throwable) {
                BehaviorCall.this.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(throwable);
                    }
                });
            }

            @Override
            public void run() {
                if (BehaviorCall.this.canceled) {
                    this.callFailure(new InterruptedIOException("canceled"));
                } else if (BehaviorCall.this.behavior.calculateIsFailure()) {
                    if (this.delaySleep()) {
                        this.callFailure(BehaviorCall.this.behavior.failureException());
                    }
                } else {
                    BehaviorCall.this.delegate.enqueue(new Callback<T>(){

                        public void onResponse(Response<T> response, Retrofit retrofit) {
                            if (this.delaySleep()) {
                                this.callResponse(response);
                            }
                        }

                        public void onFailure(Throwable t) {
                            if (this.delaySleep()) {
                                this.callFailure(t);
                            }
                        }
                    });
                }
            }
        });
    }

    public Response<T> execute() throws IOException {
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference failureRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.enqueue(new Callback<T>(){

            public void onResponse(Response<T> response, Retrofit retrofit) {
                responseRef.set(response);
                latch.countDown();
            }

            public void onFailure(Throwable t) {
                failureRef.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("canceled");
        }
        Response response = (Response)responseRef.get();
        if (response != null) {
            return response;
        }
        Throwable failure = (Throwable)failureRef.get();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof IOException) {
            throw (IOException)failure;
        }
        throw new RuntimeException(failure);
    }

    public void cancel() {
        this.canceled = true;
        Future<?> task = this.task;
        if (task != null) {
            task.cancel(true);
        }
    }
}

