/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mock;

import java.io.IOException;
import retrofit.Call;
import retrofit.Callback;
import retrofit.Response;
import retrofit.Retrofit;

public final class Calls {
    public static <T> Call<T> response(T successValue, Retrofit retrofit) {
        return Calls.response(Response.success(successValue), retrofit);
    }

    public static <T> Call<T> response(final Response<T> response, final Retrofit retrofit) {
        return new Call<T>(){

            public Response<T> execute() throws IOException {
                return response;
            }

            public void enqueue(Callback<T> callback) {
                callback.onResponse(response, retrofit);
            }

            public void cancel() {
            }

            public Call<T> clone() {
                return this;
            }
        };
    }

    public static <T> Call<T> failure(final IOException failure) {
        return new Call<T>(){

            public Response<T> execute() throws IOException {
                throw failure;
            }

            public void enqueue(Callback<T> callback) {
                callback.onFailure((Throwable)failure);
            }

            public void cancel() {
            }

            public Call<T> clone() {
                return this;
            }
        };
    }

    private Calls() {
        throw new AssertionError((Object)"No instances.");
    }
}

