/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import retrofit.mock.NetworkBehavior;

public final class MockRetrofit {
    private final NetworkBehavior behavior;
    private final NetworkBehavior.Adapter<Object> adapter;

    public MockRetrofit(NetworkBehavior behavior, NetworkBehavior.Adapter<?> adapter) {
        this.adapter = adapter;
        this.behavior = behavior;
    }

    public <T> T create(Class<T> service, final T instance) {
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                method.setAccessible(true);
                Object value = method.invoke(instance, args);
                return MockRetrofit.this.adapter.applyBehavior(MockRetrofit.this.behavior, value);
            }
        });
    }
}

