/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mock;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class NetworkBehavior {
    private static final int DEFAULT_DELAY_MS = 2000;
    private static final int DEFAULT_VARIANCE_PERCENT = 40;
    private static final int DEFAULT_FAILURE_PERCENT = 3;
    private final Random random;
    private volatile long delayMs = 2000L;
    private volatile int variancePercent = 40;
    private volatile int failurePercent = 3;
    private volatile Throwable failureException = new IOException("Mock failure!");

    public static NetworkBehavior create() {
        return new NetworkBehavior(new Random());
    }

    public static NetworkBehavior create(Random random) {
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        return new NetworkBehavior(random);
    }

    private NetworkBehavior(Random random) {
        this.random = random;
    }

    public void setDelay(long amount, TimeUnit unit) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount must be positive value.");
        }
        this.delayMs = unit.toMillis(amount);
    }

    public long delay(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.delayMs, unit);
    }

    public void setVariancePercent(int variancePercent) {
        if (variancePercent < 0 || variancePercent > 100) {
            throw new IllegalArgumentException("Variance percentage must be between 0 and 100.");
        }
        this.variancePercent = variancePercent;
    }

    public int variancePercent() {
        return this.variancePercent;
    }

    public void setFailurePercent(int failurePercent) {
        if (failurePercent < 0 || failurePercent > 100) {
            throw new IllegalArgumentException("Failure percentage must be between 0 and 100.");
        }
        this.failurePercent = failurePercent;
    }

    public int failurePercent() {
        return this.failurePercent;
    }

    public void setFailureException(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t == null");
        }
        this.failureException = t;
    }

    public Throwable failureException() {
        return this.failureException;
    }

    public boolean calculateIsFailure() {
        int randomValue = this.random.nextInt(100);
        return randomValue < this.failurePercent;
    }

    public long calculateDelay(TimeUnit unit) {
        float delta = (float)this.variancePercent / 100.0f;
        float lowerBound = 1.0f - delta;
        float upperBound = 1.0f + delta;
        float bound = upperBound - lowerBound;
        float delayPercent = lowerBound + this.random.nextFloat() * bound;
        long callDelayMs = (long)((float)this.delayMs * delayPercent);
        return TimeUnit.MILLISECONDS.convert(callDelayMs, unit);
    }

    public static interface Adapter<T> {
        public T applyBehavior(NetworkBehavior var1, T var2);
    }
}

