/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.guava;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.HttpException;

public final class GuavaCallAdapterFactory
extends CallAdapter.Factory {
    public static GuavaCallAdapterFactory create() {
        return new GuavaCallAdapterFactory();
    }

    private GuavaCallAdapterFactory() {
    }

    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (GuavaCallAdapterFactory.getRawType((Type)returnType) != ListenableFuture.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("ListenableFuture return type must be parameterized as ListenableFuture<Foo> or ListenableFuture<? extends Foo>");
        }
        Type innerType = GuavaCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (GuavaCallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = GuavaCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(responseType);
    }

    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, ListenableFuture<R>> {
        private final Type responseType;

        BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public ListenableFuture<R> adapt(Call<R> call) {
            final CallCancelListenableFuture future = new CallCancelListenableFuture(call);
            call.enqueue(new Callback<R>(){

                public void onResponse(Call<R> call, Response<R> response) {
                    if (response.isSuccessful()) {
                        future.set(response.body());
                    } else {
                        future.setException((Throwable)((Object)new HttpException(response)));
                    }
                }

                public void onFailure(Call<R> call, Throwable t) {
                    future.setException(t);
                }
            });
            return future;
        }
    }

    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, ListenableFuture<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public ListenableFuture<Response<R>> adapt(Call<R> call) {
            final CallCancelListenableFuture future = new CallCancelListenableFuture(call);
            call.enqueue(new Callback<R>(){

                public void onResponse(Call<R> call, Response<R> response) {
                    future.set(response);
                }

                public void onFailure(Call<R> call, Throwable t) {
                    future.setException(t);
                }
            });
            return future;
        }
    }

    private static final class CallCancelListenableFuture<T>
    extends AbstractFuture<T> {
        private final Call<?> call;

        CallCancelListenableFuture(Call<?> call) {
            this.call = call;
        }

        public boolean set(@org.checkerframework.checker.nullness.qual.Nullable T value) {
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        protected void interruptTask() {
            this.call.cancel();
        }
    }
}

