/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.protobuf;

import com.google.protobuf.MessageLite;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.converter.protobuf.ProtoStreamingRequestBody;

final class ProtoRequestBodyConverter<T extends MessageLite>
implements Converter<T, RequestBody> {
    static final MediaType MEDIA_TYPE = MediaType.get((String)"application/x-protobuf");
    private final boolean streaming;

    ProtoRequestBodyConverter(boolean streaming) {
        this.streaming = streaming;
    }

    public RequestBody convert(T value) {
        if (this.streaming) {
            return new ProtoStreamingRequestBody((MessageLite)value);
        }
        byte[] bytes = value.toByteArray();
        return RequestBody.create((MediaType)MEDIA_TYPE, (byte[])bytes);
    }
}

