/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.simplexml;

import java.io.IOException;
import okhttp3.ResponseBody;
import org.simpleframework.xml.Serializer;
import retrofit2.Converter;

final class SimpleXmlResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Class<T> cls;
    private final Serializer serializer;
    private final boolean strict;

    SimpleXmlResponseBodyConverter(Class<T> cls, Serializer serializer, boolean strict) {
        this.cls = cls;
        this.serializer = serializer;
        this.strict = strict;
    }

    public T convert(ResponseBody value) throws IOException {
        try {
            Object read = this.serializer.read(this.cls, value.byteStream(), this.strict);
            if (read == null) {
                throw new IllegalStateException("Could not deserialize body as " + this.cls);
            }
            Object object = read;
            return (T)object;
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            value.close();
        }
    }
}

