/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.mock.BehaviorCall;
import retrofit2.mock.Calls;
import retrofit2.mock.NetworkBehavior;

public final class BehaviorDelegate<T> {
    final Retrofit retrofit;
    private final NetworkBehavior behavior;
    private final ExecutorService executor;
    private final Class<T> service;

    BehaviorDelegate(Retrofit retrofit, NetworkBehavior behavior, ExecutorService executor, Class<T> service) {
        this.retrofit = retrofit;
        this.behavior = behavior;
        this.executor = executor;
        this.service = service;
    }

    public T returningResponse(Object response) {
        return this.returning(Calls.response(response));
    }

    public <R> T returning(Call<R> call) {
        final BehaviorCall<R> behaviorCall = new BehaviorCall<R>(this.behavior, this.executor, call);
        return (T)Proxy.newProxyInstance(this.service.getClassLoader(), new Class[]{this.service}, new InvocationHandler(){

            public T invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Type returnType = method.getGenericReturnType();
                Annotation[] methodAnnotations = method.getAnnotations();
                CallAdapter callAdapter = BehaviorDelegate.this.retrofit.callAdapter(returnType, methodAnnotations);
                return callAdapter.adapt(behaviorCall);
            }
        });
    }
}

