/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import kotlin.coroutines.Continuation;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.KotlinExtensions;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.mock.BehaviorCall;
import retrofit2.mock.Calls;
import retrofit2.mock.NetworkBehavior;

public final class BehaviorDelegate<T> {
    final Retrofit retrofit;
    private final NetworkBehavior behavior;
    private final ExecutorService executor;
    private final Class<T> service;

    BehaviorDelegate(Retrofit retrofit, NetworkBehavior behavior, ExecutorService executor, Class<T> service) {
        this.retrofit = retrofit;
        this.behavior = behavior;
        this.executor = executor;
        this.service = service;
    }

    public T returningResponse(@Nullable Object response) {
        return this.returning(Calls.response(response));
    }

    public <R> T returning(Call<R> call) {
        BehaviorCall behaviorCall = new BehaviorCall(this.behavior, this.executor, call);
        return (T)Proxy.newProxyInstance(this.service.getClassLoader(), new Class[]{this.service}, (proxy, method, args) -> {
            ServiceMethodAdapterInfo adapterInfo = BehaviorDelegate.parseServiceMethodAdapterInfo(method);
            Annotation[] methodAnnotations = method.getAnnotations();
            CallAdapter callAdapter = this.retrofit.callAdapter(adapterInfo.responseType, methodAnnotations);
            Object adapted = callAdapter.adapt(behaviorCall);
            if (!adapterInfo.isSuspend) {
                return adapted;
            }
            Call adaptedCall = (Call)adapted;
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                return adapterInfo.wantsResponse ? KotlinExtensions.awaitResponse((Call)adaptedCall, (Continuation)continuation) : KotlinExtensions.await((Call)adaptedCall, (Continuation)continuation);
            }
            catch (Exception e) {
                return KotlinExtensions.suspendAndThrow((Exception)e, (Continuation)continuation);
            }
        });
    }

    private static ServiceMethodAdapterInfo parseServiceMethodAdapterInfo(Method method) {
        Type lastParameterType;
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes.length != 0 && (lastParameterType = genericParameterTypes[genericParameterTypes.length - 1]) instanceof ParameterizedType) {
            ParameterizedType parameterizedLastParameterType = (ParameterizedType)lastParameterType;
            try {
                if (parameterizedLastParameterType.getRawType() == Continuation.class) {
                    ParameterizedType parameterizedResultType;
                    Type resultType = parameterizedLastParameterType.getActualTypeArguments()[0];
                    if (resultType instanceof WildcardType) {
                        resultType = ((WildcardType)resultType).getLowerBounds()[0];
                    }
                    if (resultType instanceof ParameterizedType && (parameterizedResultType = (ParameterizedType)resultType).getRawType() == Response.class) {
                        Type bodyType = parameterizedResultType.getActualTypeArguments()[0];
                        CallParameterizedTypeImpl callType = new CallParameterizedTypeImpl(bodyType);
                        return new ServiceMethodAdapterInfo(true, true, callType);
                    }
                    CallParameterizedTypeImpl callType = new CallParameterizedTypeImpl(resultType);
                    return new ServiceMethodAdapterInfo(true, false, callType);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return new ServiceMethodAdapterInfo(false, false, method.getGenericReturnType());
    }

    static class ServiceMethodAdapterInfo {
        final boolean isSuspend;
        final boolean wantsResponse;
        final Type responseType;

        ServiceMethodAdapterInfo(boolean isSuspend, boolean wantsResponse, Type responseType) {
            this.isSuspend = isSuspend;
            this.wantsResponse = wantsResponse;
            this.responseType = responseType;
        }
    }

    static final class CallParameterizedTypeImpl
    implements ParameterizedType {
        private final Type bodyType;

        CallParameterizedTypeImpl(Type bodyType) {
            this.bodyType = bodyType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.bodyType};
        }

        @Override
        public Type getRawType() {
            return Call.class;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }
    }
}

