/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import okhttp3.Call;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.OkHttpCall;
import retrofit2.RequestFactory;
import retrofit2.RequestFactoryParser;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.Utils;

final class MethodHandler {
    private final Call.Factory callFactory;
    private final RequestFactory requestFactory;
    private final CallAdapter<?> callAdapter;
    private final Converter<ResponseBody, ?> responseConverter;

    static MethodHandler create(Retrofit retrofit, Method method) {
        CallAdapter<?> callAdapter = MethodHandler.createCallAdapter(method, retrofit);
        Type responseType = callAdapter.responseType();
        if (responseType == Response.class || responseType == okhttp3.Response.class) {
            throw Utils.methodError(method, "'" + Utils.getRawType(responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        Converter<ResponseBody, ?> responseConverter = MethodHandler.createResponseConverter(method, retrofit, responseType);
        RequestFactory requestFactory = RequestFactoryParser.parse(method, responseType, retrofit);
        return new MethodHandler(retrofit.callFactory(), requestFactory, callAdapter, responseConverter);
    }

    private static CallAdapter<?> createCallAdapter(Method method, Retrofit retrofit) {
        Type returnType = method.getGenericReturnType();
        if (Utils.hasUnresolvableType(returnType)) {
            throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", returnType);
        }
        if (returnType == Void.TYPE) {
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        Annotation[] annotations = method.getAnnotations();
        try {
            return retrofit.callAdapter(returnType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(e, method, "Unable to create call adapter for %s", returnType);
        }
    }

    private static Converter<ResponseBody, ?> createResponseConverter(Method method, Retrofit retrofit, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            return retrofit.responseBodyConverter(responseType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(e, method, "Unable to create converter for %s", responseType);
        }
    }

    private MethodHandler(Call.Factory callFactory, RequestFactory requestFactory, CallAdapter<?> callAdapter, Converter<ResponseBody, ?> responseConverter) {
        this.callFactory = callFactory;
        this.requestFactory = requestFactory;
        this.callAdapter = callAdapter;
        this.responseConverter = responseConverter;
    }

    Object invoke(Object ... args) {
        return this.callAdapter.adapt(new OkHttpCall(this.callFactory, this.requestFactory, args, this.responseConverter));
    }
}

