/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import retrofit2.BaseUrl;
import retrofit2.RequestAction;
import retrofit2.RequestBuilder;

final class RequestFactory {
    private final String method;
    private final BaseUrl baseUrl;
    private final String relativeUrl;
    private final Headers headers;
    private final MediaType contentType;
    private final boolean hasBody;
    private final boolean isFormEncoded;
    private final boolean isMultipart;
    private final RequestAction[] requestActions;

    RequestFactory(String method, BaseUrl baseUrl, String relativeUrl, Headers headers, MediaType contentType, boolean hasBody, boolean isFormEncoded, boolean isMultipart, RequestAction[] requestActions) {
        this.method = method;
        this.baseUrl = baseUrl;
        this.relativeUrl = relativeUrl;
        this.headers = headers;
        this.contentType = contentType;
        this.hasBody = hasBody;
        this.isFormEncoded = isFormEncoded;
        this.isMultipart = isMultipart;
        this.requestActions = requestActions;
    }

    Request create(Object ... args) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder(this.method, this.baseUrl.url(), this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart);
        if (args != null) {
            RequestAction[] actions = this.requestActions;
            if (actions.length != args.length) {
                throw new IllegalArgumentException("Argument count (" + args.length + ") doesn't match action count (" + actions.length + ")");
            }
            int count = args.length;
            for (int i = 0; i < count; ++i) {
                actions[i].perform(requestBuilder, args[i]);
            }
        }
        return requestBuilder.build();
    }
}

