/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import okhttp3.MediaType;
import retrofit2.BaseUrl;
import retrofit2.Converter;
import retrofit2.RequestAction;
import retrofit2.RequestFactory;
import retrofit2.Retrofit;
import retrofit2.Types;
import retrofit2.Utils;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.OPTIONS;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

final class RequestFactoryParser {
    private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    private final Method method;
    private String httpMethod;
    private boolean hasBody;
    private boolean isFormEncoded;
    private boolean isMultipart;
    private String relativeUrl;
    private okhttp3.Headers headers;
    private MediaType contentType;
    private RequestAction[] requestActions;
    private Set<String> relativeUrlParamNames;

    static RequestFactory parse(Method method, Type responseType, Retrofit retrofit) {
        RequestFactoryParser parser = new RequestFactoryParser(method);
        Annotation[] methodAnnotations = method.getAnnotations();
        parser.parseMethodAnnotations(responseType, methodAnnotations);
        parser.parseParameters(retrofit, methodAnnotations);
        return parser.toRequestFactory(retrofit.baseUrl());
    }

    private RequestFactoryParser(Method method) {
        this.method = method;
    }

    private RequestFactory toRequestFactory(BaseUrl baseUrl) {
        return new RequestFactory(this.httpMethod, baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart, this.requestActions);
    }

    private RuntimeException parameterError(Throwable cause, int index, String message, Object ... args) {
        return Utils.methodError(cause, this.method, message + " (parameter #" + (index + 1) + ")", args);
    }

    private RuntimeException parameterError(int index, String message, Object ... args) {
        return Utils.methodError(this.method, message + " (parameter #" + (index + 1) + ")", args);
    }

    private void parseMethodAnnotations(Type responseType, Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (annotation instanceof DELETE) {
                this.parseHttpMethodAndPath("DELETE", ((DELETE)annotation).value(), false);
                continue;
            }
            if (annotation instanceof GET) {
                this.parseHttpMethodAndPath("GET", ((GET)annotation).value(), false);
                continue;
            }
            if (annotation instanceof HEAD) {
                this.parseHttpMethodAndPath("HEAD", ((HEAD)annotation).value(), false);
                if (Void.class.equals((Object)responseType)) continue;
                throw Utils.methodError(this.method, "HEAD method must use Void as response type.", new Object[0]);
            }
            if (annotation instanceof PATCH) {
                this.parseHttpMethodAndPath("PATCH", ((PATCH)annotation).value(), true);
                continue;
            }
            if (annotation instanceof POST) {
                this.parseHttpMethodAndPath("POST", ((POST)annotation).value(), true);
                continue;
            }
            if (annotation instanceof PUT) {
                this.parseHttpMethodAndPath("PUT", ((PUT)annotation).value(), true);
                continue;
            }
            if (annotation instanceof OPTIONS) {
                this.parseHttpMethodAndPath("OPTIONS", ((OPTIONS)annotation).value(), false);
                continue;
            }
            if (annotation instanceof HTTP) {
                HTTP http = (HTTP)annotation;
                this.parseHttpMethodAndPath(http.method(), http.path(), http.hasBody());
                continue;
            }
            if (annotation instanceof Headers) {
                String[] headersToParse = ((Headers)annotation).value();
                if (headersToParse.length == 0) {
                    throw Utils.methodError(this.method, "@Headers annotation is empty.", new Object[0]);
                }
                this.headers = this.parseHeaders(headersToParse);
                continue;
            }
            if (annotation instanceof Multipart) {
                if (this.isFormEncoded) {
                    throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isMultipart = true;
                continue;
            }
            if (!(annotation instanceof FormUrlEncoded)) continue;
            if (this.isMultipart) {
                throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
            }
            this.isFormEncoded = true;
        }
        if (this.httpMethod == null) {
            throw Utils.methodError(this.method, "HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
        }
        if (!this.hasBody) {
            if (this.isMultipart) {
                throw Utils.methodError(this.method, "Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
            if (this.isFormEncoded) {
                throw Utils.methodError(this.method, "FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
        }
    }

    private void parseHttpMethodAndPath(String httpMethod, String value, boolean hasBody) {
        String queryParams;
        Matcher queryParamMatcher;
        if (this.httpMethod != null) {
            throw Utils.methodError(this.method, "Only one HTTP method is allowed. Found: %s and %s.", this.httpMethod, httpMethod);
        }
        this.httpMethod = httpMethod;
        this.hasBody = hasBody;
        if (value.isEmpty()) {
            return;
        }
        int question = value.indexOf(63);
        if (question != -1 && question < value.length() - 1 && (queryParamMatcher = PARAM_URL_REGEX.matcher(queryParams = value.substring(question + 1))).find()) {
            throw Utils.methodError(this.method, "URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", queryParams);
        }
        this.relativeUrl = value;
        this.relativeUrlParamNames = RequestFactoryParser.parsePathParameters(value);
    }

    private okhttp3.Headers parseHeaders(String[] headers) {
        Headers.Builder builder = new Headers.Builder();
        for (String header : headers) {
            int colon = header.indexOf(58);
            if (colon == -1 || colon == 0 || colon == header.length() - 1) {
                throw Utils.methodError(this.method, "@Headers value must be in the form \"Name: Value\". Found: \"%s\"", header);
            }
            String headerName = header.substring(0, colon);
            String headerValue = header.substring(colon + 1).trim();
            if ("Content-Type".equalsIgnoreCase(headerName)) {
                this.contentType = MediaType.parse((String)headerValue);
                continue;
            }
            builder.add(headerName, headerValue);
        }
        return builder.build();
    }

    private void parseParameters(Retrofit retrofit, Annotation[] methodAnnotations) {
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        Annotation[][] parameterAnnotationsArray = this.method.getParameterAnnotations();
        boolean gotField = false;
        boolean gotPart = false;
        boolean gotBody = false;
        boolean gotPath = false;
        boolean gotQuery = false;
        boolean gotUrl = false;
        int count = parameterAnnotationsArray.length;
        RequestAction[] requestActions = new RequestAction[count];
        for (int i = 0; i < count; ++i) {
            Type parameterType = parameterTypes[i];
            if (Utils.hasUnresolvableType(parameterType)) {
                throw this.parameterError(i, "Parameter type must not include a type variable or wildcard: %s", parameterType);
            }
            Annotation[] parameterAnnotations = parameterAnnotationsArray[i];
            if (parameterAnnotations != null) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    Converter converter;
                    Class<?> arrayComponentType;
                    Type iterableType;
                    ParameterizedType parameterizedType;
                    Converter valueConverter;
                    Type valueType;
                    Type keyType;
                    Type mapType;
                    Class<?> rawParameterType;
                    Converter converter2;
                    Converter converter3;
                    Class<?> arrayComponentType2;
                    Converter converter4;
                    Type iterableType2;
                    ParameterizedType parameterizedType2;
                    Class<?> rawParameterType2;
                    String name;
                    RequestAction action = null;
                    if (parameterAnnotation instanceof Url) {
                        if (gotUrl) {
                            throw this.parameterError(i, "Multiple @Url method annotations found.", new Object[0]);
                        }
                        if (gotPath) {
                            throw this.parameterError(i, "@Path parameters may not be used with @Url.", new Object[0]);
                        }
                        if (gotQuery) {
                            throw this.parameterError(i, "A @Url parameter must not come after a @Query", new Object[0]);
                        }
                        if (this.relativeUrl != null) {
                            throw this.parameterError(i, "@Url cannot be used with @%s URL", this.httpMethod);
                        }
                        if (parameterType == String.class) {
                            action = new RequestAction.StringUrl();
                        } else if (parameterType == URI.class) {
                            action = new RequestAction.JavaUriUrl();
                        } else if (parameterType instanceof Class && "android.net.Uri".equals(((Class)parameterType).getCanonicalName())) {
                            action = new RequestAction.AndroidUriUrl();
                        } else {
                            throw this.parameterError(i, "@Url must be String, java.net.URI, or android.net.Uri type.", new Object[0]);
                        }
                        gotUrl = true;
                    } else if (parameterAnnotation instanceof Path) {
                        if (gotQuery) {
                            throw this.parameterError(i, "A @Path parameter must not come after a @Query.", new Object[0]);
                        }
                        if (gotUrl) {
                            throw this.parameterError(i, "@Path parameters may not be used with @Url.", new Object[0]);
                        }
                        if (this.relativeUrl == null) {
                            throw this.parameterError(i, "@Path can only be used with relative url on @%s", this.httpMethod);
                        }
                        gotPath = true;
                        Path path = (Path)parameterAnnotation;
                        name = path.value();
                        this.validatePathName(i, name);
                        Converter converter5 = retrofit.stringConverter(parameterType, parameterAnnotations);
                        action = new RequestAction.Path(name, converter5, path.encoded());
                    } else if (parameterAnnotation instanceof Query) {
                        Query query = (Query)parameterAnnotation;
                        name = query.value();
                        boolean encoded = query.encoded();
                        rawParameterType2 = Types.getRawType(parameterType);
                        if (Iterable.class.isAssignableFrom(rawParameterType2)) {
                            if (!(parameterType instanceof ParameterizedType)) {
                                throw this.parameterError(i, rawParameterType2.getSimpleName() + " must include generic type (e.g., " + rawParameterType2.getSimpleName() + "<String>)", new Object[0]);
                            }
                            parameterizedType2 = (ParameterizedType)parameterType;
                            iterableType2 = Utils.getParameterUpperBound(0, parameterizedType2);
                            converter4 = retrofit.stringConverter(iterableType2, parameterAnnotations);
                            action = new RequestAction.Query(name, converter4, encoded).iterable();
                        } else if (rawParameterType2.isArray()) {
                            arrayComponentType2 = RequestFactoryParser.boxIfPrimitive(rawParameterType2.getComponentType());
                            converter3 = retrofit.stringConverter(arrayComponentType2, parameterAnnotations);
                            action = new RequestAction.Query(name, converter3, encoded).array();
                        } else {
                            converter2 = retrofit.stringConverter(parameterType, parameterAnnotations);
                            action = new RequestAction.Query(name, converter2, encoded);
                        }
                        gotQuery = true;
                    } else if (parameterAnnotation instanceof QueryMap) {
                        rawParameterType = Types.getRawType(parameterType);
                        if (!Map.class.isAssignableFrom(rawParameterType)) {
                            throw this.parameterError(i, "@QueryMap parameter type must be Map.", new Object[0]);
                        }
                        mapType = Types.getSupertype(parameterType, rawParameterType, Map.class);
                        if (!(mapType instanceof ParameterizedType)) {
                            throw this.parameterError(i, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                        }
                        ParameterizedType parameterizedType3 = (ParameterizedType)mapType;
                        keyType = Utils.getParameterUpperBound(0, parameterizedType3);
                        if (String.class != keyType) {
                            throw this.parameterError(i, "@QueryMap keys must be of type String: " + keyType, new Object[0]);
                        }
                        valueType = Utils.getParameterUpperBound(1, parameterizedType3);
                        valueConverter = retrofit.stringConverter(valueType, parameterAnnotations);
                        QueryMap queryMap = (QueryMap)parameterAnnotation;
                        action = new RequestAction.QueryMap(valueConverter, queryMap.encoded());
                    } else if (parameterAnnotation instanceof Header) {
                        Header header = (Header)parameterAnnotation;
                        name = header.value();
                        Class<?> rawParameterType3 = Types.getRawType(parameterType);
                        if (Iterable.class.isAssignableFrom(rawParameterType3)) {
                            if (!(parameterType instanceof ParameterizedType)) {
                                throw this.parameterError(i, rawParameterType3.getSimpleName() + " must include generic type (e.g., " + rawParameterType3.getSimpleName() + "<String>)", new Object[0]);
                            }
                            parameterizedType = (ParameterizedType)parameterType;
                            iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                            converter3 = retrofit.stringConverter(iterableType, parameterAnnotations);
                            action = new RequestAction.Header(name, converter3).iterable();
                        } else if (rawParameterType3.isArray()) {
                            arrayComponentType = RequestFactoryParser.boxIfPrimitive(rawParameterType3.getComponentType());
                            converter2 = retrofit.stringConverter(arrayComponentType, parameterAnnotations);
                            action = new RequestAction.Header(name, converter2).array();
                        } else {
                            converter = retrofit.stringConverter(parameterType, parameterAnnotations);
                            action = new RequestAction.Header(name, converter);
                        }
                    } else if (parameterAnnotation instanceof Field) {
                        if (!this.isFormEncoded) {
                            throw this.parameterError(i, "@Field parameters can only be used with form encoding.", new Object[0]);
                        }
                        Field field = (Field)parameterAnnotation;
                        name = field.value();
                        boolean encoded = field.encoded();
                        rawParameterType2 = Types.getRawType(parameterType);
                        if (Iterable.class.isAssignableFrom(rawParameterType2)) {
                            if (!(parameterType instanceof ParameterizedType)) {
                                throw this.parameterError(i, rawParameterType2.getSimpleName() + " must include generic type (e.g., " + rawParameterType2.getSimpleName() + "<String>)", new Object[0]);
                            }
                            parameterizedType2 = (ParameterizedType)parameterType;
                            iterableType2 = Utils.getParameterUpperBound(0, parameterizedType2);
                            converter4 = retrofit.stringConverter(iterableType2, parameterAnnotations);
                            action = new RequestAction.Field(name, converter4, encoded).iterable();
                        } else if (rawParameterType2.isArray()) {
                            arrayComponentType2 = RequestFactoryParser.boxIfPrimitive(rawParameterType2.getComponentType());
                            converter3 = retrofit.stringConverter(arrayComponentType2, parameterAnnotations);
                            action = new RequestAction.Field(name, converter3, encoded).array();
                        } else {
                            converter2 = retrofit.stringConverter(parameterType, parameterAnnotations);
                            action = new RequestAction.Field(name, converter2, encoded);
                        }
                        gotField = true;
                    } else if (parameterAnnotation instanceof FieldMap) {
                        if (!this.isFormEncoded) {
                            throw this.parameterError(i, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
                        }
                        rawParameterType = Types.getRawType(parameterType);
                        if (!Map.class.isAssignableFrom(rawParameterType)) {
                            throw this.parameterError(i, "@FieldMap parameter type must be Map.", new Object[0]);
                        }
                        mapType = Types.getSupertype(parameterType, rawParameterType, Map.class);
                        if (!(mapType instanceof ParameterizedType)) {
                            throw this.parameterError(i, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                        }
                        ParameterizedType parameterizedType4 = (ParameterizedType)mapType;
                        keyType = Utils.getParameterUpperBound(0, parameterizedType4);
                        if (String.class != keyType) {
                            throw this.parameterError(i, "@FieldMap keys must be of type String: " + keyType, new Object[0]);
                        }
                        valueType = Utils.getParameterUpperBound(1, parameterizedType4);
                        valueConverter = retrofit.stringConverter(valueType, parameterAnnotations);
                        FieldMap fieldMap = (FieldMap)parameterAnnotation;
                        action = new RequestAction.FieldMap(valueConverter, fieldMap.encoded());
                        gotField = true;
                    } else if (parameterAnnotation instanceof Part) {
                        if (!this.isMultipart) {
                            throw this.parameterError(i, "@Part parameters can only be used with multipart encoding.", new Object[0]);
                        }
                        Part part = (Part)parameterAnnotation;
                        okhttp3.Headers headers = okhttp3.Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + part.value() + "\"", "Content-Transfer-Encoding", part.encoding()});
                        Class<?> rawParameterType4 = Types.getRawType(parameterType);
                        if (Iterable.class.isAssignableFrom(rawParameterType4)) {
                            if (!(parameterType instanceof ParameterizedType)) {
                                throw this.parameterError(i, rawParameterType4.getSimpleName() + " must include generic type (e.g., " + rawParameterType4.getSimpleName() + "<String>)", new Object[0]);
                            }
                            parameterizedType = (ParameterizedType)parameterType;
                            iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                            converter3 = retrofit.requestBodyConverter(iterableType, parameterAnnotations, methodAnnotations);
                            action = new RequestAction.Part(headers, converter3).iterable();
                        } else if (rawParameterType4.isArray()) {
                            arrayComponentType = RequestFactoryParser.boxIfPrimitive(rawParameterType4.getComponentType());
                            converter2 = retrofit.requestBodyConverter(arrayComponentType, parameterAnnotations, methodAnnotations);
                            action = new RequestAction.Part(headers, converter2).array();
                        } else {
                            converter = retrofit.requestBodyConverter(parameterType, parameterAnnotations, methodAnnotations);
                            action = new RequestAction.Part(headers, converter);
                        }
                        gotPart = true;
                    } else if (parameterAnnotation instanceof PartMap) {
                        if (!this.isMultipart) {
                            throw this.parameterError(i, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
                        }
                        rawParameterType = Types.getRawType(parameterType);
                        if (!Map.class.isAssignableFrom(rawParameterType)) {
                            throw this.parameterError(i, "@PartMap parameter type must be Map.", new Object[0]);
                        }
                        mapType = Types.getSupertype(parameterType, rawParameterType, Map.class);
                        if (!(mapType instanceof ParameterizedType)) {
                            throw this.parameterError(i, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                        }
                        ParameterizedType parameterizedType5 = (ParameterizedType)mapType;
                        keyType = Utils.getParameterUpperBound(0, parameterizedType5);
                        if (String.class != keyType) {
                            throw this.parameterError(i, "@PartMap keys must be of type String: " + keyType, new Object[0]);
                        }
                        valueType = Utils.getParameterUpperBound(1, parameterizedType5);
                        valueConverter = retrofit.requestBodyConverter(valueType, parameterAnnotations, methodAnnotations);
                        PartMap partMap = (PartMap)parameterAnnotation;
                        action = new RequestAction.PartMap(valueConverter, partMap.encoding());
                        gotPart = true;
                    } else if (parameterAnnotation instanceof Body) {
                        Converter converter6;
                        if (this.isFormEncoded || this.isMultipart) {
                            throw this.parameterError(i, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
                        }
                        if (gotBody) {
                            throw this.parameterError(i, "Multiple @Body method annotations found.", new Object[0]);
                        }
                        try {
                            converter6 = retrofit.requestBodyConverter(parameterType, parameterAnnotations, methodAnnotations);
                        }
                        catch (RuntimeException e) {
                            throw this.parameterError(e, i, "Unable to create @Body converter for %s", parameterType);
                        }
                        action = new RequestAction.Body(converter6);
                        gotBody = true;
                    }
                    if (action == null) continue;
                    if (requestActions[i] != null) {
                        throw this.parameterError(i, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
                    }
                    requestActions[i] = action;
                }
            }
            if (requestActions[i] != null) continue;
            throw this.parameterError(i, "No Retrofit annotation found.", new Object[0]);
        }
        if (this.relativeUrl == null && !gotUrl) {
            throw Utils.methodError(this.method, "Missing either @%s URL or @Url parameter.", this.httpMethod);
        }
        if (!this.isFormEncoded && !this.isMultipart && !this.hasBody && gotBody) {
            throw Utils.methodError(this.method, "Non-body HTTP method cannot contain @Body.", new Object[0]);
        }
        if (this.isFormEncoded && !gotField) {
            throw Utils.methodError(this.method, "Form-encoded method must contain at least one @Field.", new Object[0]);
        }
        if (this.isMultipart && !gotPart) {
            throw Utils.methodError(this.method, "Multipart method must contain at least one @Part.", new Object[0]);
        }
        this.requestActions = requestActions;
    }

    private void validatePathName(int index, String name) {
        if (!PARAM_NAME_REGEX.matcher(name).matches()) {
            throw this.parameterError(index, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name);
        }
        if (!this.relativeUrlParamNames.contains(name)) {
            throw this.parameterError(index, "URL \"%s\" does not contain \"{%s}\".", this.relativeUrl, name);
        }
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }

    private static Class<?> boxIfPrimitive(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        return type;
    }
}

