/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Response<T> {
    private final okhttp3.Response rawResponse;
    private final T body;
    private final ResponseBody errorBody;

    public static <T> Response<T> success(T body) {
        return Response.success(body, new Response.Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost").build()).build());
    }

    public static <T> Response<T> success(T body, okhttp3.Response rawResponse) {
        if (rawResponse == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (!rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse must be successful response");
        }
        return new Response<T>(rawResponse, body, null);
    }

    public static <T> Response<T> error(int code, ResponseBody body) {
        if (code < 400) {
            throw new IllegalArgumentException("code < 400: " + code);
        }
        return Response.error(body, new Response.Builder().code(code).protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost").build()).build());
    }

    public static <T> Response<T> error(ResponseBody body, okhttp3.Response rawResponse) {
        if (body == null) {
            throw new NullPointerException("body == null");
        }
        if (rawResponse == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse should not be successful response");
        }
        return new Response<Object>(rawResponse, null, body);
    }

    private Response(okhttp3.Response rawResponse, T body, ResponseBody errorBody) {
        this.rawResponse = rawResponse;
        this.body = body;
        this.errorBody = errorBody;
    }

    public okhttp3.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccess() {
        return this.rawResponse.isSuccessful();
    }

    public T body() {
        return this.body;
    }

    public ResponseBody errorBody() {
        return this.errorBody;
    }
}

