/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.sort;

import com.squareup.sort.internal.VersionNumber;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\"\u0010\u001b\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/squareup/sort/SortDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "execOps", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "buildScript", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildScript", "()Lorg/gradle/api/file/RegularFileProperty;", "insertBlankLines", "Lorg/gradle/api/provider/Property;", "", "getInsertBlankLines", "()Lorg/gradle/api/provider/Property;", "mode", "", "getMode", "sortProgram", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSortProgram", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "verbose", "getVerbose", "version", "getVersion", "action", "", "option", "", "name", "value", "sort-dependencies-gradle-plugin"})
public abstract class SortDependenciesTask
extends DefaultTask {
    @NotNull
    private final ExecOperations execOps;

    @Inject
    public SortDependenciesTask(@NotNull ExecOperations execOps) {
        Intrinsics.checkNotNullParameter((Object)execOps, (String)"execOps");
        this.execOps = execOps;
        this.setGroup("verification");
        this.setDescription("Sorts the dependencies block in a Gradle build script");
        this.doNotTrackState("This task modifies build scripts in place.");
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getBuildScript();

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getSortProgram();

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<String> getMode();

    @Optional
    @Option(option="verbose", description="Enables verbose logging.")
    @Input
    @NotNull
    public abstract Property<Boolean> getVerbose();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getInsertBlankLines();

    @TaskAction
    public final void action() {
        String buildScript = ((RegularFile)this.getBuildScript().get()).getAsFile().getAbsolutePath();
        String mode = (String)this.getMode().getOrElse((Object)"sort");
        Boolean verbose = (Boolean)this.getVerbose().getOrElse((Object)false);
        Boolean insertBlankLines = (Boolean)this.getInsertBlankLines().getOrElse((Object)true);
        if (!Intrinsics.areEqual((Object)mode, (Object)"check") && !Intrinsics.areEqual((Object)mode, (Object)"sort")) {
            throw new InvalidUserDataException("Mode must be 'sort' or 'check'. Was '" + mode + "'.");
        }
        this.getLogger().info("Sorting '" + buildScript + "' using mode '" + mode + "'.");
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        VersionNumber version = VersionNumber.Companion.parse(StringsKt.removeSuffix((String)((String)object), (CharSequence)"-SNAPSHOT"));
        this.execOps.javaexec(new Action(this, buildScript, mode, version, verbose, insertBlankLines){
            final /* synthetic */ SortDependenciesTask this$0;
            final /* synthetic */ String $buildScript;
            final /* synthetic */ String $mode;
            final /* synthetic */ VersionNumber $version;
            final /* synthetic */ Boolean $verbose;
            final /* synthetic */ Boolean $insertBlankLines;
            {
                this.this$0 = $receiver;
                this.$buildScript = $buildScript;
                this.$mode = $mode;
                this.$version = $version;
                this.$verbose = $verbose;
                this.$insertBlankLines = $insertBlankLines;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(JavaExecSpec javaExecSpec) {
                void $this$execute_u24lambda_u241_u24lambda_u240;
                List list;
                SortDependenciesTask sortDependenciesTask = this.this$0;
                String string = this.$buildScript;
                String string2 = this.$mode;
                VersionNumber versionNumber = this.$version;
                Boolean bl = this.$verbose;
                Boolean bl2 = this.$insertBlankLines;
                JavaExecSpec $this$execute_u24lambda_u241 = javaExecSpec;
                boolean bl3 = false;
                $this$execute_u24lambda_u241.getMainClass().set((Object)"com.squareup.sort.MainKt");
                $this$execute_u24lambda_u241.setClasspath((FileCollection)sortDependenciesTask.getSortProgram());
                List list2 = list = CollectionsKt.createListBuilder();
                JavaExecSpec javaExecSpec2 = $this$execute_u24lambda_u241;
                boolean bl4 = false;
                $this$execute_u24lambda_u241_u24lambda_u240.add(string);
                Intrinsics.checkNotNull((Object)string2);
                SortDependenciesTask.access$option(sortDependenciesTask, (List)$this$execute_u24lambda_u241_u24lambda_u240, "--mode", string2);
                if (versionNumber.compareTo(VersionNumber.Companion.parse("0.8")) > 0) {
                    SortDependenciesTask.access$option(sortDependenciesTask, (List)$this$execute_u24lambda_u241_u24lambda_u240, "--context", "gradle");
                }
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue()) {
                    if (versionNumber.compareTo(VersionNumber.Companion.parse("0.3")) < 0) {
                        sortDependenciesTask.getLogger().warn("--verbose specified by version < 0.3. Ignoring flag.");
                    } else {
                        $this$execute_u24lambda_u241_u24lambda_u240.add("--verbose");
                    }
                }
                if (!bl2.booleanValue()) {
                    $this$execute_u24lambda_u241_u24lambda_u240.add("--no-blank-lines");
                }
                javaExecSpec2.setArgs(CollectionsKt.build((List)list));
            }
        });
    }

    private final void option(List<String> $this$option, String name, String value) {
        $this$option.add(name);
        $this$option.add(value);
    }

    public static final /* synthetic */ void access$option(SortDependenciesTask $this, List $receiver, String name, String value) {
        $this.option($receiver, name, value);
    }
}

