/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.IDevice;
import com.google.common.base.Strings;
import com.squareup.spoon.DeviceUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class DeviceDetails {
    public static final int UNKNOWN_API_LEVEL = 0;
    public static final int MARSHMALLOW_API_LEVEL = 23;
    private final String model;
    private final String manufacturer;
    private final String version;
    private final int apiLevel;
    private final String language;
    private final String region;
    private final boolean isEmulator;
    private final String avdName;

    private DeviceDetails(String model, String manufacturer, String version, int apiLevel, String language, String region, boolean emulator, String avdName) {
        this.model = model;
        this.manufacturer = manufacturer;
        this.version = version;
        this.apiLevel = apiLevel;
        this.language = language;
        this.region = region;
        this.isEmulator = emulator;
        this.avdName = avdName;
    }

    public String getName() {
        if (this.isEmulator) {
            return this.avdName;
        }
        return this.manufacturer + " " + this.model;
    }

    public String getModel() {
        return this.model;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getVersion() {
        return this.version;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isEmulator() {
        return this.isEmulator;
    }

    public String getAvdName() {
        return this.avdName;
    }

    static DeviceDetails createForDevice(IDevice device) {
        String manufacturer = Strings.emptyToNull((String)device.getProperty("ro.product.manufacturer"));
        String model = Strings.emptyToNull((String)device.getProperty("ro.product.model"));
        model = DeviceUtils.scrubModel(manufacturer, model);
        String version = Strings.emptyToNull((String)device.getProperty("ro.build.version.release"));
        String api = Strings.emptyToNull((String)device.getProperty("ro.build.version.sdk"));
        int apiLevel = api != null ? Integer.parseInt(api) : 0;
        String language = Strings.emptyToNull((String)device.getProperty("ro.product.locale.language"));
        language = DeviceUtils.scrubLanguage(language);
        String region = Strings.emptyToNull((String)device.getProperty("ro.product.locale.region"));
        boolean emulator = device.isEmulator();
        String avdName = Strings.emptyToNull((String)device.getAvdName());
        return new DeviceDetails(model, manufacturer, version, apiLevel, language, region, emulator, avdName);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

